/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.internal.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ptp.cell.debug.Debug;

public class XLCErrorParser
implements IErrorParser {
    Pattern p1 = Pattern.compile("\"([^\"]*)\",\\s*line\\s*(\\d+)\\s*\\.\\s*(\\d+)\\s*\\:\\s*(\\d+)\\s*\\-\\s*(\\d+)\\s*\\((\\w)\\)\\s*(.*)");
    Pattern p2 = Pattern.compile("([^:]*):\\s*(\\d+)\\s*\\-\\s*(\\d+)\\s*(.*)");

    public boolean processLine(String line, ErrorParserManager eoParser) {
        Debug.POLICY.enter(Debug.DEBUG_ERRORPARSERS, new Object[]{line, eoParser});
        Matcher matcher = this.p1.matcher(line);
        if (matcher.matches()) {
            Debug.POLICY.trace(Debug.DEBUG_ERRORPARSERS, "Matched rule p1");
            String fileName = matcher.group(1);
            IFile file = eoParser.findFileName(fileName);
            int lineNumber = Integer.parseInt(matcher.group(2));
            String errorMessage = matcher.group(7);
            int severity = 3;
            String severityChar = matcher.group(6);
            if (severityChar.equals("I")) {
                severity = 0;
            } else if (severityChar.equals("W")) {
                severity = 1;
            } else if (severityChar.equals("E")) {
                severity = 3;
            } else if (severityChar.equals("S")) {
                severity = 3;
            } else if (severityChar.equals("U")) {
                severity = 3;
            }
            String varName = null;
            Debug.POLICY.trace(Debug.DEBUG_ERRORPARSERS, "New error: file={0}, lineNumber={1}, errorMessage={2}, severity={3}, varName={4}", new Object[]{file, lineNumber, errorMessage, severity, varName});
            eoParser.generateMarker((IResource)file, lineNumber, errorMessage, severity, varName);
            Debug.POLICY.exit(Debug.DEBUG_ERRORPARSERS, (Object)true);
            return true;
        }
        matcher = this.p2.matcher(line);
        if (matcher.matches()) {
            Debug.POLICY.trace(Debug.DEBUG_ERRORPARSERS, "Matched rule p2");
            IResource file = null;
            int lineNumber = -1;
            String errorMessage = matcher.group(4);
            int severity = 3;
            String varName = null;
            Debug.POLICY.trace(Debug.DEBUG_ERRORPARSERS, "New error: file={0}, lineNumber={1}, errorMessage={2}, severity={3}, varName={4}", new Object[]{file, lineNumber, errorMessage, severity, varName});
            eoParser.generateMarker(file, lineNumber, errorMessage, severity, varName);
            Debug.POLICY.exit(Debug.DEBUG_ERRORPARSERS, (Object)true);
            return true;
        }
        Debug.POLICY.exit(Debug.DEBUG_ERRORPARSERS, (Object)false);
        return false;
    }
}

