/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.sourcelookup;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLookupDirector;
import org.eclipse.ptp.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.ptp.debug.internal.core.sourcelookup.PDirectorySourceContainer;
import org.eclipse.ptp.debug.internal.core.sourcelookup.PSourceLookupParticipant;

public class PSourceLookupDirector
extends AbstractSourceLookupDirector
implements IPSourceLookupDirector {
    private static Set<String> fSupportedTypes = new HashSet<String>();

    static {
        fSupportedTypes.add(WorkspaceSourceContainer.TYPE_ID);
        fSupportedTypes.add(ProjectSourceContainer.TYPE_ID);
        fSupportedTypes.add(FolderSourceContainer.TYPE_ID);
        fSupportedTypes.add(DirectorySourceContainer.TYPE_ID);
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new PSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return fSupportedTypes.contains(type.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(IPBreakpoint breakpoint) {
        try {
            String handle = breakpoint.getSourceHandle();
            ISourceContainer[] containers = this.getSourceContainers();
            int i = 0;
            while (true) {
                if (i >= containers.length) {
                    return false;
                }
                if (this.contains(containers[i], handle)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public boolean contains(IProject project) {
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            if (this.contains(containers[i], project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contains(ISourceContainer container, IProject project) {
        if (container instanceof ProjectSourceContainer && ((ProjectSourceContainer)container).getProject().equals((Object)project)) {
            return true;
        }
        try {
            ISourceContainer[] containers = container.getSourceContainers();
            int i = 0;
            while (true) {
                if (i >= containers.length) {
                    return false;
                }
                if (this.contains(containers[i], project)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contains(ISourceContainer container, String sourceName) {
        IContainer folder;
        IPath folderPath;
        IProject project;
        IPath projPath;
        Path path = new Path(sourceName);
        if (!path.isValidPath(sourceName)) {
            return false;
        }
        if (container instanceof ProjectSourceContainer && (projPath = (project = ((ProjectSourceContainer)container).getProject()).getLocation()).isPrefixOf((IPath)path)) {
            IFile file = ((ProjectSourceContainer)container).getProject().getFile(path.removeFirstSegments(projPath.segmentCount()));
            if (file == null) return false;
            if (!file.exists()) return false;
            return true;
        }
        if (container instanceof FolderSourceContainer && (folderPath = (folder = ((FolderSourceContainer)container).getContainer()).getLocation()).isPrefixOf((IPath)path)) {
            IFile file = ((FolderSourceContainer)container).getContainer().getFile(path.removeFirstSegments(folderPath.segmentCount()));
            if (file == null) return false;
            if (!file.exists()) return false;
            return true;
        }
        if (container instanceof PDirectorySourceContainer) {
            File dir = ((PDirectorySourceContainer)container).getDirectory();
            boolean searchSubfolders = ((PDirectorySourceContainer)container).searchSubfolders();
            Path dirPath = new Path(dir.getAbsolutePath());
            if (searchSubfolders) return dirPath.isPrefixOf((IPath)path);
            if (dirPath.segmentCount() + 1 == path.segmentCount()) {
                return dirPath.isPrefixOf((IPath)path);
            }
        }
        if (container instanceof MappingSourceContainer) {
            if (((MappingSourceContainer)container).getCompilationPath(sourceName) == null) return false;
            return true;
        }
        try {
            ISourceContainer[] containers = container.getSourceContainers();
            int i = 0;
            while (true) {
                if (i >= containers.length) {
                    return false;
                }
                if (this.contains(containers[i], sourceName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public IPath getCompilationPath(String sourceName) {
        IPath path = null;
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            IPath cp = this.getCompilationPath(containers[i], sourceName);
            if (cp != null) {
                path = cp;
                break;
            }
            ++i;
        }
        return path;
    }

    private IPath getCompilationPath(ISourceContainer container, String sourceName) {
        IPath path = null;
        if (container instanceof MappingSourceContainer) {
            path = ((MappingSourceContainer)container).getCompilationPath(sourceName);
        } else {
            try {
                ISourceContainer[] containers = container.getSourceContainers();
                int i = 0;
                while (i < containers.length) {
                    path = this.getCompilationPath(containers[i], sourceName);
                    if (path == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return path;
    }
}

