/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.launcher.pdt.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.ptp.cell.environment.launcher.pdt.debug.Debug;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.IPdtLaunchAttributes;
import org.eclipse.ptp.cell.environment.launcher.pdt.ui.Messages;
import org.eclipse.ptp.cell.environment.launcher.pdt.ui.PdtEnvironmentTab;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.FrameMold;
import org.eclipse.ptp.utils.ui.swt.TextGroup;
import org.eclipse.ptp.utils.ui.swt.TextMold;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PdtSystemEnvironmentTab
extends AbstractLaunchConfigurationTab {
    Frame pdtSystemInfo;
    TextGroup traceLibDirPath;
    TextGroup pdtModulePath;

    public void createControl(Composite parent) {
        Composite topControl = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topControl.setLayout((Layout)topLayout);
        this.setControl((Control)topControl);
        PdtModifyListener pdtModifyListener = new PdtModifyListener();
        FrameMold frMold = new FrameMold(Messages.getString("PdtSystemEnvironmentTab.FrameControl_Label_PdtSystemInfo"));
        TextMold tmold = new TextMold(TextMold.GRID_DATA_SPAN | TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE | TextMold.LABELABOVE, Messages.getString("PdtSystemEnvironmentTab.TextControl_Label_TraceLibPath"));
        this.pdtSystemInfo = new Frame(topControl, frMold);
        this.traceLibDirPath = new TextGroup(this.pdtSystemInfo.getTopUserReservedComposite(), tmold);
        this.traceLibDirPath.addModifyListener((ModifyListener)pdtModifyListener);
        tmold.setLabel(Messages.getString("PdtSystemEnvironmentTab.TextControl_Label_PdtKernelModulePath"));
        this.pdtModulePath = new TextGroup(this.pdtSystemInfo.getTopUserReservedComposite(), tmold);
        this.pdtModulePath.addModifyListener((ModifyListener)pdtModifyListener);
    }

    public String getName() {
        return Messages.getString("PdtSystemEnvironmentTab.Tab_Title_PdtSystem");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.traceLibDirPath.setString(configuration.getAttribute(IPdtLaunchAttributes.ATTR_TRACE_LIB_PATH, IPdtLaunchAttributes.DEFAULT_TRACE_LIB_PATH));
            this.pdtModulePath.setString(configuration.getAttribute(IPdtLaunchAttributes.ATTR_PDT_MODULE_PATH, IPdtLaunchAttributes.DEFAULT_PDT_MODULE_PATH));
        }
        catch (CoreException e) {
            Debug.POLICY.logError((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_TRACE_LIB_PATH, this.traceLibDirPath.getString());
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_PDT_MODULE_PATH, this.pdtModulePath.getString());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_TRACE_LIB_PATH, IPdtLaunchAttributes.DEFAULT_TRACE_LIB_PATH);
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_PDT_MODULE_PATH, IPdtLaunchAttributes.DEFAULT_PDT_MODULE_PATH);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block5: {
            Debug.read();
            if (!super.isValid(launchConfig)) {
                return false;
            }
            try {
                if (PdtEnvironmentTab.validateRemotePath(launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_PDT_MODULE_PATH, IPdtLaunchAttributes.DEFAULT_PDT_MODULE_PATH))) break block5;
                this.setErrorMessage(Messages.getString("PdtSystemEnvironmentTab.IsValid_Error_RemotePdtModulePathInvalid"));
                return false;
            }
            catch (CoreException e) {
                Debug.POLICY.logError((Throwable)e);
                return false;
            }
        }
        if (!PdtEnvironmentTab.validateRemotePath(launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_TRACE_LIB_PATH, IPdtLaunchAttributes.DEFAULT_TRACE_LIB_PATH))) {
            this.setErrorMessage(Messages.getString("PdtSystemEnvironmentTab.IsValid_Error_RemoteTraceLibDirPathInvalid"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class PdtModifyListener
    implements ModifyListener {
        private PdtModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Debug.read();
            try {
                PdtSystemEnvironmentTab.this.updateLaunchConfigurationDialog();
            }
            catch (Exception exception) {
                Debug.POLICY.logError((Throwable)exception);
            }
        }
    }
}

