/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.tau.papiselect.papic;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapiSelect {
    public static final int PRESET = 0;
    public static final int NATIVE = 1;
    private LinkedHashSet<String> avCounters = null;
    private Vector<String> counterNames = new Vector(256);
    private Vector<String> counterDefs = new Vector(256);
    private String location = "";
    private int countType = 0;

    public PapiSelect(String papiLocation, int papiCountType) {
        this.location = papiLocation;
        if (papiCountType == 0) {
            this.findPresetAvail();
        } else {
            this.findNativeAvail();
            this.countType = 1;
        }
    }

    public LinkedHashSet<Object> getGrey(Object[] checked, Object[] greyed) {
        LinkedHashSet<Object> active = new LinkedHashSet<Object>();
        LinkedHashSet<Object> greyset = new LinkedHashSet<Object>();
        LinkedHashSet<String> notgrey = new LinkedHashSet<String>(this.avCounters);
        if (checked.length > 0) {
            active.addAll((Collection)Arrays.asList(checked));
        }
        if (greyed != null && greyed.length > 0) {
            active.removeAll((Collection)Arrays.asList(greyed));
        }
        notgrey.removeAll(active);
        if (greyed != null && greyed.length > 0) {
            notgrey.removeAll((Collection)Arrays.asList(greyed));
        }
        greyset.addAll(this.getRejects(active));
        if (greyed != null && greyed.length > 0) {
            greyset.add(Arrays.asList(greyed));
        }
        return greyset;
    }

    public LinkedHashSet<String> getAvail() {
        return this.avCounters;
    }

    public Vector<String> getCounterDefs() {
        return this.counterDefs;
    }

    public Vector<String> getCounterNames() {
        return this.counterNames;
    }

    private void findPresetAvail() {
        String papi_avail = String.valueOf(this.location) + File.separator + "papi_avail";
        String s = null;
        LinkedHashSet<String> avail = new LinkedHashSet<String>();
        String holdcounter = null;
        try {
            Process p = Runtime.getRuntime().exec(papi_avail, null, null);
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = stdInput.readLine()) != null) {
                if (s.indexOf("PAPI_") != 0 || s.indexOf("\tYes\t") <= 0) continue;
                holdcounter = s.substring(0, s.indexOf("\t"));
                avail.add(holdcounter);
                this.counterNames.add(holdcounter);
                String defCounter = s.substring(s.lastIndexOf("\t") + 1);
                int lendex = 55;
                int freespace = 0;
                while (lendex < defCounter.length()) {
                    freespace = defCounter.lastIndexOf(32, lendex - 1);
                    defCounter = String.valueOf(defCounter.substring(0, freespace + 1)) + '\n' + defCounter.substring(freespace + 1);
                    lendex += 55;
                }
                this.counterDefs.add(defCounter);
            }
            boolean fault = false;
            while ((s = stdErr.readLine()) != null) {
                fault = true;
            }
            if (fault) {
                p.destroy();
                this.avCounters = null;
            }
            p.destroy();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.avCounters = avail;
    }

    private void findNativeAvail() {
        String papi_avail = String.valueOf(this.location) + File.separator + "papi_native_avail";
        String s = null;
        LinkedHashSet<String> avail = new LinkedHashSet<String>();
        String holdcounter = null;
        try {
            Process p = Runtime.getRuntime().exec(papi_avail, null, null);
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = stdInput.readLine()) != null) {
                if (s.indexOf("   0x") <= 0) continue;
                holdcounter = s.substring(0, s.indexOf(" "));
                avail.add(holdcounter);
                this.counterNames.add(holdcounter);
                String defCounter = s.substring(s.lastIndexOf("   ") + 3);
                int lendex = 55;
                int freespace = 0;
                while (lendex < defCounter.length()) {
                    freespace = defCounter.lastIndexOf(32, lendex - 1);
                    defCounter = String.valueOf(defCounter.substring(0, freespace + 1)) + '\n' + defCounter.substring(freespace + 1);
                    lendex += 55;
                }
                this.counterDefs.add(defCounter);
            }
            boolean fault = false;
            while ((s = stdErr.readLine()) != null) {
                fault = true;
            }
            if (fault) {
                p.destroy();
                this.avCounters = null;
            }
            p.destroy();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.avCounters = avail;
    }

    private LinkedHashSet<String> getRejects(LinkedHashSet<Object> selected) {
        int entryIndex = 14;
        int entryLines = 1;
        if (this.countType == 1) {
            entryIndex = 13;
            entryLines = 5;
        }
        String counterString = "PRESET";
        if (this.countType != 0) {
            counterString = "NATIVE";
        }
        String papi_event_chooser = String.valueOf(this.location) + File.separator + "papi_event_chooser " + counterString;
        if (selected != null && selected.size() > 0) {
            Iterator itsel = selected.iterator();
            while (itsel.hasNext()) {
                papi_event_chooser = String.valueOf(papi_event_chooser) + " " + (String)itsel.next();
            }
        } else {
            return new LinkedHashSet<String>(1);
        }
        String s = null;
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.avCounters);
        result.removeAll(selected);
        try {
            Process p = Runtime.getRuntime().exec(papi_event_chooser, null, null);
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int countLines = 0;
            int tabDex = 0;
            while ((s = stdInput.readLine()) != null) {
                if (++countLines < entryIndex || (countLines - entryIndex) % entryLines != 0) continue;
                tabDex = s.indexOf("\t");
                if (tabDex == -1) {
                    countLines = 0;
                    continue;
                }
                result.remove(s.substring(0, tabDex));
            }
            while ((s = stdErr.readLine()) != null) {
            }
            p.destroy();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return result;
    }
}

