/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIApplicationAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIJobAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPINodeAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMap;

public class OpenMPIProcessMapText12Parser {
    OpenMPIProcessMap map = new OpenMPIProcessMap();
    int numApplications;
    int numNodes;

    private OpenMPIProcessMapText12Parser() {
    }

    public static OpenMPIProcessMap parse(InputStream is) throws IOException {
        OpenMPIProcessMapText12Parser parser = new OpenMPIProcessMapText12Parser();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is), 1);
        parser.readLine1(reader);
        parser.readLine2(reader);
        int i = 0;
        while (i < parser.numApplications) {
            parser.readAppContext(reader);
            ++i;
        }
        parser.readLine3(reader);
        i = 0;
        while (i < parser.numNodes) {
            parser.readMappedNode(reader, i);
            ++i;
        }
        return parser.map;
    }

    private void readMappedNode(BufferedReader reader, int nodeCounter) throws IOException {
        int numProcesses;
        String nodeName;
        String line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        Pattern p = Pattern.compile("[^:]*:\\s*(\\S*)[^:]*:\\s*(\\S*)[^:]*:\\s*(\\S*)[^:]*:\\s*(\\S*).*");
        Matcher m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 4) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        try {
            String s = m.group(1);
            Integer.parseInt(s);
            nodeName = s = m.group(2);
            s = m.group(3);
            s = m.group(4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        OpenMPIProcessMap.Node node = new OpenMPIProcessMap.Node(nodeName);
        this.map.addNode(node);
        line = reader.readLine();
        line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("[^:]*:[^:]*:\\s*(\\S*).*");
        m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 1) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("[^:]*:\\s*(\\S*)[^:]*:\\s*(\\S*).*");
        m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 2) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        try {
            String s = m.group(1);
            if (s.equalsIgnoreCase("true")) {
                node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getOversubscribedAttributeDefinition().create(Boolean.valueOf(true)));
            } else if (s.equalsIgnoreCase("false")) {
                node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getOversubscribedAttributeDefinition().create(Boolean.valueOf(false)));
            } else {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
            s = m.group(2);
            numProcesses = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        int i = 0;
        while (i < numProcesses) {
            block25: {
                int applicationIndex;
                int processPid;
                int processIndex;
                line = reader.readLine();
                line = reader.readLine();
                line = reader.readLine();
                if (line == null) {
                    throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
                }
                p = Pattern.compile("[^:]*:[^:]*:\\s*(\\S*).*");
                m = p.matcher(line);
                if (!m.matches() || m.groupCount() != 1) {
                    throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
                }
                String processName = m.group(1);
                line = reader.readLine();
                if (line == null) {
                    throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
                }
                p = Pattern.compile("[^:]*:\\s*(\\S*)[^:]*:\\s*(\\S*)[^:]*:\\s*(\\S*).*");
                m = p.matcher(line);
                if (!m.matches() || m.groupCount() != 3) {
                    throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
                }
                try {
                    String s = m.group(1);
                    processIndex = Integer.parseInt(s);
                    s = m.group(2);
                    processPid = Integer.parseInt(s);
                    s = m.group(3);
                    applicationIndex = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
                }
                if (i < numProcesses - 1 || nodeCounter < this.numNodes - 1) {
                    line = reader.readLine();
                }
                OpenMPIProcessMap.Process proc = new OpenMPIProcessMap.Process(node, processIndex, processName, applicationIndex);
                this.map.addProcess(proc);
                try {
                    proc.getAttributeManager().addAttribute((IAttribute)ProcessAttributes.getPIDAttributeDefinition().create(Integer.valueOf(processPid)));
                }
                catch (IllegalValueException illegalValueException) {
                    if ($assertionsDisabled) break block25;
                    throw new AssertionError();
                }
            }
            ++i;
        }
    }

    private void readLine3(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        Pattern p = Pattern.compile("[^:]*:\\s*(\\d*).*");
        Matcher m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 1) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        try {
            String s = m.group(1);
            this.numNodes = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
    }

    private void readAppContext(BufferedReader reader) throws IOException {
        int numberOfProcessors;
        String applicationName;
        int applicationIndex;
        String s;
        String line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        Pattern p = Pattern.compile("[^:]*:\\s*\\w*\\s*(\\d*)[^:]*:\\s*(\\w*).*");
        Matcher m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 2) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        try {
            s = m.group(1);
            applicationIndex = Integer.parseInt(s);
            applicationName = s = m.group(2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("[^:]*:\\s*(\\d*).*");
        m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 1) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        try {
            s = m.group(1);
            numberOfProcessors = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        OpenMPIProcessMap.Application application = new OpenMPIProcessMap.Application(applicationIndex, applicationName, numberOfProcessors);
        this.map.addApplication(application);
        line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("\\s*Argv\\[\\d*\\]\\s*:\\s*(.*)");
        m = p.matcher(line);
        ArrayList<String> arguments = new ArrayList<String>();
        while (m.matches()) {
            arguments.add(m.group(1));
            line = reader.readLine();
            if (line == null) {
                throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
            }
            m = p.matcher(line);
        }
        application.getAttributeManager().addAttribute((IAttribute)OpenMPIApplicationAttributes.getEffectiveOpenMPIProgArgsAttributeDefinition().create((Comparable[])arguments.toArray(new String[arguments.size()])));
        line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("\\s*Env\\[\\d*\\]\\s*:\\s*(.*)");
        m = p.matcher(line);
        ArrayList<String> environment = new ArrayList<String>();
        while (m.matches()) {
            environment.add(m.group(1));
            line = reader.readLine();
            if (line == null) {
                throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
            }
            m = p.matcher(line);
        }
        application.getAttributeManager().addAttribute((IAttribute)OpenMPIApplicationAttributes.getEffectiveOpenMPIEnvAttributeDefinition().create((Comparable[])environment.toArray(new String[environment.size()])));
        p = Pattern.compile("[^:]*:\\s*(.*)");
        m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 1) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        String s2 = m.group(1).trim();
        application.getAttributeManager().addAttribute((IAttribute)OpenMPIApplicationAttributes.getEffectiveOpenMPIWorkingDirAttributeDefinition().create(s2));
        line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("[^:]*:\\s*(\\d*).*");
        m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 1) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        try {
            s2 = m.group(1);
            int num_maps = Integer.parseInt(s2);
            int i = 0;
            while (i < num_maps) {
                line = reader.readLine();
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
    }

    private void readLine2(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        Pattern p = Pattern.compile("[^:]*:\\s*(\\d*)[^:]*:\\s*(\\w*)[^:]*:\\s*(\\w*).*");
        Matcher m = p.matcher(line);
        if (!m.matches() || m.groupCount() != 3) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
        try {
            String s;
            block9: {
                block8: {
                    s = m.group(1);
                    try {
                        this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getVpidStartAttributeDefinition().create(Integer.valueOf(Integer.parseInt(s))));
                    }
                    catch (IllegalValueException illegalValueException) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                s = m.group(2);
                try {
                    this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getVpidRangeAttributeDefinition().create(Integer.valueOf(Integer.parseInt(s))));
                }
                catch (IllegalValueException illegalValueException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
            s = m.group(3);
            this.numApplications = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
        }
    }

    private void readLine1(BufferedReader reader) throws IOException {
        block9: {
            String line = reader.readLine();
            if (line == null) {
                throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_MissingDisplayMapInformation);
            }
            Pattern p = Pattern.compile("\\[([^:]*):(\\d*)\\][^:]*:\\s*(\\d*)[^:]*:\\s*(\\w*).*");
            Matcher m = p.matcher(line);
            if (!m.matches() || m.groupCount() != 4) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
            try {
                block8: {
                    this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getHostnameAttributeDefinition().create(m.group(1)));
                    try {
                        this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getMpiJobIdAttributeDefinition().create(Integer.valueOf(Integer.parseInt(m.group(3)))));
                    }
                    catch (IllegalValueException illegalValueException) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                String mode = m.group(4);
                if (mode.equalsIgnoreCase("bynode")) {
                    this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getMappingModeAttributeDefinition().create((Enum)OpenMPIJobAttributes.MappingMode.BY_NODE));
                    break block9;
                }
                if (mode.equalsIgnoreCase("byslot")) {
                    this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getMappingModeAttributeDefinition().create((Enum)OpenMPIJobAttributes.MappingMode.BY_SLOT));
                    break block9;
                }
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream("test.txt");
            OpenMPIProcessMapText12Parser.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

