/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class RelativeFileFieldEditor
extends StringButtonFieldEditor {
    IPath relativeRoot = null;
    String[] extensions = null;

    public RelativeFileFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.setErrorMessage(JFaceResources.getString((String)"FileFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.setValidateStrategy(1);
        this.createControl(parent);
    }

    public IPath getRelativeRoot() {
        return this.relativeRoot;
    }

    public void setRelativeRoot(IPath relativeRoot) {
        this.relativeRoot = relativeRoot;
    }

    public void setFileExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    private IPath getPathFromText() {
        String path = this.getTextControl().getText();
        path = path != null ? path.trim() : "";
        if (path.length() == 0 && !this.isEmptyStringAllowed()) {
            return null;
        }
        Path ipath = new Path(path);
        return ipath;
    }

    private IPath getAbsolutePathFromText() {
        IPath ipath = this.getPathFromText();
        if (ipath == null) {
            return null;
        }
        if (!ipath.isAbsolute()) {
            if (this.relativeRoot != null) {
                ipath = this.relativeRoot.append(ipath);
            } else {
                return null;
            }
        }
        return ipath;
    }

    protected boolean checkState() {
        String msg = null;
        IPath path = this.getPathFromText();
        if (path == null) {
            msg = this.getErrorMessage();
        } else {
            path = this.getAbsolutePathFromText();
            if (this.relativeRoot == null) {
                msg = JFaceResources.getString((String)"FileFieldEditor.errorMessage2");
            } else if (!path.toFile().exists()) {
                msg = this.getErrorMessage();
            } else if (!path.toFile().isFile()) {
                msg = this.getErrorMessage();
            }
        }
        if (msg != null) {
            this.showErrorMessage(msg);
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    protected String changePressed() {
        String fileName;
        File file;
        IPath path = this.getAbsolutePathFromText();
        IPath start = null;
        start = path != null ? ((file = path.toFile()).exists() ? path.removeLastSegments(1) : this.relativeRoot) : this.relativeRoot;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (path != null) {
            dialog.setFileName(path.lastSegment());
        }
        dialog.setFilterPath(start.toOSString());
        if (this.extensions != null) {
            dialog.setFilterExtensions(this.extensions);
        }
        if ((fileName = dialog.open()) != null) {
            Path newPath = new Path(fileName = fileName.trim());
            int matches = newPath.matchingFirstSegments(this.relativeRoot);
            if (matches == this.relativeRoot.segmentCount()) {
                newPath = newPath.removeFirstSegments(matches);
                newPath = newPath.makeRelative();
            }
            return newPath.toOSString();
        }
        return null;
    }
}

