/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.platform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.platform.IdentityInformation;
import org.eclipse.ptp.cell.utils.platform.Messages;

public final class Platform {
    protected static final String COMPATIBLE = "/proc/device-tree/compatible";
    protected static final String CELL_COMPATIBLE_ID = "CBEA";
    public static final String ARCH_CELL = "cell";
    public static final String LINUX_DISTRO_UNKNOWN = "unknown";
    public static final String LINUX_DISTRO_FEDORA_CORE_6 = "Fedora Core 6";
    public static final String LINUX_DISTRO_FEDORA_7 = "Fedora 7";
    public static final String LINUX_DISTRO_FEDORA_8 = "Fedora 8";
    public static final String LINUX_DISTRO_FEDORA_9 = "Fedora 9";
    public static final String LINUX_DISTRO_RHEL5 = "Red Hat Enterprise Linux 5";
    public static final String LINUX_DISTRO_RHEL5U1 = "Red Hat Enterprise Linux 5 Update 1";
    public static final String LINUX_DISTRO_RHEL5U2 = "Red Hat Enterprise Linux 5 Update 2";

    private Platform() {
    }

    public static String getOSArch() {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_PLATFORM);
        String architecture = org.eclipse.core.runtime.Platform.getOSArch();
        if (org.eclipse.core.runtime.Platform.getOS().equals("linux")) {
            Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Detected Linux.");
            if (architecture.equals("ppc")) {
                Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Detected Linux on PPC.");
                File compatible = new File(COMPATIBLE);
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(compatible));
                    Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Check file: {0}", COMPATIBLE);
                    String compatibilityLine = reader.readLine();
                    Debug.POLICY.trace(Debug.DEBUG_PLATFORM_MORE, "Content: {0}", compatibilityLine);
                    if (compatibilityLine != null && compatibilityLine.indexOf(CELL_COMPATIBLE_ID) != -1) {
                        architecture = ARCH_CELL;
                    }
                }
                catch (FileNotFoundException e) {
                    Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Assuming not {1} because file does not exist: {0}", e.getMessage(), ARCH_CELL);
                }
                catch (IOException ioe) {
                    Debug.POLICY.error(ioe.getMessage());
                    Debug.POLICY.logError(ioe, Messages.Platform_FailedReadFile, compatible.toString());
                }
            }
        }
        Debug.POLICY.exit(Debug.DEBUG_PLATFORM, architecture);
        return architecture;
    }

    public static String getOSLinuxDistro() {
        String release;
        File distroIdFile;
        block19: {
            block18: {
                block16: {
                    block15: {
                        block14: {
                            Debug.read();
                            Debug.POLICY.enter(Debug.DEBUG_PLATFORM);
                            if (!org.eclipse.core.runtime.Platform.getOS().equals("linux")) {
                                Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Not a Linux distro");
                                return LINUX_DISTRO_UNKNOWN;
                            }
                            distroIdFile = new File(IdentityInformation.Fedora);
                            Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Check file: {0}", IdentityInformation.Fedora);
                            release = new BufferedReader(new FileReader(distroIdFile)).readLine();
                            Debug.POLICY.trace(Debug.DEBUG_PLATFORM_MORE, "Content: {0}", release);
                            if (!release.equals(IdentityInformation.FedoraCore6)) break block14;
                            Debug.POLICY.exit(Debug.DEBUG_PLATFORM, LINUX_DISTRO_FEDORA_CORE_6);
                            return LINUX_DISTRO_FEDORA_CORE_6;
                        }
                        if (!release.equals(IdentityInformation.Fedora7)) break block15;
                        Debug.POLICY.exit(Debug.DEBUG_PLATFORM, LINUX_DISTRO_FEDORA_7);
                        return LINUX_DISTRO_FEDORA_7;
                    }
                    if (!release.equals(IdentityInformation.Fedora8)) break block16;
                    Debug.POLICY.exit(Debug.DEBUG_PLATFORM, LINUX_DISTRO_FEDORA_8);
                    return LINUX_DISTRO_FEDORA_8;
                }
                try {
                    if (release.equals(IdentityInformation.Fedora9)) {
                        Debug.POLICY.exit(Debug.DEBUG_PLATFORM, LINUX_DISTRO_FEDORA_9);
                        return LINUX_DISTRO_FEDORA_9;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Assuming not Fedora because files does not exist: {0}", distroIdFile.toString());
                }
                catch (IOException e) {
                    Debug.POLICY.error(e);
                    Debug.POLICY.logError(e, Messages.Platform_FailedReadFile, distroIdFile.toString());
                }
                distroIdFile = new File(IdentityInformation.RHEL);
                Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Check file: {0}", IdentityInformation.RHEL);
                release = new BufferedReader(new FileReader(distroIdFile)).readLine();
                Debug.POLICY.trace(Debug.DEBUG_PLATFORM_MORE, "Content: {0}", release);
                if (!release.equals(IdentityInformation.RedHatEnterpriseLinux5)) break block18;
                Debug.POLICY.exit(Debug.DEBUG_PLATFORM, LINUX_DISTRO_RHEL5U1);
                return LINUX_DISTRO_RHEL5;
            }
            if (!release.equals(IdentityInformation.RedHatEnterpriseLinux5U1)) break block19;
            Debug.POLICY.exit(Debug.DEBUG_PLATFORM, LINUX_DISTRO_RHEL5U1);
            return LINUX_DISTRO_RHEL5U1;
        }
        try {
            if (release.equals(IdentityInformation.RedHatEnterpriseLinux5U2)) {
                Debug.POLICY.exit(Debug.DEBUG_PLATFORM, LINUX_DISTRO_RHEL5U2);
                return LINUX_DISTRO_RHEL5U2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.POLICY.trace(Debug.DEBUG_PLATFORM, "Assuming not RHEL, because file does not exist: {0}", distroIdFile);
        }
        catch (IOException e) {
            Debug.POLICY.error(e);
            Debug.POLICY.logError(e, Messages.Platform_FailedReadFile, distroIdFile.toString());
        }
        Debug.POLICY.exit(Debug.DEBUG_PLATFORM, LINUX_DISTRO_UNKNOWN);
        return LINUX_DISTRO_UNKNOWN;
    }
}

