/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.ArrayAttributeDefinition;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeManager {
    private final Map<IAttributeDefinition<?, ?, ?>, IAttribute<?, ?, ?>> map = Collections.synchronizedMap(new HashMap());

    public AttributeManager() {
    }

    public AttributeManager(IAttribute<?, ?, ?>[] attrs) {
        IAttribute<?, ?, ?>[] iAttributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute<?, ?, ?> attr = iAttributeArray[n2];
            this.addAttribute(attr);
            ++n2;
        }
    }

    public void addAttribute(IAttribute<?, ?, ?> attr) {
        this.map.put((IAttributeDefinition<?, ?, ?>)attr.getDefinition(), attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(IAttribute<?, ?, ?>[] attrs) {
        Map<IAttributeDefinition<?, ?, ?>, IAttribute<?, ?, ?>> map = this.map;
        synchronized (map) {
            IAttribute<?, ?, ?>[] iAttributeArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                IAttribute<?, ?, ?> attr = iAttributeArray[n2];
                Object def = attr.getDefinition();
                if (this.map.containsKey(def) && attr instanceof ArrayAttribute) {
                    ArrayAttribute arrAttr = (ArrayAttribute)attr;
                    this.addAttributeToArrayAttribute(arrAttr);
                } else {
                    this.addAttribute(attr);
                }
                ++n2;
            }
        }
    }

    private <T extends Comparable<? super T>> void addAttributeToArrayAttribute(ArrayAttribute<T> attr) {
        ArrayAttributeDefinition def = (ArrayAttributeDefinition)attr.getDefinition();
        ArrayAttribute exAttr = (ArrayAttribute)this.map.get(def);
        Object value = attr.getValue();
        exAttr.addAll(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute<?, ?, ?> getAttribute(String id) {
        Map<IAttributeDefinition<?, ?, ?>, IAttribute<?, ?, ?>> map = this.map;
        synchronized (map) {
            for (Map.Entry<IAttributeDefinition<?, ?, ?>, IAttribute<?, ?, ?>> entry : this.map.entrySet()) {
                if (!entry.getKey().getId().equals(id)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> A getAttribute(D def) {
        return this.getAttribute((D)((Object)def.getId()));
    }

    public IAttribute<?, ?, ?>[] getAttributes() {
        return this.map.values().toArray(new IAttribute[this.map.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute<?, ?, ?>[] getDisplayAttributes() {
        ArrayList attrs = new ArrayList();
        Map<IAttributeDefinition<?, ?, ?>, IAttribute<?, ?, ?>> map = this.map;
        synchronized (map) {
            for (IAttribute<?, ?, ?> attr : this.map.values()) {
                if (!((IAttributeDefinition)attr.getDefinition()).getDisplay()) continue;
                attrs.add(attr);
            }
        }
        return attrs.toArray(new IAttribute[attrs.size()]);
    }

    public IAttributeDefinition<?, ?, ?>[] getKeys() {
        return this.map.keySet().toArray(new IAttributeDefinition[0]);
    }

    public void removeAttribute(IAttribute<?, ?, ?> attr) {
        this.map.remove(attr.getDefinition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] toStringArray() {
        ArrayList<String> res = new ArrayList<String>();
        Map<IAttributeDefinition<?, ?, ?>, IAttribute<?, ?, ?>> map = this.map;
        synchronized (map) {
            for (Map.Entry<IAttributeDefinition<?, ?, ?>, IAttribute<?, ?, ?>> entry : this.map.entrySet()) {
                IAttribute<?, ?, ?> attr = entry.getValue();
                if (attr instanceof ArrayAttribute) {
                    Object arrObj = ((ArrayAttribute)attr).getValue();
                    Iterator iterator = arrObj.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        res.add(String.valueOf(entry.getKey().getId()) + "=" + obj.toString());
                    }
                    continue;
                }
                res.add(String.valueOf(entry.getKey().getId()) + "=" + attr.getValueAsString());
            }
        }
        return res.toArray(new String[res.size()]);
    }
}

