/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem;

import java.io.IOException;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AbstractAttributeDefinition;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.ElementAttributeManager;
import org.eclipse.ptp.core.elements.attributes.ErrorAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.MessageAttributes;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeAttributeDefinitionEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeConnectedStateEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeErrorStateEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeJobChangeEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeMachineChangeEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeMessageEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeNewJobEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeNewMachineEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeNewNodeEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeNewProcessEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeNewQueueEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeNodeChangeEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeProcessChangeEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeQueueChangeEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeRemoveAllEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeRemoveJobEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeRemoveMachineEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeRemoveNodeEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeRemoveProcessEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeRemoveQueueEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeRunningStateEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeShutdownStateEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeStartupErrorEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeSubmitJobErrorEvent;
import org.eclipse.ptp.internal.rtsystem.events.RuntimeTerminateJobErrorEvent;
import org.eclipse.ptp.proxy.runtime.client.IProxyRuntimeClient;
import org.eclipse.ptp.proxy.runtime.client.IProxyRuntimeEventListener;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeAttributeDefEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeConnectedStateEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeErrorStateEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeJobChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeMachineChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeMessageEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewJobEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewMachineEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewNodeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewProcessEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewQueueEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNodeChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeProcessChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeQueueChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveAllEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveJobEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveMachineEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveNodeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveProcessEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveQueueEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRunningStateEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeShutdownStateEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeStartupErrorEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeSubmitJobErrorEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeTerminateJobErrorEvent;
import org.eclipse.ptp.rtsystem.AbstractRuntimeSystem;
import org.eclipse.ptp.utils.core.RangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxyRuntimeSystem
extends AbstractRuntimeSystem
implements IProxyRuntimeEventListener {
    private static final int ATTR_MIN_LEN = 5;
    protected IProxyRuntimeClient proxy = null;
    private AttributeDefinitionManager attrDefManager;
    private Map<String, AttributeManager> jobSubs = Collections.synchronizedMap(new HashMap());

    public AbstractProxyRuntimeSystem(IProxyRuntimeClient proxy, AttributeDefinitionManager manager) {
        this.proxy = proxy;
        this.attrDefManager = manager;
        proxy.addProxyRuntimeEventListener((IProxyRuntimeEventListener)this);
    }

    public void handleEvent(IProxyRuntimeAttributeDefEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length >= 7) {
            try {
                int numDefs = Integer.parseInt(attrs[0]);
                ArrayList attrDefs = new ArrayList(numDefs);
                int pos = 1;
                int i = 0;
                while (i < numDefs) {
                    int numArgs = Integer.parseInt(attrs[pos]);
                    if (numArgs >= 5 && pos + numArgs < attrs.length) {
                        IAttributeDefinition<?, ?, ?> attrDef = this.parseAttributeDefinition(attrs, pos + 1, pos + numArgs);
                        if (attrDef != null) {
                            attrDefs.add(attrDef);
                        }
                        pos += numArgs + 1;
                    } else {
                        this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: bad arg count"));
                        return;
                    }
                    ++i;
                }
                this.fireRuntimeAttributeDefinitionEvent(new RuntimeAttributeDefinitionEvent(attrDefs.toArray(new IAttributeDefinition[attrDefs.size()])));
            }
            catch (NumberFormatException numberFormatException) {
                this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not convert arg to integer"));
            }
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: not enough arguments"));
        }
    }

    public void handleEvent(IProxyRuntimeErrorStateEvent e) {
        this.fireRuntimeErrorStateEvent(new RuntimeErrorStateEvent());
    }

    public void handleEvent(IProxyRuntimeMessageEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length > 0) {
            AttributeManager mgr = this.getAttributeManager(attrs, 0, attrs.length - 1);
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(mgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeJobChangeEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 0);
        if (eMgr != null) {
            this.fireRuntimeJobChangeEvent(new RuntimeJobChangeEvent(eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeMachineChangeEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 0);
        if (eMgr != null) {
            this.fireRuntimeMachineChangeEvent(new RuntimeMachineChangeEvent(eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeNewJobEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 2) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 1);
        if (eMgr != null) {
            for (Map.Entry<RangeSet, AttributeManager> entry : eMgr.getEntrySet()) {
                StringAttribute subIdAttr = (StringAttribute)entry.getValue().getAttribute(JobAttributes.getSubIdAttributeDefinition());
                if (subIdAttr == null) continue;
                String subId = subIdAttr.getValueAsString();
                AttributeManager mgr = this.jobSubs.get(subId);
                if (mgr != null) {
                    entry.getValue().addAttributes(mgr.getAttributes());
                }
                this.jobSubs.remove(subId);
            }
            this.fireRuntimeNewJobEvent(new RuntimeNewJobEvent(attrs[0], eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeNewMachineEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 2) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 1);
        if (eMgr != null) {
            this.fireRuntimeNewMachineEvent(new RuntimeNewMachineEvent(attrs[0], eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeNewNodeEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 2) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 1);
        if (eMgr != null) {
            this.fireRuntimeNewNodeEvent(new RuntimeNewNodeEvent(attrs[0], eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeNewProcessEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 2) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 1);
        if (eMgr != null) {
            this.fireRuntimeNewProcessEvent(new RuntimeNewProcessEvent(attrs[0], eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeNewQueueEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 2) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 1);
        if (eMgr != null) {
            this.fireRuntimeNewQueueEvent(new RuntimeNewQueueEvent(attrs[0], eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeNodeChangeEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 0);
        if (eMgr != null) {
            this.fireRuntimeNodeChangeEvent(new RuntimeNodeChangeEvent(eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeProcessChangeEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 0);
        if (eMgr != null) {
            this.fireRuntimeProcessChangeEvent(new RuntimeProcessChangeEvent(eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeQueueChangeEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        ElementAttributeManager eMgr = this.getElementAttributeManager(attrs, 0);
        if (eMgr != null) {
            this.fireRuntimeQueueChangeEvent(new RuntimeQueueChangeEvent(eMgr));
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeConnectedStateEvent e) {
        this.fireRuntimeConnectedStateEvent(new RuntimeConnectedStateEvent());
    }

    public void handleEvent(IProxyRuntimeRemoveAllEvent e) {
        this.fireRuntimeRemoveAllEvent(new RuntimeRemoveAllEvent());
    }

    public void handleEvent(IProxyRuntimeRemoveJobEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        this.fireRuntimeRemoveJobEvent(new RuntimeRemoveJobEvent(new RangeSet(attrs[0])));
    }

    public void handleEvent(IProxyRuntimeRemoveMachineEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        this.fireRuntimeRemoveMachineEvent(new RuntimeRemoveMachineEvent(new RangeSet(attrs[0])));
    }

    public void handleEvent(IProxyRuntimeRemoveNodeEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        this.fireRuntimeRemoveNodeEvent(new RuntimeRemoveNodeEvent(new RangeSet(attrs[0])));
    }

    public void handleEvent(IProxyRuntimeRemoveProcessEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        this.fireRuntimeRemoveProcessEvent(new RuntimeRemoveProcessEvent(new RangeSet(attrs[0])));
    }

    public void handleEvent(IProxyRuntimeRemoveQueueEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length < 1) {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "AbstractProxyRuntimeSystem: not enough arguments"));
            return;
        }
        this.fireRuntimeRemoveQueueEvent(new RuntimeRemoveQueueEvent(new RangeSet(attrs[0])));
    }

    public void handleEvent(IProxyRuntimeRunningStateEvent e) {
        this.fireRuntimeRunningStateEvent(new RuntimeRunningStateEvent());
    }

    public void handleEvent(IProxyRuntimeShutdownStateEvent e) {
        this.fireRuntimeShutdownStateEvent(new RuntimeShutdownStateEvent());
    }

    public void handleEvent(IProxyRuntimeStartupErrorEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length > 0) {
            AttributeManager mgr = this.getAttributeManager(attrs, 0, attrs.length - 1);
            IntegerAttribute codeAttr = (IntegerAttribute)mgr.getAttribute(ErrorAttributes.getCodeAttributeDefinition());
            StringAttribute msgAttr = (StringAttribute)mgr.getAttribute(ErrorAttributes.getMsgAttributeDefinition());
            if (codeAttr == null || msgAttr == null) {
                this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "StartupErrorEvent: missing attibutes"));
            } else {
                this.fireRuntimeStartupErrorEvent(new RuntimeStartupErrorEvent(codeAttr.getValue(), msgAttr.getValue()));
            }
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "StartupErrorEvent: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeSubmitJobErrorEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length > 0) {
            AttributeManager mgr = this.getAttributeManager(attrs, 0, attrs.length - 1);
            IntegerAttribute codeAttr = (IntegerAttribute)mgr.getAttribute(ErrorAttributes.getCodeAttributeDefinition());
            StringAttribute msgAttr = (StringAttribute)mgr.getAttribute(ErrorAttributes.getMsgAttributeDefinition());
            StringAttribute jobSubIdAttr = (StringAttribute)mgr.getAttribute(JobAttributes.getSubIdAttributeDefinition());
            if (codeAttr == null || msgAttr == null || jobSubIdAttr == null) {
                this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "SubmitJobErrorEvent: missing attibutes"));
            } else {
                this.fireRuntimeSubmitJobErrorEvent(new RuntimeSubmitJobErrorEvent(codeAttr.getValue(), msgAttr.getValue(), jobSubIdAttr.getValue()));
            }
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "SubmitJobErrorEvent: could not parse message"));
        }
    }

    public void handleEvent(IProxyRuntimeTerminateJobErrorEvent e) {
        String[] attrs = e.getAttributes();
        if (attrs.length > 0) {
            AttributeManager mgr = this.getAttributeManager(attrs, 0, attrs.length - 1);
            IntegerAttribute codeAttr = (IntegerAttribute)mgr.getAttribute(ErrorAttributes.getCodeAttributeDefinition());
            StringAttribute msgAttr = (StringAttribute)mgr.getAttribute(ErrorAttributes.getMsgAttributeDefinition());
            StringAttribute jobIdAttr = (StringAttribute)mgr.getAttribute(JobAttributes.getJobIdAttributeDefinition());
            if (codeAttr == null || msgAttr == null || jobIdAttr == null) {
                this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "TerminateJobErrorEvent: missing attibutes"));
            } else {
                this.fireRuntimeTerminateJobErrorEvent(new RuntimeTerminateJobErrorEvent(codeAttr.getValue(), msgAttr.getValue(), jobIdAttr.getValue()));
            }
        } else {
            this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "TerminateJobErrorEvent: could not parse message"));
        }
    }

    @Override
    public abstract void shutdown(IProgressMonitor var1) throws CoreException;

    @Override
    public abstract void startup(IProgressMonitor var1) throws CoreException;

    @Override
    public void submitJob(String subId, AttributeManager attrMgr) throws CoreException {
        try {
            StringAttribute jobSubAttr = JobAttributes.getSubIdAttributeDefinition().create(subId);
            attrMgr.addAttribute(jobSubAttr);
            this.jobSubs.put(subId, attrMgr);
            this.proxy.submitJob(attrMgr.toStringArray());
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Control system is shut down, proxy exception.  The proxy may have crashed or been killed.", null));
        }
    }

    @Override
    public void terminateJob(IPJob job) throws CoreException {
        if (job == null) {
            PTPCorePlugin.log("Tried to terminate a null job.");
            return;
        }
        try {
            this.proxy.terminateJob(job.getID());
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Control system is shut down, proxy exception.  The proxy may have crashed or been killed.", null));
        }
    }

    @Override
    public void startEvents() throws CoreException {
        try {
            this.proxy.startEvents();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public void stopEvents() throws CoreException {
        try {
            this.proxy.stopEvents();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), (Throwable)e));
        }
    }

    private AttributeManager getAttributeManager(String[] kvs, int start, int end) {
        AttributeManager mgr = new AttributeManager();
        int i = start;
        while (i <= end) {
            String kv = kvs[i];
            int sep = kv.indexOf(61);
            if (sep > 0) {
                try {
                    IAttributeDefinition<?, ?, ?> attrDef = this.attrDefManager.getAttributeDefinition(kv.substring(0, sep));
                    if (attrDef != null) {
                        String value = "";
                        if (sep < kv.length() - 1) {
                            value = kv.substring(sep + 1);
                        }
                        Object attr = attrDef.create(value);
                        mgr.addAttribute((IAttribute<?, ?, ?>)attr);
                    } else {
                        PTPCorePlugin.log("AbstractProxyRuntimSystem: unknown attribute definition");
                    }
                }
                catch (IllegalValueException illegalValueException) {
                    PTPCorePlugin.log("AbstractProxyRuntimSystem: invalid attribute for definition");
                }
            }
            ++i;
        }
        return mgr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ElementAttributeManager getElementAttributeManager(String[] attrs, int pos) {
        ElementAttributeManager eMgr = new ElementAttributeManager();
        try {
            int numRanges = Integer.parseInt(attrs[pos++]);
            int i = 0;
            while (true) {
                if (i >= numRanges) {
                    return eMgr;
                }
                if (pos >= attrs.length) {
                    return null;
                }
                RangeSet ids = new RangeSet(attrs[pos++]);
                int numAttrs = Integer.parseInt(attrs[pos++]);
                int start = pos;
                int end = pos + numAttrs - 1;
                if (end >= attrs.length) {
                    return null;
                }
                eMgr.setAttributeManager(ids, this.getAttributeManager(attrs, start, end));
                pos = end + 1;
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private IAttributeDefinition<?, ?, ?> parseAttributeDefinition(String[] attrs, int start, int end) {
        AbstractAttributeDefinition attrDef;
        block39: {
            boolean attrDisplay;
            int pos = start;
            attrDef = null;
            String attrId = attrs[pos++];
            String attrType = attrs[pos++];
            String attrName = attrs[pos++];
            String attrDesc = attrs[pos++];
            try {
                attrDisplay = Boolean.parseBoolean(attrs[pos++]);
            }
            catch (NumberFormatException numberFormatException) {
                this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not convert attr to boolean"));
                return null;
            }
            String attrDefault = attrs[pos++];
            if (attrType.equals("BOOLEAN")) {
                try {
                    Boolean defVal = Boolean.parseBoolean(attrDefault);
                    attrDef = this.attrDefManager.createBooleanAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not convert attrs to boolean"));
                }
            } else if (attrType.equals("DATE")) {
                if (end - pos > 2) {
                    try {
                        int dateStyle = this.toDateStyle(attrs[pos++]);
                        int timeStyle = this.toDateStyle(attrs[pos++]);
                        Locale locale = this.toLocale(attrs[pos++]);
                        DateFormat fmt = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                        Date defVal = fmt.parse(attrDefault);
                        if (end - pos > 1) {
                            Date min = fmt.parse(attrs[pos++]);
                            Date max = fmt.parse(attrs[pos++]);
                            attrDef = this.attrDefManager.createDateAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal, fmt, min, max);
                            break block39;
                        }
                        attrDef = this.attrDefManager.createDateAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal, fmt);
                    }
                    catch (ParseException parseException) {
                        this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not parse date"));
                    }
                    catch (IllegalValueException ex) {
                        this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not create attribute definition, " + ex.getMessage()));
                    }
                } else {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: missing date format"));
                }
            } else if (attrType.equals("DOUBLE")) {
                try {
                    Double defVal = Double.parseDouble(attrDefault);
                    if (end - pos > 0) {
                        Double min = Double.parseDouble(attrs[pos++]);
                        Double max = Double.parseDouble(attrs[pos++]);
                        attrDef = this.attrDefManager.createDoubleAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal, min, max);
                        break block39;
                    }
                    attrDef = this.attrDefManager.createDoubleAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not convert args to double"));
                }
                catch (IllegalValueException ex) {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not create attribute definition, " + ex.getMessage()));
                }
            } else if (attrType.equals("ENUMERATED")) {
                ArrayList<String> values = new ArrayList<String>();
                while (pos <= end) {
                    values.add(attrs[pos++]);
                }
                try {
                    attrDef = this.attrDefManager.createStringSetAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, attrDefault, values.toArray(new String[values.size()]));
                }
                catch (IllegalValueException ex) {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not create attribute definition, " + ex.getMessage()));
                }
            } else if (attrType.equals("INTEGER")) {
                try {
                    Integer defVal = Integer.parseInt(attrDefault);
                    if (end - pos > 0) {
                        Integer min = Integer.parseInt(attrs[pos++]);
                        Integer max = Integer.parseInt(attrs[pos++]);
                        attrDef = this.attrDefManager.createIntegerAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal, min, max);
                        break block39;
                    }
                    attrDef = this.attrDefManager.createIntegerAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not convert args to integer"));
                }
                catch (IllegalValueException ex) {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not create attribute definition, " + ex.getMessage()));
                }
            } else if (attrType.equals("BIGINTEGER")) {
                try {
                    BigInteger defVal = new BigInteger(attrDefault);
                    if (end - pos > 0) {
                        BigInteger min = new BigInteger(attrs[pos++]);
                        BigInteger max = new BigInteger(attrs[pos++]);
                        attrDef = this.attrDefManager.createBigIntegerAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal, min, max);
                        break block39;
                    }
                    attrDef = this.attrDefManager.createBigIntegerAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, defVal);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not convert args to BigInteger"));
                }
                catch (IllegalValueException ex) {
                    this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: could not create attribute definition, " + ex.getMessage()));
                }
            } else if (attrType.equals("STRING")) {
                attrDef = this.attrDefManager.createStringAttributeDefinition(attrId, attrName, attrDesc, attrDisplay, attrDefault);
            } else {
                this.fireRuntimeMessageEvent(new RuntimeMessageEvent(MessageAttributes.Level.ERROR, "Bad proxy event: unknown attribute type"));
            }
        }
        return attrDef;
    }

    private int toDateStyle(String val) {
        if (val.equals("SHORT")) {
            return 3;
        }
        if (val.equals("MEDIUM")) {
            return 2;
        }
        if (val.equals("LONG")) {
            return 1;
        }
        if (val.equals("FULL")) {
            return 0;
        }
        return 2;
    }

    private Locale toLocale(String val) {
        if (val.equals("CANADA")) {
            return Locale.CANADA;
        }
        if (val.equals("CHINA")) {
            return Locale.CHINA;
        }
        if (val.equals("FRANCE")) {
            return Locale.FRANCE;
        }
        if (val.equals("GERMANY")) {
            return Locale.GERMANY;
        }
        if (val.equals("ITALY")) {
            return Locale.ITALY;
        }
        if (val.equals("JAPAN")) {
            return Locale.JAPAN;
        }
        if (val.equals("TAIWAN")) {
            return Locale.TAIWAN;
        }
        if (val.equals("UK")) {
            return Locale.UK;
        }
        if (val.equals("US")) {
            return Locale.US;
        }
        return Locale.US;
    }
}

