/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.perf.Activator;
import org.eclipse.ptp.perf.internal.ILaunchFactory;
import org.eclipse.ptp.perf.internal.PerfBuilder;
import org.eclipse.ptp.perf.internal.PerfLauncher;
import org.eclipse.ptp.perf.internal.PerfPostlaunch;
import org.eclipse.ptp.perf.internal.PerfStep;
import org.eclipse.ptp.perf.internal.PerformanceParametricLaunchManager;
import org.eclipse.ptp.perf.toolopts.BuildTool;
import org.eclipse.ptp.perf.toolopts.ExecTool;
import org.eclipse.ptp.perf.toolopts.PerformanceProcess;
import org.eclipse.ptp.perf.toolopts.PerformanceTool;
import org.eclipse.ptp.perf.toolopts.PostProcTool;

public class PerformanceLaunchManager {
    protected static final String buildText = "Instrumenting and Building";
    protected static final String launchText = "Executing Instrumented Project";
    protected static final String collectText = "Collecting Performance Data";
    protected LaunchConfigurationDelegate paraDel;
    private ILaunchFactory lf = null;

    public PerformanceLaunchManager(LaunchConfigurationDelegate delegate, ILaunchFactory lf) {
        this.paraDel = delegate;
        this.lf = lf;
    }

    private static boolean runStep(PerfStep step) {
        step.schedule();
        try {
            step.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return step.getResult().isOK();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        boolean useParam;
        ILaunch launch = launchIn;
        PerformanceProcess pproc = Activator.getTool(configuration.getAttribute("selected_performance_tool", null));
        boolean bl = useParam = configuration.getAttribute("use the parametric analysis system", false) || pproc.para != null && pproc.para.runParametric;
        if (useParam) {
            PerformanceParametricLaunchManager.launch(configuration, this.paraDel, this.lf, mode, launchIn, monitor);
            return;
        }
        String bProgPath = null;
        String bOutLoc = null;
        boolean ran = false;
        PerfBuilder builder = null;
        PerfLauncher launcher = null;
        boolean buildOnly = configuration.getAttribute("build_but_do_not_run_instrumented_executable", false);
        boolean analyzeOnly = configuration.getAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", false);
        if (buildOnly) {
            builder = new PerfBuilder(configuration, pproc.getFirstBuilder(configuration));
            PerformanceLaunchManager.runStep(builder);
            return;
        }
        if (analyzeOnly) {
            PerfPostlaunch analyzer = new PerfPostlaunch(configuration, pproc.getFirstAnalyzer(configuration), null);
            PerformanceLaunchManager.runStep(analyzer);
            return;
        }
        if (!pproc.recompile) {
            builder = new PerfBuilder(configuration, null);
            if (!PerformanceLaunchManager.runStep(builder)) {
                return;
            }
            bProgPath = builder.getProgramPath();
            bOutLoc = builder.getOutputLocation();
            if (!pproc.prependExecution && !(pproc.perfTools.get(0) instanceof ExecTool)) {
                launcher = new PerfLauncher(configuration, null, bProgPath, this.paraDel, launch);
                if (!PerformanceLaunchManager.runStep(launcher)) {
                    return;
                }
                ran = true;
            }
        }
        int i = 0;
        while (i < pproc.perfTools.size()) {
            PerformanceTool t = (PerformanceTool)pproc.perfTools.get(i);
            if (t.canRun(configuration)) {
                PerfPostlaunch analyzer;
                if (t instanceof BuildTool) {
                    builder = new PerfBuilder(configuration, (BuildTool)t);
                    if (!PerformanceLaunchManager.runStep(builder)) {
                        return;
                    }
                    bProgPath = builder.getProgramPath();
                    bOutLoc = builder.getOutputLocation();
                    if (!(pproc.prependExecution || ran || i >= pproc.perfTools.size() - 1 || pproc.perfTools.get(i + 1) instanceof ExecTool)) {
                        launcher = new PerfLauncher(configuration, null, bProgPath, this.paraDel, launch);
                        if (!PerformanceLaunchManager.runStep(launcher)) {
                            return;
                        }
                        ran = true;
                    }
                } else if (t instanceof ExecTool ? !PerformanceLaunchManager.runStep(launcher = new PerfLauncher(configuration, (ExecTool)t, bProgPath, this.paraDel, launch)) : t instanceof PostProcTool && !PerformanceLaunchManager.runStep(analyzer = new PerfPostlaunch(configuration, (PostProcTool)t, bOutLoc))) {
                    return;
                }
            }
            ++i;
        }
    }
}

