/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.indexer.IStandaloneScannerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteScannerInfoProvider
implements IStandaloneScannerInfoProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, RemoteScannerInfo> pathMap;
    private final Map<Integer, RemoteScannerInfo> linkageMap;

    RemoteScannerInfoProvider(Map<String, RemoteScannerInfo> pathMap, Map<Integer, RemoteScannerInfo> linkageMap) {
        this.pathMap = pathMap == null ? Collections.emptyMap() : pathMap;
        this.linkageMap = linkageMap == null ? Collections.emptyMap() : linkageMap;
    }

    RemoteScannerInfoProvider() {
        this.pathMap = Collections.emptyMap();
        this.linkageMap = Collections.emptyMap();
    }

    public IScannerInfo getScannerInformation(String path) {
        return RemoteScannerInfoProvider.getScannerInfo(this.pathMap, path);
    }

    public IScannerInfo getDefaultScannerInformation(int linkageId) {
        return RemoteScannerInfoProvider.getScannerInfo(this.linkageMap, linkageId);
    }

    private static <T> IScannerInfo getScannerInfo(Map<T, RemoteScannerInfo> map, T key) {
        IScannerInfo si = map.get(key);
        return si == null ? new RemoteScannerInfo() : si;
    }

    public String toString() {
        return this.pathMap.toString();
    }
}

