/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.index;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.index.RemoteFastIndexer;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerProgress;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;

public class RemoteIndexerTask
implements IPDOMIndexerTask {
    protected RemoteFastIndexer fIndexer;
    protected IIndexServiceProvider fIndexServiceProvider;
    protected ITranslationUnit[] fAdded;
    protected ITranslationUnit[] fChanged;
    protected ITranslationUnit[] fRemoved;
    private RemoteIndexerProgress fRemoteProgress = new RemoteIndexerProgress();

    public RemoteIndexerTask(RemoteFastIndexer indexer, IIndexServiceProvider indexingServiceProvider, ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        this.fIndexer = indexer;
        this.fIndexServiceProvider = indexingServiceProvider;
        this.fAdded = added;
        this.fChanged = changed;
        this.fRemoved = removed;
    }

    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexerProgress getProgressInformation() {
        RemoteIndexerProgress remoteIndexerProgress = this.fRemoteProgress;
        synchronized (remoteIndexerProgress) {
            return RemoteIndexerProgress.getIndexerProgress(this.fRemoteProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgressInformation(RemoteIndexerProgress progress) {
        RemoteIndexerProgress remoteIndexerProgress = this.fRemoteProgress;
        synchronized (remoteIndexerProgress) {
            if (progress != null) {
                this.fRemoteProgress = progress;
            }
        }
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        IIndexLifecycleService service = this.fIndexServiceProvider.getIndexLifeCycleService();
        IProject project = this.fIndexer.getProject().getProject();
        String name = project.getName();
        service.update(new Scope(name), Arrays.asList(this.fAdded), Arrays.asList(this.fChanged), Arrays.asList(this.fRemoved), monitor, this);
    }
}

