/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.indexer.ILanguageMapper;
import org.eclipse.cdt.internal.core.indexer.StandaloneFastIndexer;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexer;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkageFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLanguageMapper;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLocationConverter;
import org.eclipse.ptp.internal.rdt.core.miners.ScopeManager;

public class RemoteIndexManager {
    public static final String PDOM_EXTENSION = ".pdom";
    private static final IParserLogService LOG = new DefaultLogService();
    private static RemoteIndexManager theInstance = null;
    private Map<String, StandaloneIndexer> scopeToIndexerMap = new HashMap<String, StandaloneIndexer>();
    private static final PDOMCLinkageFactory cLinkageFactory = new PDOMCLinkageFactory();
    private static final PDOMCPPLinkageFactory cppLinkageFactory = new PDOMCPPLinkageFactory();
    private static final IIndexLocationConverter locationConverter = new RemoteLocationConverter();
    private static final Map<String, IPDOMLinkageFactory> linkageFactoryMap = new HashMap<String, IPDOMLinkageFactory>();
    private static final ILanguageMapper MAPPER = new RemoteLanguageMapper();

    static {
        linkageFactoryMap.put("C", (IPDOMLinkageFactory)cLinkageFactory);
        linkageFactoryMap.put("C++", (IPDOMLinkageFactory)cppLinkageFactory);
    }

    private RemoteIndexManager() {
    }

    public static synchronized RemoteIndexManager getInstance() {
        if (theInstance == null) {
            theInstance = new RemoteIndexManager();
        }
        return theInstance;
    }

    public IIndex getIndexForScope(String scope) {
        if (scope.equals("__WORKSPACE_ROOT_SCOPE__")) {
            HashSet<IWritableIndexFragment> fragments = new HashSet<IWritableIndexFragment>();
            Set<String> allScopes = ScopeManager.getInstance().getAllScopes();
            for (String currentScope : allScopes) {
                IWritableIndexFragment fragment = this.getIndexerForScope(currentScope).getIndex().getWritableFragment();
                fragments.add(fragment);
            }
            CIndex index = new CIndex(fragments.toArray(new IIndexFragment[fragments.size()]), fragments.size());
            return index;
        }
        StandaloneFastIndexer indexer = this.getIndexerForScope(scope);
        return indexer.getIndex();
    }

    public StandaloneFastIndexer getIndexerForScope(String scope) {
        if (scope.equals("__WORKSPACE_ROOT_SCOPE__")) {
            throw new IllegalArgumentException("Attempted to get indexer for root scope.");
        }
        StandaloneFastIndexer indexer = (StandaloneFastIndexer)this.scopeToIndexerMap.get(scope);
        if (indexer != null) {
            return indexer;
        }
        File indexFile = new File(String.valueOf(scope) + PDOM_EXTENSION);
        System.out.println("Index at location: " + indexFile.getAbsolutePath());
        System.out.flush();
        try {
            indexer = new StandaloneFastIndexer(indexFile, locationConverter, linkageFactoryMap, MAPPER, LOG);
            this.scopeToIndexerMap.put(scope, (StandaloneIndexer)indexer);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return indexer;
    }
}

