/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.serviceproviders;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfoProviderFactory;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.WorkingCopy;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class AbstractRemoteService {
    protected IHost fHost;
    protected IConnectorService fConnectorService;
    protected ICIndexSubsystem fIndexSubsystem;

    public AbstractRemoteService(IHost host, IConnectorService connectorService) {
        this.fHost = host;
        this.fConnectorService = connectorService;
    }

    protected ICIndexSubsystem getSubSystem() {
        if (this.fIndexSubsystem == null) {
            ISubSystem[] subSystems = this.fConnectorService.getSubSystems();
            int k = 0;
            while (k < subSystems.length) {
                if (subSystems[k] instanceof ICIndexSubsystem) {
                    this.fIndexSubsystem = (ICIndexSubsystem)subSystems[k];
                }
                ++k;
            }
        }
        return this.fIndexSubsystem;
    }

    protected ITranslationUnit adaptWorkingCopy(IWorkingCopy workingCopy) throws CModelException {
        ITranslationUnit unit;
        if (workingCopy.isConsistent()) {
            unit = (ITranslationUnit)ModelAdapter.adaptElement(null, workingCopy, 0, true);
        } else {
            String contents = workingCopy.getSource();
            unit = new WorkingCopy(null, (ITranslationUnit)workingCopy, contents);
        }
        if (unit instanceof TranslationUnit) {
            RemoteScannerInfo scannerInfo = RemoteScannerInfoProviderFactory.getScannerInfo(unit.getResource());
            ((TranslationUnit)unit).setASTContext(scannerInfo);
        }
        return unit;
    }
}

