/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTArraySubscriptExpression
extends CPPASTNode
implements IASTArraySubscriptExpression,
IASTAmbiguityParent {
    private IASTExpression subscriptExp;
    private IASTExpression arrayExpression;

    public CPPASTArraySubscriptExpression() {
    }

    public CPPASTArraySubscriptExpression(IASTExpression arrayExpression, IASTExpression subscriptExp) {
        this.setArrayExpression(arrayExpression);
        this.setSubscriptExpression(subscriptExp);
    }

    public IASTExpression getArrayExpression() {
        return this.arrayExpression;
    }

    public void setArrayExpression(IASTExpression expression) {
        this.arrayExpression = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(ARRAY);
        }
    }

    public IASTExpression getSubscriptExpression() {
        return this.subscriptExp;
    }

    public void setSubscriptExpression(IASTExpression expression) {
        this.subscriptExp = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(SUBSCRIPT);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.arrayExpression != null && !this.arrayExpression.accept(action)) {
            return false;
        }
        if (this.subscriptExp != null && !this.subscriptExp.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.subscriptExp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.subscriptExp = (IASTExpression)other;
        }
        if (child == this.arrayExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.arrayExpression = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        return CPPVisitor.getExpressionType(this);
    }
}

