/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PDOMProjectIndexLocationConverter
implements IIndexLocationConverter {
    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    private static final String EXTERNAL = "<EXT>";

    public PDOMProjectIndexLocationConverter(IProject project) {
    }

    public IIndexFileLocation fromInternalFormat(String raw) {
        String fullPath = null;
        URI uri = null;
        if (raw.startsWith(EXTERNAL)) {
            try {
                uri = new URI(raw.substring(EXTERNAL.length()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            fullPath = raw;
            Path path = new Path(raw);
            if (path.segmentCount() > 1) {
                IFile member = this.root.getFile((IPath)path);
                uri = member.getLocationURI();
            }
        }
        return uri == null ? null : new IndexFileLocation(uri, fullPath);
    }

    public String toInternalFormat(IIndexFileLocation location) {
        String result = location.getFullPath() != null ? new Path(location.getFullPath()).toString() : EXTERNAL + location.getURI().toString();
        return result;
    }
}

