/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.index.ArrayTypeClone;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMArrayType
extends PDOMNode
implements IIndexType,
IArrayType,
ITypeContainer {
    private static final int TYPE = 8;
    private static final int RECORD_SIZE = 12;

    public PDOMArrayType(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMArrayType(PDOM pdom, PDOMNode parent, IArrayType type) throws CoreException {
        super(pdom, parent);
        Database db = pdom.getDB();
        try {
            PDOMNode targetTypeNode = this.getLinkageImpl().addType(this, type.getType());
            if (targetTypeNode != null) {
                int typeRec = targetTypeNode.getRecord();
                db.putInt(this.record + 8, typeRec);
            }
        }
        catch (DOMException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    protected int getRecordSize() {
        return 12;
    }

    public int getNodeType() {
        return 2;
    }

    public IASTExpression getArraySizeExpression() throws DOMException {
        return null;
    }

    public IType getType() {
        try {
            PDOMNode node = this.getLinkageImpl().getNode(this.pdom.getDB().getInt(this.record + 8));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public boolean isSameType(IType type) {
        IType type1;
        block5: {
            if (type instanceof ITypedef) {
                return ((ITypedef)type).isSameType(this);
            }
            if (!(type instanceof IArrayType)) {
                return false;
            }
            try {
                type1 = this.getType();
                if (type1 != null) break block5;
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        IArrayType rhs = (IArrayType)type;
        return type1.isSameType(rhs.getType());
    }

    public void setType(IType type) {
        throw new PDOMNotImplementedError();
    }

    public Object clone() {
        return new ArrayTypeClone(this);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getType(), this.record);
        super.delete(linkage);
    }
}

