/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreCompatibilityHandler;

public class DefaultDataStoreCompatibilityHandler
implements IDataStoreCompatibilityHandler {
    private DataStore _dataStore;

    public DefaultDataStoreCompatibilityHandler(DataStore dataStore) {
        this._dataStore = dataStore;
    }

    public int checkCompatibility(String handshake) {
        String[] clientVersionStr = "DataStore.8.0.0".split("\\.");
        String[] serverVersionStr = handshake.split("\\.");
        int clientVersion = Integer.parseInt(clientVersionStr[1]);
        int serverVersion = Integer.parseInt(serverVersionStr[1]);
        if (handshake.equals("DataStore.8.0.0")) {
            return 2;
        }
        if (handshake.startsWith("<DataElement")) {
            return 1;
        }
        if (serverVersionStr[0].equals(clientVersionStr[0])) {
            if (serverVersion == clientVersion) {
                return 2;
            }
            if (serverVersion > clientVersion) {
                if (serverVersion - 1 == clientVersion) {
                    return 6;
                }
                return 4;
            }
            if (serverVersion + 1 == clientVersion) {
                return 5;
            }
            if (serverVersion + 2 == clientVersion) {
                return 5;
            }
            return 1;
        }
        return 0;
    }

    public void handleMissingCommand(DataElement descriptor, String keyName) {
    }
}

