/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalVariable;

public class ASTInternal {
    public static IASTNode[] getDeclarationsOfBinding(IBinding binding) {
        if (binding instanceof ICPPInternalBinding) {
            return ((ICPPInternalBinding)binding).getDeclarations();
        }
        assert (false);
        return IASTNode.EMPTY_NODE_ARRAY;
    }

    public static IASTNode getPhysicalNodeOfScope(IScope scope) throws DOMException {
        if (scope instanceof IASTInternalScope) {
            return ((IASTInternalScope)((Object)scope)).getPhysicalNode();
        }
        return null;
    }

    public static void flushCache(IScope scope) throws DOMException {
        if (scope instanceof IASTInternalScope) {
            ((IASTInternalScope)((Object)scope)).flushCache();
        }
    }

    public static boolean isFullyCached(IScope scope) throws DOMException {
        if (scope instanceof IASTInternalScope) {
            return ((IASTInternalScope)((Object)scope)).isFullyCached();
        }
        return true;
    }

    public static void setFullyCached(IScope scope, boolean val) throws DOMException {
        if (scope instanceof IASTInternalScope) {
            ((IASTInternalScope)((Object)scope)).setFullyCached(val);
        }
    }

    public static void addBinding(IScope scope, IBinding binding) throws DOMException {
        if (scope instanceof IASTInternalScope) {
            ((IASTInternalScope)((Object)scope)).addBinding(binding);
        }
    }

    public static void removeBinding(IScope scope, IBinding binding) throws DOMException {
        if (scope instanceof IASTInternalScope) {
            ((IASTInternalScope)((Object)scope)).removeBinding(binding);
        }
    }

    public static void addName(IScope scope, IASTName name) throws DOMException {
        if (scope instanceof IASTInternalScope) {
            ((IASTInternalScope)((Object)scope)).addName(name);
        }
    }

    public static boolean isStatic(IFunction func, boolean resolveAll) throws DOMException {
        if (func instanceof ICPPInternalFunction) {
            return ((ICPPInternalFunction)((Object)func)).isStatic(resolveAll);
        }
        if (func instanceof ICInternalFunction) {
            return ((ICInternalFunction)((Object)func)).isStatic(resolveAll);
        }
        return func.isStatic();
    }

    public static boolean isStatic(IVariable var) throws DOMException {
        if (var instanceof ICPPInternalVariable) {
            return ((ICPPInternalVariable)((Object)var)).isStatic();
        }
        if (var instanceof ICInternalVariable) {
            return ((ICInternalVariable)((Object)var)).isStatic();
        }
        return var.isStatic();
    }

    public static void setFullyResolved(IBinding binding, boolean val) {
        if (binding instanceof ICInternalFunction) {
            ((ICInternalFunction)((Object)binding)).setFullyResolved(true);
        }
    }

    public static String getDeclaredInSourceFileOnly(IBinding binding, boolean requireDefinition) {
        IASTNode def;
        IASTNode[] decls;
        Object ib;
        if (binding instanceof ICPPInternalBinding) {
            ib = (ICPPInternalBinding)binding;
            decls = ib.getDeclarations();
            def = ib.getDefinition();
        } else if (binding instanceof ICInternalBinding) {
            ib = (ICInternalBinding)((Object)binding);
            decls = ib.getDeclarations();
            def = ib.getDefinition();
        } else {
            return null;
        }
        if (requireDefinition && def == null) {
            return null;
        }
        String filePath = null;
        if (def != null && (filePath = ASTInternal.isPartOfSource(filePath, def)) == null) {
            return null;
        }
        if (decls != null) {
            int i = 0;
            while (i < decls.length) {
                IASTNode node = decls[i];
                if (node != null && (filePath = ASTInternal.isPartOfSource(filePath, node)) == null) {
                    return null;
                }
                ++i;
            }
        }
        return filePath;
    }

    private static String isPartOfSource(String filePath, IASTNode decl) {
        if (filePath == null) {
            IASTTranslationUnit tu = decl.getTranslationUnit();
            if (tu.isHeaderUnit()) {
                return null;
            }
            filePath = tu.getFilePath();
        }
        if (!filePath.equals(decl.getContainingFilename())) {
            return null;
        }
        return filePath;
    }

    public static String getDeclaredInOneFileOnly(IBinding binding) {
        IASTNode def;
        IASTNode[] decls;
        Object ib;
        if (binding instanceof ICPPInternalBinding) {
            ib = (ICPPInternalBinding)binding;
            decls = ib.getDeclarations();
            def = ib.getDefinition();
        } else if (binding instanceof ICInternalBinding) {
            ib = (ICInternalBinding)((Object)binding);
            decls = ib.getDeclarations();
            def = ib.getDefinition();
        } else {
            return null;
        }
        String filePath = null;
        if (def != null) {
            filePath = def.getContainingFilename();
        }
        if (decls != null) {
            int i = 0;
            while (i < decls.length) {
                IASTNode node = decls[i];
                if (node != null) {
                    String fn = node.getContainingFilename();
                    if (filePath == null) {
                        filePath = fn;
                    } else if (!filePath.equals(fn)) {
                        return null;
                    }
                }
                ++i;
            }
        }
        return filePath;
    }
}

