/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.rewrite.MacroExpansionExplorer;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner.MacroExpansionStep;
import org.eclipse.cdt.internal.core.parser.scanner.SingleMacroExpansionExplorer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMacroExpansionExplorer
extends MacroExpansionExplorer {
    private final char[] fSource;
    private final int[] fBoundaries;
    private final SingleMacroExpansionExplorer[] fDelegates;
    private final String fFilePath;
    private final Map<IMacroBinding, IASTFileLocation> fMacroLocations;
    private MacroExpansionStep fCachedStep;
    private int fCachedStepID = -1;

    public MultiMacroExpansionExplorer(IASTTranslationUnit tu, IASTFileLocation loc) {
        if (tu == null || loc == null || loc.getNodeLength() == 0) {
            throw new IllegalArgumentException();
        }
        ILocationResolver resolver = this.getResolver(tu);
        IASTNodeSelector nodeLocator = tu.getNodeSelector(null);
        IASTPreprocessorMacroExpansion[] expansions = resolver.getMacroExpansions(loc);
        int count = expansions.length;
        loc = this.extendLocation(loc, expansions);
        this.fMacroLocations = this.getMacroLocations(resolver);
        this.fFilePath = tu.getFilePath();
        this.fSource = resolver.getUnpreprocessedSignature(loc);
        this.fBoundaries = new int[count * 2 + 1];
        this.fDelegates = new SingleMacroExpansionExplorer[count];
        int firstOffset = loc.getNodeOffset();
        int bidx = -1;
        int didx = -1;
        IASTPreprocessorMacroExpansion[] iASTPreprocessorMacroExpansionArray = expansions;
        int n = expansions.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorMacroExpansion expansion = iASTPreprocessorMacroExpansionArray[n2];
            IASTName ref = expansion.getMacroReference();
            if (ref != null) {
                ArrayList<IASTName> refs = new ArrayList<IASTName>();
                refs.add(ref);
                refs.addAll((Collection)Arrays.asList(expansion.getNestedMacroReferences()));
                IASTFileLocation refLoc = expansion.getFileLocation();
                int from = refLoc.getNodeOffset() - firstOffset;
                int to = from + refLoc.getNodeLength();
                IASTNode enclosing = nodeLocator.findEnclosingNode(from + firstOffset - 1, 2);
                boolean isPPCond = enclosing instanceof IASTPreprocessorIfStatement || enclosing instanceof IASTPreprocessorElifStatement;
                this.fBoundaries[++bidx] = from;
                this.fBoundaries[++bidx] = to;
                this.fDelegates[++didx] = new SingleMacroExpansionExplorer(new String(this.fSource, from, to - from), refs.toArray(new IASTName[refs.size()]), this.fMacroLocations, this.fFilePath, refLoc.getStartingLineNumber(), isPPCond);
            }
            ++n2;
        }
        this.fBoundaries[++bidx] = this.fSource.length;
    }

    private ILocationResolver getResolver(IASTTranslationUnit tu) {
        ILocationResolver resolver = (ILocationResolver)tu.getAdapter(ILocationResolver.class);
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        return resolver;
    }

    private IASTFileLocation extendLocation(IASTFileLocation loc, IASTPreprocessorMacroExpansion[] expansions) {
        int count = expansions.length;
        if (count > 0) {
            int from = loc.getNodeOffset();
            int to = from + loc.getNodeLength();
            int lfrom = expansions[0].getFileLocation().getNodeOffset();
            IASTFileLocation l = expansions[count - 1].getFileLocation();
            int lto = l.getNodeOffset() + l.getNodeLength();
            if (lfrom < from || lto > to) {
                from = Math.min(from, lfrom);
                to = Math.max(to, lto);
                loc = new ASTFileLocation(loc.getFileName(), from, to - from);
            }
        }
        return loc;
    }

    private Map<IMacroBinding, IASTFileLocation> getMacroLocations(ILocationResolver resolver) {
        HashMap<IMacroBinding, IASTFileLocation> result = new HashMap<IMacroBinding, IASTFileLocation>();
        this.addLocations(resolver.getBuiltinMacroDefinitions(), result);
        this.addLocations(resolver.getMacroDefinitions(), result);
        return result;
    }

    private void addLocations(IASTPreprocessorMacroDefinition[] defs, Map<IMacroBinding, IASTFileLocation> result) {
        IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding;
            IASTFileLocation loc;
            IASTPreprocessorMacroDefinition def = iASTPreprocessorMacroDefinitionArray[n2];
            IASTName name = def.getName();
            if (name != null && (loc = name.getFileLocation()) != null && (binding = name.getBinding()) instanceof IMacroBinding) {
                loc = new ASTFileLocation(loc.getFileName(), loc.getNodeOffset(), loc.getNodeLength());
                result.put((IMacroBinding)binding, loc);
            }
            ++n2;
        }
    }

    public MultiMacroExpansionExplorer(IASTTranslationUnit tu, IRegion loc) {
        this(tu, new ASTFileLocation(tu.getFilePath(), loc.getOffset(), loc.getLength()));
    }

    public MacroExpansionExplorer.IMacroExpansionStep getFullExpansion() {
        List<ReplaceEdit> edits = this.combineReplaceEdits(this.fDelegates.length);
        return new MacroExpansionStep(new String(this.fSource), null, null, edits.toArray(new ReplaceEdit[edits.size()]));
    }

    private List<ReplaceEdit> combineReplaceEdits(int count) {
        ArrayList<ReplaceEdit> edits = new ArrayList<ReplaceEdit>();
        int i = 0;
        while (i < count) {
            MacroExpansionExplorer.IMacroExpansionStep step = this.fDelegates[i].getFullExpansion();
            this.shiftAndAddEdits(this.fBoundaries[2 * i], step.getReplacements(), edits);
            ++i;
        }
        return edits;
    }

    private void shiftAndAddEdits(int shift, ReplaceEdit[] stepEdits, List<ReplaceEdit> target) {
        int j = 0;
        while (j < stepEdits.length) {
            ReplaceEdit r = stepEdits[j];
            String rtext = r.getText();
            target.add(new ReplaceEdit(shift + r.getOffset(), r.getLength(), rtext));
            ++j;
        }
    }

    public int getExpansionStepCount() {
        int result = 0;
        int i = 0;
        while (i < this.fDelegates.length) {
            result += this.fDelegates[i].getExpansionStepCount();
            ++i;
        }
        return result;
    }

    public MacroExpansionExplorer.IMacroExpansionStep getExpansionStep(int step) throws IndexOutOfBoundsException {
        if (step < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.fCachedStep != null && this.fCachedStepID == step) {
            return this.fCachedStep;
        }
        MacroExpansionStep dresult = null;
        StringBuilder before = new StringBuilder();
        before.append(this.fSource, 0, this.fBoundaries[0]);
        int i = 0;
        while (i < this.fDelegates.length) {
            SingleMacroExpansionExplorer delegate = this.fDelegates[i];
            int dsteps = delegate.getExpansionStepCount();
            if (step < dsteps) {
                dresult = delegate.getExpansionStep(step);
                break;
            }
            before.append(delegate.getFullExpansion().getCodeAfterStep());
            this.appendGap(before, i);
            step -= dsteps;
            ++i;
        }
        if (dresult == null) {
            throw new IndexOutOfBoundsException();
        }
        int shift = before.length();
        int end = this.fBoundaries[2 * i + 1];
        before.append(dresult.getCodeBeforeStep());
        before.append(this.fSource, end, this.fSource.length - end);
        ArrayList<ReplaceEdit> replacements = new ArrayList<ReplaceEdit>();
        this.shiftAndAddEdits(shift, dresult.getReplacements(), replacements);
        this.fCachedStep = new MacroExpansionStep(before.toString(), dresult.getExpandedMacro(), dresult.getLocationOfExpandedMacroDefinition(), replacements.toArray(new ReplaceEdit[replacements.size()]));
        this.fCachedStepID = step;
        return this.fCachedStep;
    }

    private void appendGap(StringBuilder result, int i) {
        int idx = 2 * i + 1;
        int gapFrom = this.fBoundaries[idx];
        int gapTo = this.fBoundaries[++idx];
        result.append(this.fSource, gapFrom, gapTo - gapFrom);
    }

    private static final class ASTFileLocation
    implements IASTFileLocation {
        private final String fFilePath;
        private final int fOffset;
        private final int fLength;

        private ASTFileLocation(String filePath, int offset, int length) {
            this.fFilePath = filePath;
            this.fOffset = offset;
            this.fLength = length;
        }

        public int getNodeOffset() {
            return this.fOffset;
        }

        public int getNodeLength() {
            return this.fLength;
        }

        public String getFileName() {
            return this.fFilePath;
        }

        public int getStartingLineNumber() {
            return 0;
        }

        public int getEndingLineNumber() {
            return 0;
        }

        public IASTFileLocation asFileLocation() {
            return this;
        }
    }
}

