/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.scannerinfo;

import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RemoteIncludeDialog
extends Dialog {
    private Shell shell;
    private Button b_ok;
    private Button b_cancel;
    private Button b_browse;
    private Button b_add2confs;
    private Button b_add2langs;
    private Text text;
    private String pathText = null;
    private boolean result = false;
    private String directory = null;
    private boolean isAllLanguages = false;
    private boolean isAllConfigurations = false;
    private SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Widget pressed = e.widget;
            if (pressed.equals(RemoteIncludeDialog.this.b_ok)) {
                RemoteIncludeDialog.this.directory = RemoteIncludeDialog.this.text.getText();
                RemoteIncludeDialog.this.isAllConfigurations = RemoteIncludeDialog.this.b_add2confs.getSelection();
                RemoteIncludeDialog.this.isAllLanguages = RemoteIncludeDialog.this.b_add2langs.getSelection();
                RemoteIncludeDialog.this.result = true;
                RemoteIncludeDialog.this.shell.dispose();
            } else if (pressed.equals(RemoteIncludeDialog.this.b_cancel)) {
                RemoteIncludeDialog.this.result = false;
                RemoteIncludeDialog.this.shell.dispose();
            } else if (pressed.equals(RemoteIncludeDialog.this.b_browse)) {
                SystemRemoteFolderDialog folderDialog = new SystemRemoteFolderDialog(RemoteIncludeDialog.this.shell, "Select Remote Directory");
                folderDialog.open();
                Object remoteObject = folderDialog.getSelectedObject();
                if (remoteObject instanceof IRemoteFile) {
                    IRemoteFile folder = (IRemoteFile)remoteObject;
                    RemoteIncludeDialog.this.text.setText(folder.getCanonicalPath());
                }
            }
        }
    };

    public RemoteIncludeDialog(Shell parent, String title) {
        super(parent);
        this.setText(title);
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setText(this.getText());
        this.createDialogArea((Composite)this.shell);
        this.shell.pack();
        Rectangle r1 = parent.getBounds();
        Rectangle r2 = this.shell.getBounds();
        int x = r1.x + (r1.width - r2.width) / 2;
        int y = r1.y + (r1.height - r2.height) / 2;
        this.shell.setBounds(x, y, r2.width, r2.height);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected Control createDialogArea(Composite c) {
        RowLayout rl = new RowLayout(512);
        rl.marginHeight = 5;
        rl.marginWidth = 5;
        rl.fill = true;
        c.setLayout((Layout)rl);
        Label l1 = new Label(c, 0);
        l1.setText("Directory:");
        Composite c1 = new Composite(c, 0);
        c1.setLayout((Layout)new RowLayout(256));
        this.text = new Text(c1, 2052);
        this.text.setLayoutData((Object)new RowData(300, -1));
        if (this.pathText != null) {
            this.text.setText(this.pathText);
        }
        this.b_browse = new Button(c1, 8);
        this.b_browse.setText("Browse...");
        this.b_browse.addSelectionListener(this.listener);
        Composite c2 = new Composite(c, 0);
        c2.setLayout((Layout)new RowLayout(512));
        this.b_add2confs = new Button(c2, 32);
        this.b_add2confs.setText("Add to all configurations");
        this.b_add2langs = new Button(c2, 32);
        this.b_add2langs.setText("Add to all languages");
        Composite c3 = new Composite(c, 0);
        c3.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData();
        gd.widthHint = 200;
        Label ph = new Label(c3, 0);
        ph.setLayoutData((Object)gd);
        ph.setText("");
        this.b_ok = new Button(c3, 8);
        this.b_ok.setText("Ok");
        this.b_ok.addSelectionListener(this.listener);
        gd = new GridData();
        gd.widthHint = 80;
        this.b_ok.setLayoutData((Object)gd);
        this.b_cancel = new Button(c3, 8);
        this.b_cancel.setText("Cancel");
        this.b_cancel.addSelectionListener(this.listener);
        this.b_cancel.setLayoutData((Object)new RowData(300, -1));
        gd = new GridData();
        gd.widthHint = 80;
        this.b_cancel.setLayoutData((Object)gd);
        return c;
    }

    public void setPathText(String path) {
        this.pathText = path;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isAllLanguages() {
        return this.isAllLanguages;
    }

    public boolean isAllConfigurations() {
        return this.isAllConfigurations;
    }
}

