/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search.actions;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.model.WorkingCopy;
import org.eclipse.ptp.internal.rdt.core.navigation.INavigationService;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.ui.search.actions.SelectionParseAction;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenDeclarationsAction
extends SelectionParseAction {
    ITextSelection fTextSelection;
    private String fSelectedText;

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.getString((String)"OpenDeclarations.label"));
        this.setToolTipText(CEditorMessages.getString((String)"OpenDeclarations.tooltip"));
        this.setDescription(CEditorMessages.getString((String)"OpenDeclarations.description"));
    }

    private INavigationService getNavigationService(IProject project) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (!(serviceProvider instanceof IIndexServiceProvider2)) {
            return null;
        }
        INavigationService service = ((IIndexServiceProvider2)serviceProvider).getNavigationService();
        return service;
    }

    protected IStatus performNavigation(IProgressMonitor monitor) throws CoreException {
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        if (workingCopy == null) {
            return Status.CANCEL_STATUS;
        }
        ICProject project = workingCopy.getCProject();
        if (this.fEditor.isDirty()) {
            String contents = this.fEditor.getViewer().getDocument().get();
            workingCopy = new WorkingCopy(null, (ITranslationUnit)workingCopy, contents);
        } else {
            workingCopy = (ITranslationUnit)ModelAdapter.adaptElement(null, (ICElement)workingCopy, (int)0, (boolean)true);
        }
        Scope scope = new Scope(workingCopy.getCProject().getProject().getName());
        int selectionStart = this.fTextSelection.getOffset();
        int selectionLength = this.fTextSelection.getLength();
        INavigationService service = this.getNavigationService(workingCopy.getCProject().getProject());
        OpenDeclarationResult result = service.openDeclaration(scope, (ITranslationUnit)workingCopy, this.fSelectedText, selectionStart, selectionLength, monitor);
        if (result == null) {
            return Status.OK_STATUS;
        }
        switch (result.getResultType()) {
            case RESULT_NAMES: {
                IName[] names = (IName[])result.getResult();
                this.navigateOneLocation(names, project);
                break;
            }
            case RESULT_C_ELEMENTS: {
                ICElement[] elements = (ICElement[])result.getResult();
                this.navigateCElements(elements);
                break;
            }
            case RESULT_INCLUDE_PATH: {
                String path = (String)result.getResult();
                this.open(path, (ICElement)project);
                break;
            }
            case FAILURE_SYMBOL_LOOKUP: {
                String symbol = (String)result.getResult();
                this.reportSymbolLookupFailure(symbol);
                break;
            }
            default: {
                this.reportSelectionMatchFailure();
            }
        }
        return Status.OK_STATUS;
    }

    private URI replacePath(URI u, String path) {
        try {
            return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), path, u.getQuery(), u.getFragment());
        }
        catch (URISyntaxException e) {
            RDTLog.logError((Throwable)e);
            return null;
        }
    }

    private void open(String path, ICElement element) {
        this.open(path, element, -1, -1);
    }

    private void open(String path, ICElement element, int offset, int length) {
        URI uri = this.replacePath(element.getLocationURI(), path);
        if (uri == null) {
            return;
        }
        this.open(uri, element, offset, length);
    }

    private void open(final URI uri, final ICElement element, final int offset, final int length) {
        this.runInUIThread(new Runnable(){

            public void run() {
                try {
                    OpenDeclarationsAction.this.clearStatusLine();
                    IEditorPart editor = EditorUtility.openInEditor((URI)uri, (ICElement)element);
                    if (editor instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editor;
                        if (offset >= 0 && length >= 0) {
                            textEditor.selectAndReveal(offset, length);
                        }
                    } else {
                        OpenDeclarationsAction.this.reportSourceFileOpenFailure(uri.toString());
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.log((Throwable)e);
                }
            }
        });
    }

    private void navigateCElements(final ICElement[] elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        this.runInUIThread(new Runnable(){

            public void run() {
                ICElement target = elements.length == 1 ? elements[0] : OpenActionUtil.selectCElement((ICElement[])elements, (Shell)OpenDeclarationsAction.this.getSite().getShell(), (String)CEditorMessages.getString((String)"OpenDeclarationsAction.dialog.title"), (String)CEditorMessages.getString((String)"OpenDeclarationsAction.selectMessage"), (int)-2112870367, (int)0);
                if (target instanceof ISourceReference) {
                    try {
                        ISourceRange sourceRange = ((ISourceReference)target).getSourceRange();
                        URI uri = OpenDeclarationsAction.this.replacePath(target.getLocationURI(), target.getPath().toString());
                        OpenDeclarationsAction.this.open(uri, target, sourceRange.getIdStartPos(), sourceRange.getIdLength());
                    }
                    catch (CModelException e) {
                        RDTLog.logError((Throwable)e);
                    }
                }
            }
        });
    }

    protected void reportSourceFileOpenFailure(String path) {
        this.showStatusLineMessage(MessageFormat.format(CSearchMessages.SelectionParseAction_FileOpenFailure_format, path));
    }

    private void navigateOneLocation(IName[] declNames, ICProject project) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName name = iNameArray[n2];
            IASTFileLocation fileloc = name.getFileLocation();
            if (fileloc != null) {
                String filePath = fileloc.getFileName();
                int offset = fileloc.getNodeOffset();
                int length = fileloc.getNodeLength();
                this.open(filePath, (ICElement)project, offset, length);
                return;
            }
            ++n2;
        }
    }

    public void run() {
        this.computeSelectedWord();
        if (this.fTextSelection != null) {
            new WrapperJob().schedule();
        }
    }

    private void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void runSync() throws CoreException {
        this.computeSelectedWord();
        if (this.fTextSelection != null) {
            this.performNavigation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void computeSelectedWord() {
        this.fTextSelection = this.getSelectedStringFromEditor();
        this.fSelectedText = null;
        if (this.fTextSelection != null) {
            if (this.fTextSelection.getLength() > 0) {
                this.fSelectedText = this.fTextSelection.getText();
            } else {
                IDocument document = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                IRegion reg = CWordFinder.findWord((IDocument)document, (int)this.fTextSelection.getOffset());
                if (reg != null && reg.getLength() > 0) {
                    try {
                        this.fSelectedText = document.get(reg.getOffset(), reg.getLength());
                    }
                    catch (BadLocationException e) {
                        RDTLog.logError((Throwable)e);
                    }
                }
            }
        }
    }

    private class WrapperJob
    extends Job {
        WrapperJob() {
            super(CEditorMessages.getString((String)"OpenDeclarations.dialog.title"));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                return OpenDeclarationsAction.this.performNavigation(monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
    }
}

