/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.ui.progress;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.cell.ui.progress.ICancelCallback;
import org.eclipse.ptp.cell.ui.progress.Messages;
import org.eclipse.ptp.cell.ui.progress.ProgressInfo;
import org.eclipse.ptp.cell.utils.debug.Debug;

public class ProgressQueue {
    private ArrayList operations = new ArrayList();
    private IProgressMonitor monitor = null;
    private ICancelCallback cancelCallBack = null;
    int currentOperationIndex = 0;
    private boolean cancelled = false;
    private boolean interrupted = false;
    private boolean started = false;
    private boolean finished = false;
    private String taskName = null;
    private String interruptMessage = Messages.ProgressQueue_Interrupted;
    private String cancelMessage = Messages.ProgressQueue_Canceling;
    ProgressMonitorPoll progressMonitorPoll;

    public ProgressQueue() {
        this.monitor = null;
    }

    public ProgressQueue(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public ProgressQueue(IProgressMonitor monitor, String taskName) {
        this.taskName = taskName;
        if (monitor != null) {
            this.monitor = monitor;
        }
    }

    public void addWait(int id, String description, int steps) {
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"Cannot add new steps after ProgressQueue was started");
        Assert.isTrue((!this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        this.operations.add(new ProgressInfo(id, description, steps));
    }

    public synchronized void setTaskName(String taskName) {
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"Cannot set task name after ProgressQueue was started");
        Assert.isTrue((!this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        this.taskName = taskName;
    }

    public synchronized void setMonitor(IProgressMonitor monitor) {
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"Cannot set monitor after ProgressQueue was started");
        Assert.isTrue((!this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        this.monitor = monitor;
    }

    public synchronized IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public synchronized void setCancelCallBack(ICancelCallback cancelCallBack) {
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"Cannot set cancel callback after ProgressQueue was started");
        Assert.isTrue((!this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        this.cancelCallBack = cancelCallBack;
    }

    public synchronized String getCancelMessage() {
        return this.cancelMessage;
    }

    public synchronized void setCancelMessage(String cancelMessage) {
        Assert.isTrue((!this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        this.cancelMessage = cancelMessage;
    }

    public synchronized String getInterruptMessage() {
        return this.interruptMessage;
    }

    public synchronized void setInterruptMessage(String interruptMessage) {
        Assert.isTrue((!this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        this.interruptMessage = interruptMessage;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void start() {
        Debug.POLICY.enter(Debug.DEBUG_PROGRESS);
        Assert.isTrue((!this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        Assert.isTrue((this.operations.size() > 0 ? 1 : 0) != 0, (String)"Must have at least one event in queue");
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"Must not already been started");
        this.started = true;
        if (this.monitor != null) {
            if (Debug.DEBUG_PROGRESS) {
                Debug.POLICY.trace("Attaching to progress monitor. Total of {0} steps and {1} progress entries.", this.countAllSteps(), this.operations.size());
            }
            this.monitor.beginTask(this.taskName, this.countAllSteps());
            this.showOperationMessage(0);
            this.progressMonitorPoll = new ProgressMonitorPoll();
            this.progressMonitorPoll.start();
        }
    }

    public synchronized void waitProgress() {
        Debug.POLICY.enter(Debug.DEBUG_PROGRESS);
        Assert.isTrue((this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        this.waitProgressIndexed(Integer.MAX_VALUE);
    }

    public synchronized void waitProgress(int event) {
        Debug.POLICY.enter(Debug.DEBUG_PROGRESS, new Object[]{event});
        Assert.isTrue((this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        int eventIndex = this.seachIndex(event);
        this.waitProgressIndexed(eventIndex);
    }

    private synchronized void waitProgressIndexed(int referenceIndex) {
        while (!(this.cancelled || this.interrupted || this.finished || this.currentOperationIndex >= referenceIndex)) {
            try {
                Debug.POLICY.trace(Debug.DEBUG_PROGRESS, "Waiting for index {0}, currently at {1}.", referenceIndex, this.currentOperationIndex);
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Debug.POLICY.enter(Debug.DEBUG_PROGRESS);
        ProgressQueue progressQueue = this;
        synchronized (progressQueue) {
            if (this.cancelled) {
                return;
            }
            Assert.isTrue((this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        }
        this.doCancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Debug.POLICY.enter(Debug.DEBUG_PROGRESS);
        ProgressQueue progressQueue = this;
        synchronized (progressQueue) {
            if (this.interrupted) {
                return;
            }
            if (this.cancelled) {
                return;
            }
            Assert.isTrue((this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        }
        this.doInterrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Debug.POLICY.enter(Debug.DEBUG_PROGRESS);
        ProgressQueue progressQueue = this;
        synchronized (progressQueue) {
            Assert.isTrue((this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        }
        this.doFinish();
    }

    public synchronized void notifyOperationStarted(int id) {
        Debug.POLICY.enter(Debug.DEBUG_PROGRESS, new Object[]{id});
        if (this.interrupted || this.cancelled) {
            return;
        }
        Assert.isTrue((this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        int operationIndex = this.seachIndex(id);
        if (operationIndex == -1) {
            Debug.POLICY.error(Debug.DEBUG_PROGRESS, "Unknown id {0}", id);
            return;
        }
        Assert.isTrue((this.currentOperationIndex <= operationIndex ? 1 : 0) != 0, (String)"Operation out of order");
        if (this.currentOperationIndex == operationIndex) {
            return;
        }
        this.updateCompletedProgress(operationIndex - 1);
        this.checkFlags(operationIndex - 1);
        if (this.finished) {
            return;
        }
        this.showOperationMessage(operationIndex);
        this.currentOperationIndex = operationIndex;
        this.notifyAll();
    }

    public synchronized void notifyOperationCompleted(int id) {
        Debug.POLICY.enter(Debug.DEBUG_PROGRESS, new Object[]{id});
        if (this.interrupted || this.cancelled) {
            return;
        }
        Assert.isTrue((this.started && !this.interrupted && !this.cancelled && !this.finished ? 1 : 0) != 0);
        int operationIndex = this.seachIndex(id);
        if (operationIndex == -1) {
            Debug.POLICY.error(Debug.DEBUG_PROGRESS, "Unknown id {0}", id);
            return;
        }
        Assert.isTrue((this.currentOperationIndex <= operationIndex ? 1 : 0) != 0, (String)"Operation out of order");
        this.updateCompletedProgress(operationIndex);
        this.checkFlags(operationIndex);
        if (this.finished) {
            return;
        }
        this.currentOperationIndex = operationIndex + 1;
        this.showOperationMessage(this.currentOperationIndex);
        this.notifyAll();
    }

    private void showOperationMessage(int operationIndex) {
        ProgressInfo newInfo = (ProgressInfo)this.operations.get(operationIndex);
        if (this.monitor != null) {
            Debug.POLICY.trace(Debug.DEBUG_PROGRESS, "Show new message for {0}: {1}.", operationIndex, newInfo.description);
            if (newInfo.description != null) {
                this.monitor.subTask(newInfo.description);
            }
        }
    }

    private void checkFlags(int operationIndex) {
        if (operationIndex >= this.operations.size() - 1) {
            this.doFinish();
        }
    }

    private void updateCompletedProgress(int lastOperationIndex) {
        int steps = this.countStepsInterval(this.currentOperationIndex, lastOperationIndex);
        if (this.monitor != null) {
            Debug.POLICY.error(Debug.DEBUG_PROGRESS, "Complete progress from {0} to {1}: {2} steps.", lastOperationIndex, this.currentOperationIndex, steps);
            if (steps > 0) {
                this.monitor.worked(steps);
            }
        }
    }

    private int countStepsInterval(int fromIndex, int toIndex) {
        int steps = 0;
        int index = fromIndex;
        while (index <= toIndex) {
            ProgressInfo info = (ProgressInfo)this.operations.get(index);
            steps += info.steps;
            ++index;
        }
        return steps;
    }

    private int seachIndex(int id) {
        Iterator iterator = this.operations.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            ProgressInfo info = (ProgressInfo)iterator.next();
            if (info.id == id) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int countAllSteps() {
        return this.countStepsInterval(0, this.operations.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel(boolean byUser) {
        Debug.POLICY.trace(Debug.DEBUG_PROGRESS, "ProgressQueue set to cancelled.");
        ICancelCallback callbackCopy = null;
        ProgressQueue progressQueue = this;
        synchronized (progressQueue) {
            this.monitor.subTask(Messages.ProgressQueue_Canceling);
            this.cancelled = true;
            callbackCopy = this.cancelCallBack;
            this.cleanUp();
        }
        if (callbackCopy != null) {
            callbackCopy.cancel(byUser);
        }
    }

    private synchronized void doInterrupt() {
        Debug.POLICY.trace(Debug.DEBUG_PROGRESS, "ProgressQueue set to interrupted.");
        this.interrupted = true;
        this.cleanUp();
    }

    private synchronized void doFinish() {
        Debug.POLICY.trace(Debug.DEBUG_PROGRESS, "ProgressQueue set to finished.");
        this.finished = true;
        this.updateCompletedProgress(this.operations.size() - 1);
        this.cleanUp();
    }

    private void cleanUp() {
        if (this.progressMonitorPoll != null) {
            this.progressMonitorPoll.interrupt();
            this.progressMonitorPoll = null;
        }
        this.cancelCallBack = null;
        this.monitor = null;
        if (Debug.DEBUG_PROGRESS) {
            Debug.POLICY.trace("Detached from progress monitor.");
        }
        this.notifyAll();
    }

    private void pollMonitor() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            this.doCancel(true);
        }
    }

    class ProgressMonitorPoll
    extends Thread {
        public ProgressMonitorPoll() {
            super(Messages.ProgressQueue_CancelStatusPolling);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Debug.POLICY.enter(Debug.DEBUG_PROGRESS);
            while (!this.isInterrupted()) {
                try {
                    ProgressMonitorPoll progressMonitorPoll = this;
                    synchronized (progressMonitorPoll) {
                        this.wait(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                ProgressQueue.this.pollMonitor();
            }
            Debug.POLICY.exit(Debug.DEBUG_PROGRESS);
        }
    }
}

