/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.perf.IPerformanceLaunchConfigurationConstants;
import org.eclipse.ptp.perf.internal.PerfStep;
import org.eclipse.ptp.perf.toolopts.BuildTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfBuilder
extends PerfStep
implements IPerformanceLaunchConfigurationConstants {
    private String progPath = null;
    private boolean runbuilt = false;
    private IManagedProject managedBuildProj = null;
    private IConfiguration newBuildConfig = null;
    private String buildConf = null;
    private IConfiguration olddefbuildconf = null;
    private String outputLocation = null;
    private Map<String, String> buildMods = null;
    private String newname = null;
    private String binary = null;
    private BuildTool tool = null;

    public PerfBuilder(ILaunchConfiguration conf, BuildTool btool, Map<String, String> buildMods) throws CoreException {
        super(conf, "Instrumenting/Building");
        this.buildMods = buildMods;
        this.tool = btool;
        this.initBuild(conf);
    }

    public PerfBuilder(ILaunchConfiguration conf, BuildTool btool) throws CoreException {
        super(conf, "Instrumenting/Building");
        this.tool = btool;
        this.initBuild(conf);
    }

    private void initBuild(ILaunchConfiguration conf) throws CoreException {
        this.outputLocation = this.projectLocation;
        this.buildConf = this.configuration.getAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", null);
        if (this.tool == null) {
            return;
        }
        if (ManagedBuildManager.canGetBuildInfo((IResource)this.thisCProject.getResource())) {
            this.runbuilt = this.initMMBuild();
        }
    }

    public boolean getBuildSuccessful() {
        return this.runbuilt;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public String getProgramPath() {
        return this.progPath;
    }

    public void buildIndstrumented(IProgressMonitor monitor) throws Exception {
        if (this.tool != null) {
            if (!ManagedBuildManager.canGetBuildInfo((IResource)this.thisCProject.getResource())) {
                this.standardMakeBuild(monitor);
            } else if (this.runbuilt) {
                this.runbuilt = this.initMMBuildConf();
                if (this.runbuilt) {
                    this.runbuilt = this.managedMakeBuild(monitor);
                }
            }
        }
    }

    public void standardMakeBuild(IProgressMonitor monitor) throws CoreException {
        File compilerInclude = new File(String.valueOf(this.projectLocation) + File.separator + "eclipse.inc");
        File compilerDef = new File(String.valueOf(this.projectLocation) + File.separator + "eclipse.inc.default");
        try {
            if (compilerInclude.exists()) {
                int len;
                FileInputStream in = new FileInputStream(compilerInclude);
                FileOutputStream out = new FileOutputStream(compilerDef);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            BufferedWriter makeOut = new BufferedWriter(new FileWriter(compilerInclude));
            String allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration, this.outputLocation);
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getCcCompiler(), this.configuration, this.outputLocation)) + " " + allargs + "\n");
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getCxxCompiler(), this.configuration, this.outputLocation)) + " " + allargs + "\n");
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getF90Compiler(), this.configuration, this.outputLocation)) + " " + allargs + "\n");
            makeOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MakeTargetManager targetMan = new MakeTargetManager();
        targetMan.startup();
        IMakeTarget[] targs = targetMan.getTargets((IContainer)this.thisProject);
        IMakeTarget select = null;
        int i = 0;
        while (i < targs.length) {
            if (targs[i].getName().equals("all")) {
                select = targs[i];
                break;
            }
            ++i;
        }
        if (select == null) {
            System.out.println("No Make Target: all");
            this.runbuilt = false;
            return;
        }
        select.build(monitor);
        targetMan.shutdown();
        if (compilerDef.exists()) {
            try {
                int len;
                FileInputStream in = new FileInputStream(compilerDef);
                FileOutputStream out = new FileOutputStream(compilerInclude);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.runbuilt = true;
    }

    private boolean initMMBuild() throws CoreException {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.thisCProject.getResource());
        if (info == null || !info.isValid()) {
            System.out.println("No info!!!");
            return false;
        }
        this.managedBuildProj = info.getManagedProject();
        if (this.managedBuildProj == null) {
            System.out.println("No managed project!!!");
            return false;
        }
        this.olddefbuildconf = info.getDefaultConfiguration();
        this.binary = info.getBuildArtifactName();
        String bextension = info.getBuildArtifactExtension();
        if (bextension.length() > 0) {
            this.binary = String.valueOf(this.binary) + "." + bextension;
        }
        IConfiguration[] buildconfigs = info.getManagedProject().getConfigurations();
        IConfiguration selectedconf = null;
        int i = 0;
        while (i < buildconfigs.length) {
            if (buildconfigs[i].getName().equals(this.buildConf)) {
                selectedconf = buildconfigs[i];
                break;
            }
            ++i;
        }
        if (selectedconf == null) {
            System.out.println("No Conf Selected");
            return false;
        }
        if (selectedconf.getName() == null) {
            System.out.println("Selected conf has no name");
            return false;
        }
        String basename = selectedconf.getName();
        this.newname = null;
        String addname = this.configuration.getAttribute("performance_tool_build_configuration_name_modifier." + this.tool.toolID, "PerformanceAnalysis");
        this.newname = String.valueOf(basename) + "_" + addname;
        if (addname.equals("PerformanceAnalysis")) {
            this.newname = String.valueOf(this.newname) + "_" + this.tool.toolName;
        }
        this.progPath = String.valueOf(this.newname) + File.separator + this.binary;
        if (this.configuration.getAttribute("perf_executable_path_tag_for_path_value", null) != null) {
            this.outputLocation = this.thisProject.getFile(this.newname).getLocation().toOSString();
        }
        boolean confExists = false;
        IConfiguration[] confs = this.managedBuildProj.getConfigurations();
        int i2 = 0;
        while (i2 < confs.length) {
            if (confs[i2].getName().equals(this.newname) || confs[i2].getName().indexOf(this.newname) >= 0) {
                confExists = true;
                this.newBuildConfig = confs[i2];
                break;
            }
            ++i2;
        }
        if (!confExists) {
            this.newBuildConfig = this.managedBuildProj.createConfigurationClone(selectedconf, String.valueOf(selectedconf.getId()) + "." + ManagedBuildManager.getRandomNumber());
        }
        if (this.newBuildConfig == null) {
            System.out.println("No config!");
            return false;
        }
        return true;
    }

    public boolean initMMBuildConf() throws CoreException, FileNotFoundException {
        int n;
        ITool[] tools;
        this.newBuildConfig.setName(this.newname);
        IToolChain chain = this.newBuildConfig.getToolChain();
        ITool[] iToolArray = tools = chain.getTools();
        int n2 = tools.length;
        int n3 = 0;
        while (n3 < n2) {
            ITool it = iToolArray[n3];
            IOption[] iOptionArray = it.getOptions();
            n = iOptionArray.length;
            int n4 = 0;
            while (n4 < n) {
                IOption op = iOptionArray[n4];
                if (op == null || op.getName() == null) {
                    // empty if block
                }
                ++n4;
            }
            ++n3;
        }
        String allargs = "";
        if (!this.tool.getGlobalCompiler().equals(this.tool.getCcCompiler())) {
            allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration, this.outputLocation);
        }
        int numChanges = 0;
        int i = 0;
        while (i < tools.length) {
            String toolid;
            if (this.buildMods != null) {
                for (String opName : this.buildMods.keySet()) {
                    IOption[] iOptionArray = tools[i].getOptions();
                    int n5 = iOptionArray.length;
                    n = 0;
                    while (n < n5) {
                        IOption op = iOptionArray[n];
                        if (op.getName().equals(opName)) {
                            try {
                                op.setValue(this.buildMods.get(opName));
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n;
                    }
                }
            }
            if ((toolid = tools[i].getId()).indexOf(".c.") >= 0) {
                numChanges += PerfBuilder.modifyCommand(tools[i], this.getToolCommand(this.tool.getCcCompiler(), this.configuration, this.outputLocation), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".cpp.") >= 0) {
                numChanges += PerfBuilder.modifyCommand(tools[i], this.getToolCommand(this.tool.getCxxCompiler(), this.configuration, this.outputLocation), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".fortran.") >= 0) {
                numChanges += PerfBuilder.modifyCommand(tools[i], this.getToolCommand(this.tool.getF90Compiler(), this.configuration, this.outputLocation), allargs, this.tool.replaceCompiler);
            }
            ++i;
        }
        if (numChanges > 0) {
            ManagedBuildManager.saveBuildInfo((IProject)this.thisCProject.getProject(), (boolean)true);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean managedMakeBuild(IProgressMonitor monitor) {
        programPath = this.thisProject.getFile(this.progPath);
        ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.newBuildConfig);
        try {
            this.thisProject.build(6, monitor);
            if (true) ** GOTO lbl19
        }
        catch (Exception v0) {
            return false;
        }
        do {
            if (monitor != null && monitor.isCanceled()) {
                this.restoreBuild();
                this.runbuilt = false;
                throw new OperationCanceledException();
            }
            numMillisecondsToSleep = 1000L;
            try {
                Thread.sleep(numMillisecondsToSleep);
            }
            catch (InterruptedException v1) {}
            programPath = this.thisProject.getFile(this.progPath);
lbl19:
            // 2 sources

        } while (!programPath.exists() || !programPath.getLocation().toFile().exists());
        this.restoreBuild();
        return true;
    }

    private static int modifyCommand(ITool tool, String command, String args, boolean replace) {
        int didChange = 0;
        if (replace) {
            String newcom = String.valueOf(command) + " " + args;
            if (!newcom.equals(tool.getToolCommand())) {
                // empty if block
            }
            tool.setToolCommand(String.valueOf(command) + " " + args);
            didChange = 1;
        } else {
            String newcom = String.valueOf(command) + " " + args + " " + tool.getToolCommand();
            if (!newcom.equals(tool.getToolCommand())) {
                // empty if block
            }
            tool.setToolCommand(newcom);
            didChange = 1;
        }
        return didChange;
    }

    public void restoreBuild() {
        if (ManagedBuildManager.canGetBuildInfo((IResource)this.thisCProject.getResource())) {
            ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.olddefbuildconf);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.buildIndstrumented(monitor);
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, "Build Incomplete", (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, "Build Successful", null);
    }
}

