/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.ui;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CMainTab;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PerfRecompMainTab
extends CMainTab
implements ILaunchConfigurationTab {
    protected Combo projectCombo = null;
    protected Combo buildConfCombo = null;
    protected String projString = null;
    Composite buildConfComp = null;
    Composite exeComp = null;

    public PerfRecompMainTab() {
    }

    public PerfRecompMainTab(boolean x) {
        super(x);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        LaunchUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.launch.launch_configuration_dialog_main_tab");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createBuildConfGroup(comp, 1);
        this.createExeFileGroup(comp, 1);
        this.createVerticalSpacer(comp, 1);
        if (this.wantsTerminalOption()) {
            this.createTerminalOption(comp, 1);
        }
        LaunchUIPlugin.setDialogShell((Shell)parent.getShell());
    }

    protected void createProjectGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LaunchMessages.getString((String)"CMainTab.&ProjectColon"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                int bDex = PerfRecompMainTab.this.buildConfCombo.getSelectionIndex();
                String bString = PerfRecompMainTab.this.buildConfCombo.getText();
                PerfRecompMainTab.this.initConfCombo();
                if (bDex >= 0 && PerfRecompMainTab.this.buildConfCombo.getItemCount() > bDex && PerfRecompMainTab.this.buildConfCombo.getItem(bDex).equals(bString)) {
                    PerfRecompMainTab.this.buildConfCombo.select(bDex);
                } else if (PerfRecompMainTab.this.buildConfCombo.getItemCount() > 0) {
                    PerfRecompMainTab.this.buildConfCombo.select(0);
                }
                PerfRecompMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, LaunchMessages.getString((String)"Launch.common.Browse_1"), null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PerfRecompMainTab.this.handleProjectButtonSelected();
                int bDex = PerfRecompMainTab.this.buildConfCombo.getSelectionIndex();
                String bString = PerfRecompMainTab.this.buildConfCombo.getText();
                PerfRecompMainTab.this.initConfCombo();
                if (bDex >= 0 && PerfRecompMainTab.this.buildConfCombo.getItemCount() > bDex && PerfRecompMainTab.this.buildConfCombo.getItem(bDex).equals(bString)) {
                    PerfRecompMainTab.this.buildConfCombo.select(bDex);
                } else if (PerfRecompMainTab.this.buildConfCombo.getItemCount() > 0) {
                    PerfRecompMainTab.this.buildConfCombo.select(0);
                }
                PerfRecompMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createExeFileGroup(Composite parent, int colSpan) {
        this.exeComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        this.exeComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        this.exeComp.setLayoutData((Object)gd);
        this.fProgLabel = new Label(this.exeComp, 0);
        this.fProgLabel.setText("C/C++/Fortran Application");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fProgLabel.setLayoutData((Object)gd);
        this.fProgText = new Text(this.exeComp, 2052);
        gd = new GridData(768);
        this.fProgText.setLayoutData((Object)gd);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PerfRecompMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(this.exeComp, LaunchMessages.getString((String)"CMainTab.Search..."), null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PerfRecompMainTab.this.handleSearchButtonSelected();
                PerfRecompMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button fBrowseForBinaryButton = this.createPushButton(this.exeComp, LaunchMessages.getString((String)"Launch.common.Browse_2"), null);
        fBrowseForBinaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PerfRecompMainTab.this.handleBinaryBrowseButtonSelected();
                PerfRecompMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createBuildConfGroup(Composite parent, int colSpan) {
        this.buildConfComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 1;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        this.buildConfComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        this.buildConfComp.setLayoutData((Object)gd);
        this.fProgLabel = new Label(this.buildConfComp, 0);
        this.fProgLabel.setText("C/C++/Fortran Build Configuration");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fProgLabel.setLayoutData((Object)gd);
        this.buildConfCombo = new Combo(this.buildConfComp, 2060);
        gd = new GridData(768);
        this.buildConfCombo.setLayoutData((Object)gd);
        this.buildConfCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PerfRecompMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void initConfCombo() {
        this.buildConfCombo.removeAll();
        ICProject project = this.getCProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getString((String)"CMainTab.Project_required"), (String)LaunchMessages.getString((String)"CMainTab.Enter_project_before_searching_for_program"));
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project.getResource());
        if (info == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getString((String)"CMainTab.Project_required"), (String)LaunchMessages.getString((String)"CMainTab.Enter_project_before_searching_for_program"));
            return;
        }
        IConfiguration[] confs = info.getManagedProject().getConfigurations();
        int i = 0;
        while (i < confs.length) {
            this.buildConfCombo.add(confs[i].getName());
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(ILaunchConfiguration config) {
        Path exePath;
        IProject project;
        block22: {
            this.setErrorMessage(null);
            this.setMessage(null);
            String name = this.fProjText.getText().trim();
            if (name.length() == 0) {
                this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Project_not_specified"));
                return false;
            }
            if (!ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
                this.setErrorMessage(LaunchMessages.getString((String)"Launch.common.Project_does_not_exist"));
                return false;
            }
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!project.isOpen()) {
                this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Project_must_be_opened"));
                return false;
            }
            boolean reVal = false;
            if (config.getAttribute("true_if_recompiling_for_analysis", false)) {
                name = this.buildConfCombo.getText();
                if (name == null || name.length() == 0) {
                    this.setErrorMessage("Build configuration not specified");
                    return false;
                }
                String bcdne = "Build configuration does not exist";
                if (name.equals(".") || name.equals("..")) {
                    this.setErrorMessage(bcdne);
                    return false;
                }
                ICProject thisProject = this.getCProject();
                if (thisProject == null) {
                    this.setErrorMessage(LaunchMessages.getString((String)"Launch.common.Project_does_not_exist"));
                    return false;
                }
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)thisProject.getResource());
                if (info == null) {
                    this.setErrorMessage("Project has no valid build information");
                    return false;
                }
                IConfiguration[] configs = info.getManagedProject().getConfigurations();
                if (configs.length < 1) {
                    this.setErrorMessage("No valid configurations");
                    return false;
                }
                int i = 0;
                while (i < configs.length) {
                    if (configs[i].getName().equals(this.buildConfCombo.getText())) {
                        reVal = true;
                    }
                    ++i;
                }
                if (!reVal) {
                    this.setErrorMessage(bcdne);
                    return false;
                }
            }
            if (!config.getAttribute("true_if_using_performance_analysis_execution_utility", false) || config.getAttribute("true_if_recompiling_for_analysis", false)) return true;
            name = this.fProgText.getText().trim();
            if (name.length() == 0) {
                this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_not_specified"));
                return false;
            }
            if (name.equals(".") || name.equals("..")) {
                this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_does_not_exist"));
                return false;
            }
            exePath = new Path(name);
            if (!exePath.isAbsolute()) {
                if (!project.getFile(name).exists()) {
                    this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_does_not_exist"));
                    return false;
                }
                exePath = project.getFile(name).getLocation();
                break block22;
            }
            if (exePath.toFile().exists()) break block22;
            this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_does_not_exist"));
            return false;
        }
        try {
            if (this.isBinary(project, (IPath)exePath)) return true;
            this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_is_not_a_recongnized_executable"));
            return false;
        }
        catch (CoreException e) {
            try {
                LaunchUIPlugin.log((Throwable)e);
                this.setErrorMessage(e.getLocalizedMessage());
                return false;
            }
            catch (CoreException e2) {
                e2.printStackTrace();
            }
        }
        return true;
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String curProj = this.fProjText.getText();
        String projectName = "";
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        this.fProjText.setText(projectName);
        if (!curProj.equals(projectName)) {
            this.initConfCombo();
        }
    }

    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        block11: {
            String programName = "";
            try {
                boolean useExecUtil = config.getAttribute("true_if_using_performance_analysis_execution_utility", false);
                boolean perfRecompile = config.getAttribute("true_if_recompiling_for_analysis", false);
                if (perfRecompile || !perfRecompile && !useExecUtil) {
                    this.buildConfComp.setEnabled(true);
                    this.buildConfCombo.setEnabled(true);
                    try {
                        programName = config.getAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", "");
                    }
                    catch (CoreException ce) {
                        LaunchUIPlugin.log((Throwable)ce);
                    }
                    if (!programName.equals("")) {
                        this.buildConfCombo.select(this.buildConfCombo.indexOf(programName));
                    } else {
                        this.buildConfCombo.select(0);
                    }
                } else {
                    this.buildConfComp.setEnabled(false);
                    this.buildConfCombo.setEnabled(false);
                }
                if (useExecUtil && !perfRecompile) {
                    this.exeComp.setEnabled(true);
                    this.fProgText.setEnabled(true);
                    try {
                        programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                    }
                    catch (CoreException ce) {
                        LaunchUIPlugin.log((Throwable)ce);
                    }
                    this.fProgText.setText(programName);
                    break block11;
                }
                this.exeComp.setEnabled(false);
                this.fProgText.setEnabled(false);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fProgText.getText());
        config.setAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", this.buildConfCombo.getText());
        if (this.fTerminalButton != null) {
            config.setAttribute("org.eclipse.cdt.launch.use_terminal", this.fTerminalButton.getSelection());
        }
    }
}

