/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.local;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.AbstractTargetControl;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.TargetConfig;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalConfigFactory;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalConfigurationBean;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalLaunchAutomaticAttributeGenerator;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalSimulatorConfiguration;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.Messages;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.ui.progress.ICancelCallback;
import org.eclipse.ptp.cell.ui.progress.ProgressQueue;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetVariables;

public class LocalTargetControl
extends AbstractTargetControl
implements ITargetVariables {
    LocalConfigFactory factory;
    private LocalConfigurationBean configurationBean;

    public LocalTargetControl(ITargetElement element) throws CoreException {
        super(element);
        this.configurationBean = new LocalConfigurationBean(this.targetElement.getAttributes(), this.targetElement.getId());
        this.factory = new LocalConfigFactory(this.configurationBean, element.getId());
        this.setCurrentTargetConfig(this.factory.createTargetConfig());
        this.updateConsoles();
    }

    public boolean create(IProgressMonitor monitor) throws CoreException {
        this.setCurrentTargetConfig(this.factory.createTargetConfig());
        LocalSimulatorConfiguration currentSimulatorParameters = this.factory.createLocalSimulatorParameters();
        this.updateConsoles();
        this.resetConsoles();
        ProgressQueue progressQueue = new ProgressQueue(monitor);
        progressQueue.setCancelMessage(Messages.LocalTargetControl_LocalCellSimulatorLaunchCancelation);
        progressQueue.setInterruptMessage(Messages.LocalTargetControl_LocalCellSimulatorLaunchInterruption);
        progressQueue.setTaskName(Messages.LocalTargetControl_LaunchLocalCellSimulator);
        progressQueue.addWait(-1, Messages.LocalTargetControl_Preparing, 0);
        this.populateProgressQueueWithSimulatorLaunch(progressQueue);
        this.populateProgressQueueWithConnection(progressQueue);
        progressQueue.addWait(-2, Messages.LocalTargetControl_LaunchCompleted, 0);
        progressQueue.setCancelCallBack((ICancelCallback)new LaunchCancelCallback(this));
        progressQueue.start();
        String targetID = this.factory.getTargetID();
        LocalLaunchAutomaticAttributeGenerator generator = LocalLaunchAutomaticAttributeGenerator.getAutomaticAttributeGenerator();
        if (this.currentTargetConfig.getDoAutomaticNetworkConfiguration()) {
            String ipSimulator = generator.getSimulatorAddress(targetID);
            String ipHost = generator.getHostAddress(targetID);
            String macSimulator = generator.getMacAddress(targetID);
            this.factory.completeSimulatorParametersWithNetworkConfig(currentSimulatorParameters, ipSimulator, macSimulator, ipHost);
        }
        if (this.currentTargetConfig.getDoAutomaticPortConfiguration()) {
            int javaApiPort = generator.getJavaAPIPort(targetID);
            int consolePort = generator.getConsolePort(targetID);
            this.factory.completeSimulatorParametersWithConsoleConfig(currentSimulatorParameters, consolePort);
            this.factory.completeSimulatorParametersWithJavaApiConfig(currentSimulatorParameters, javaApiPort);
        } else {
            this.factory.completeSimulatorParametersWithConsoleConfig(currentSimulatorParameters);
            this.factory.completeSimulatorParametersWithJavaApiConfig(currentSimulatorParameters);
        }
        if (progressQueue.isCancelled()) {
            throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.LocalTargetControl_LocalCellSimulatorLaunchCancelled, null));
        }
        try {
            this.launchSimulator(progressQueue, (ISimulatorParameters)currentSimulatorParameters);
            TargetConfig currentTargetConfig = this.getCurrentTargetConfig();
            SSHTargetControl.SSHParameters parameters = new SSHTargetControl.SSHParameters((SSHTargetControl)this, currentSimulatorParameters.getIpSimulator(), currentTargetConfig.getLoginPort(), currentTargetConfig.getLoginUserName(), currentTargetConfig.getLoginPassword(), currentTargetConfig.getSimulatorCipherType(), currentTargetConfig.getLoginTimeout() * 1000);
            this.setConnectionParameters(parameters);
            this.connectSimulator(monitor, progressQueue);
            this.launchResumePauseStrategy(progressQueue);
            progressQueue.finish();
            return true;
        }
        catch (Exception e) {
            progressQueue.interrupt();
            this.releaseResumePauseStrategy();
            this.disconnect();
            this.releaseSimulator();
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, NLS.bind((String)Messages.LocalTargetControl_UnexpectedErrorLaunchingSimulator, (Object)e), (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    public boolean kill(IProgressMonitor monitor) throws CoreException {
        if (this.query() == 1) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.cellsimulator", 1, Messages.LocalTargetControl_SimulatorNotLaunched, null));
        }
        this.releaseResumePauseStrategy();
        if (!this.simulatorControl.getStatus().isOperational()) {
            this.disconnect();
            this.simulatorControl.kill();
            return true;
        }
        ProgressQueue progressQueue = new ProgressQueue(monitor);
        progressQueue.setCancelMessage(Messages.LocalTargetControl_LocalCellSimulatorShutdownCancelation);
        progressQueue.setInterruptMessage(Messages.LocalTargetControl_LocalCellSimulatorForceShutdown);
        progressQueue.setTaskName(Messages.LocalTargetControl_LocalCellSimulatorShutdown);
        progressQueue.addWait(-1, Messages.LocalTargetControl_ShuttingDown, 0);
        this.populateProgressQueueWithSimulatorShutdown(progressQueue);
        progressQueue.addWait(-2, Messages.LocalTargetControl_ShutDownCompleted, 1);
        progressQueue.addWait(-3, Messages.LocalTargetControl_CleaningUp, 1);
        progressQueue.setCancelCallBack((ICancelCallback)new ShutdownCancelCallback(this));
        progressQueue.start();
        try {
            try {
                try {
                    this.simulatorControl.resume();
                    this.terminateJobs(monitor);
                }
                finally {
                    this.disconnect();
                }
                this.kindlyReleaseSimulator(progressQueue);
                progressQueue.finish();
            }
            catch (Exception exception) {
                progressQueue.interrupt();
                this.releaseResumePauseStrategy();
                this.disconnect();
                this.releaseSimulator();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public synchronized int query() {
        if (this.simulatorControl.getStatus().isLaunching()) {
            return 0;
        }
        if (this.simulatorControl.getStatus().isShuttingDown()) {
            return 0;
        }
        if (this.simulatorControl.getStatus().isNotRunning()) {
            return 1;
        }
        if (this.simulatorControl.getStatus().isOperational()) {
            if (!this.isConnected()) {
                return 0;
            }
            if (this.simulatorControl.getStatus().isPaused()) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public void updateConfiguration() throws CoreException {
        this.configurationBean = new LocalConfigurationBean(this.targetElement.getAttributes(), this.targetElement.getId());
        this.factory = new LocalConfigFactory(this.configurationBean, this.targetElement.getId());
        this.setCurrentTargetConfig(this.factory.createTargetConfig());
        this.updateConsoles();
    }

    public ITargetControl.TargetSocket createTargetSocket(int port) {
        ITargetControl.TargetSocket targetSocket = new ITargetControl.TargetSocket();
        targetSocket.host = this.simulatorControl.getParameters().getIpSimulator();
        targetSocket.port = port;
        return targetSocket;
    }

    public String getSystemWorkspace() {
        IPreferenceStore store = CellSimulatorTargetPlugin.getDefault().getPreferenceStore();
        return store.getString("local-system-workspace-dir");
    }

    public void destroy() throws CoreException {
        if (this.query() == 1) {
            return;
        }
        if (!this.simulatorControl.getStatus().isOperational()) {
            this.disconnect();
            this.simulatorControl.kill();
            return;
        }
        try {
            try {
                this.simulatorControl.resume();
                this.terminateJobs(null);
            }
            finally {
                this.disconnect();
            }
            this.simulatorControl.shutdown();
        }
        catch (Exception exception) {
            this.releaseResumePauseStrategy();
            this.disconnect();
            this.releaseSimulator();
        }
    }

    protected class LaunchCancelCallback
    implements ICancelCallback {
        LocalTargetControl control;

        public LaunchCancelCallback(LocalTargetControl control) {
            this.control = control;
        }

        public void cancel(boolean byUser) {
            LocalTargetControl.this.releaseSimulator();
        }
    }

    protected class ShutdownCancelCallback
    implements ICancelCallback {
        LocalTargetControl control;

        public ShutdownCancelCallback(LocalTargetControl control) {
            this.control = control;
        }

        public void cancel(boolean byUser) {
            LocalTargetControl.this.releaseSimulator();
        }
    }
}

