/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.wizard;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ptp.cell.pdt.xml.Activator;
import org.eclipse.ptp.cell.pdt.xml.core.AbstractPdtXmlGenerator;
import org.eclipse.ptp.cell.pdt.xml.core.ConfigGroupParserException;
import org.eclipse.ptp.cell.pdt.xml.core.ConfigurationFileGenerationException;
import org.eclipse.ptp.cell.pdt.xml.core.PdtEventForestFactory;
import org.eclipse.ptp.cell.pdt.xml.core.PdtXmlBean;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroupForest;
import org.eclipse.ptp.cell.pdt.xml.debug.Debug;
import org.eclipse.ptp.cell.pdt.xml.wizard.Messages;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.PdtWizardAddRemoveEventsPage;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.PdtWizardConfigurationFilePage;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.PdtWizardGroupsPositionAndColorPage;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.PdtWizardSelectEventsPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractPdtXmlWizard
extends Wizard
implements INewWizard {
    protected IDialogSettings dialogSettings;
    protected EventGroupForest selectedEventGroupForest;
    protected EventGroupForest availableEventGroupForest;

    public boolean performFinish() {
        boolean complete;
        PdtWizardConfigurationFilePage confFilePage = (PdtWizardConfigurationFilePage)this.getPage(PdtWizardConfigurationFilePage.class.getName());
        PdtWizardSelectEventsPage selEventsPage = (PdtWizardSelectEventsPage)this.getPage(PdtWizardSelectEventsPage.class.getName());
        PdtWizardGroupsPositionAndColorPage setPosAndColorPage = (PdtWizardGroupsPositionAndColorPage)this.getPage(PdtWizardGroupsPositionAndColorPage.class.getName());
        boolean bl = complete = confFilePage.isPageComplete() && selEventsPage.isPageComplete() && setPosAndColorPage.isPageComplete();
        if (complete) {
            this.generateXmlConfigurationFile(confFilePage.getFilePath(), this.selectedEventGroupForest);
        }
        return complete;
    }

    private void generateXmlConfigurationFile(IPath newFilePath, EventGroupForest eventGroupForest) {
        IPath workspacePath = Platform.getLocation();
        IPath absPath = workspacePath.append(newFilePath);
        String fileExtension = absPath.getFileExtension();
        if (fileExtension == null || !fileExtension.toLowerCase().matches("xml")) {
            absPath = absPath.addFileExtension("xml");
        }
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_XML_WIZARD);
        try {
            AbstractPdtXmlGenerator xmlGen = this.createArchSpecificGenerator(absPath, eventGroupForest);
            xmlGen.generatePdtXmlFile();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFileForLocation(absPath);
            file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ConfigurationFileGenerationException e) {
            Debug.POLICY.error(Debug.DEBUG_XML_WIZARD, (Throwable)e);
            Debug.POLICY.logError((Throwable)e, Messages.AbstractPdtXmlWizard_GenerateXmlConfigFile_Dialog_Message_CouldNotCreateFile, new Object[0]);
        }
        catch (CoreException e1) {
            Debug.POLICY.error(Debug.DEBUG_XML_WIZARD, (Throwable)e1);
            Debug.POLICY.logError((Throwable)e1, Messages.AbstractPdtXmlWizard_GenerateXmlConfigFile_Dialog_Message_ProblemRefreshingWorkspace, new Object[0]);
        }
    }

    protected abstract AbstractPdtXmlGenerator createArchSpecificGenerator(IPath var1, EventGroupForest var2);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_XML_WIZARD);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        Path eventGroupDirPath = new Path(store.getString(PdtXmlBean.ATTR_EVENT_GROUP_DIR));
        PdtEventForestFactory factory = new PdtEventForestFactory((IPath)eventGroupDirPath);
        this.selectedEventGroupForest = factory.createEmptyEventGroupForest();
        try {
            this.availableEventGroupForest = factory.createEventGroupForest();
        }
        catch (ConfigGroupParserException e) {
            Debug.POLICY.error(Debug.DEBUG_XML_WIZARD, (Throwable)e);
            Debug.POLICY.logError((Throwable)e, Messages.AbstractPdtXmlWizard_Init_Dialog_Message_CouldNotParserGroupDefinitionFile, new Object[0]);
        }
        LinkedList<EventGroup> invisibleList = new LinkedList<EventGroup>(this.availableEventGroupForest.getInvisibleGroups());
        this.selectedEventGroupForest.getInvisibleGroups().addAll(invisibleList);
        this.availableEventGroupForest.getInvisibleGroups().removeAll(invisibleList);
    }

    public abstract boolean isCellArchitecture();

    public abstract void refresh();

    public void addPages() {
        PdtWizardConfigurationFilePage pdtFileConfiguration = new PdtWizardConfigurationFilePage();
        this.addPage((IWizardPage)pdtFileConfiguration);
        PdtWizardAddRemoveEventsPage addRemoveEvents = new PdtWizardAddRemoveEventsPage(this.availableEventGroupForest, this.selectedEventGroupForest);
        this.addPage((IWizardPage)addRemoveEvents);
        PdtWizardSelectEventsPage selectEvents = new PdtWizardSelectEventsPage(this.isCellArchitecture(), this.selectedEventGroupForest);
        this.addPage((IWizardPage)selectEvents);
        PdtWizardGroupsPositionAndColorPage setPosAndColor = new PdtWizardGroupsPositionAndColorPage(this.selectedEventGroupForest);
        this.addPage((IWizardPage)setPosAndColor);
    }
}

