/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.remotesimulator.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.environment.remotesimulator.Activator;
import org.eclipse.ptp.cell.environment.remotesimulator.core.DefaultValues;
import org.eclipse.ptp.cell.environment.remotesimulator.core.Parameters;
import org.eclipse.ptp.cell.environment.remotesimulator.core.TargetConfig;
import org.eclipse.ptp.cell.environment.remotesimulator.core.TargetControl;
import org.eclipse.ptp.remotetools.utils.verification.AttributeVerification;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;

public class ConfigFactory {
    public static final String ATTR_REMOTE_LOGIN_USERNAME = "remote-login-username";
    public static final String ATTR_REMOTE_LOGIN_PASSWORD = "remote-login-password";
    public static final String ATTR_REMOTE_CONNECTION_ADDRESS = "remote-connection-address";
    public static final String ATTR_REMOTE_CONNECTION_PORT = "remote-connection-port";
    public static final String ATTR_REMOTE_KEY_PATH = "remote-key-path";
    public static final String ATTR_REMOTE_KEY_PASSPHRASE = "remote-key-passphrase";
    public static final String ATTR_REMOTE_IS_PASSWORD_AUTH = "remote-is-password-auth";
    public static final String ATTR_REMOTE_CONNECTION_TIMEOUT = "remote-timeout";
    public static final String ATTR_REMOTE_CIPHER_TYPE = "remote-cipher-type";
    public static final String ATTR_SIMULATOR_IS_AUTOMATIC_CONFIG = "simulator-is-automatic-config";
    public static final String ATTR_SIMULATOR_IS_PASSWORD_AUTH = "remote-is-password-auth";
    public static final String ATTR_SIMULATOR_LOGIN_USERNAME = "simulator-login-username";
    public static final String ATTR_SIMULATOR_LOGIN_PASSWORD = "simulator-login-password";
    public static final String ATTR_SIMULATOR_KEY_PATH = "simulator-key-path";
    public static final String ATTR_SIMULATOR_KEY_PASSPHRASE = "simulator-key-passphrase";
    public static final String ATTR_SIMULATOR_CONNECTION_ADDRESS = "simulator-connection-address";
    public static final String ATTR_SIMULATOR_CONNECTION_PORT = "simulator-connection-port";
    public static final String ATTR_SIMULATOR_CONNECTION_TIMEOUT = "simulator-connection-timeout";
    public static final String ATTR_SIMULATOR_CIPHER_TYPE = "simulator-cipher-type";
    public static final String ATTR_SYSTEM_WORKSPACE = "system-workspace-dir";
    public static final String NAME_REMOTE_LOGIN_USERNAME = "Username for remote host";
    public static final String NAME_REMOTE_LOGIN_PASSWORD = "Password for remote host";
    public static final String NAME_REMOTE_CONNECTION_ADDRESS = "Remote host address";
    public static final String NAME_REMOTE_CONNECTION_PORT = "Remote host port";
    public static final String NAME_REMOTE_CONNECTION_TIMEOUT = "Remote host connection timeout";
    public static final String NAME_REMOTE_CIPHER_TYPE = "Remote host connection cipher type";
    public static final String NAME_SIMULATOR_LOGIN_USERNAME = "Simulator login username";
    public static final String NAME_SIMULATOR_LOGIN_PASSWORD = "Simulator login password";
    public static final String NAME_SIMULATOR_CONNECTION_ADDRESS = "Simulator address on remote host";
    public static final String NAME_SIMULATOR_CONNECTION_PORT = "Simulator port on remote host";
    public static final String NAME_SIMULATOR_CONNECTION_TIMEOUT = "Simulator connection timeout";
    public static final String NAME_SIMULATOR_CIPHER_TYPE = "Simulator connection cipher type";
    public static final String NAME_SYSTEM_WORKSPACE = "Launch base directory";
    public static final String SHORT_NAME_REMOTE_LOGIN_USERNAME = "Username";
    public static final String SHORT_NAME_REMOTE_LOGIN_PASSWORD = "Password";
    public static final String SHORT_NAME_REMOTE_CONNECTION_ADDRESS = "Host address";
    public static final String SHORT_NAME_REMOTE_CONNECTION_PORT = "Port";
    public static final String SHORT_NAME_SIMULATOR_LOGIN_USERNAME = "Username";
    public static final String SHORT_NAME_SIMULATOR_LOGIN_PASSWORD = "Password";
    public static final String SHORT_NAME_SIMULATOR_CONNECTION_ADDRESS = "Simulator address";
    public static final String SHORT_NAME_SIMULATOR_CONNECTION_PORT = "Port";
    public static final String SHORT_NAME_SIMULATOR_CONNECTION_TIMEOUT = "Timeout (seconds)";
    public static final String SHORT_NAME_SYSTEM_WORKSPACE = "Launch base directory";
    public static final String DEFAULT_REMOTE_LOGIN_USERNAME = DefaultValues.DEFAULT_REMOTE_LOGIN_USERNAME;
    public static final String DEFAULT_REMOTE_LOGIN_PASSWORD = DefaultValues.DEFAULT_REMOTE_LOGIN_PASSWORD;
    public static final String DEFAULT_REMOTE_CONNECTION_ADDRESS = DefaultValues.DEFAULT_REMOTE_CONNECTION_ADDRESS;
    public static final int DEFAULT_REMOTE_CONNECTION_PORT = Integer.parseInt(DefaultValues.DEFAULT_REMOTE_CONNECTION_PORT);
    public static final String DEFAULT_REMOTE_KEY_PATH = DefaultValues.DEFAULT_REMOTE_KEY_PATH;
    public static final String DEFAULT_REMOTE_KEY_PASSPHRASE = DefaultValues.DEFAULT_REMOTE_KEY_PASSPHRASE;
    public static final boolean DEFAULT_REMOTE_IS_PASSWORD_AUTH = Boolean.valueOf(DefaultValues.DEFAULT_REMOTE_IS_PASSWORD_AUTH);
    public static final int DEFAULT_REMOTE_CONNECTION_TIMEOUT = Integer.parseInt(DefaultValues.DEFAULT_REMOTE_TIMEOUT);
    public static final String DEFAULT_REMOTE_CIPHER_TYPE = TargetControl.DEFAULT_HOST_CIPHER;
    public static final boolean DEFAULT_SIMULATOR_IS_AUTOMATIC_CONFIG = Boolean.valueOf(DefaultValues.DEFAULT_SIMULATOR_IS_AUTOMATIC_CONFIG);
    public static final boolean DEFAULT_SIMULATOR_IS_PASSWORD_AUTH = Boolean.valueOf(DefaultValues.DEFAULT_SIMULATOR_IS_PASSWORD_AUTH);
    public static final String DEFAULT_SIMULATOR_LOGIN_USERNAME = DefaultValues.DEFAULT_SIMULATOR_LOGIN_USERNAME;
    public static final String DEFAULT_SIMULATOR_LOGIN_PASSWORD = DefaultValues.DEFAULT_SIMULATOR_LOGIN_PASSWORD;
    public static final String DEFAULT_SIMULATOR_KEY_PATH = DefaultValues.DEFAULT_SIMULATOR_KEY_PATH;
    public static final String DEFAULT_SIMULATOR_KEY_PASSPHRASE = DefaultValues.DEFAULT_SIMULATOR_KEY_PASSPHRASE;
    public static final String DEFAULT_SIMULATOR_CONNECTION_ADDRESS = DefaultValues.DEFAULT_SIMULATOR_CONNECTION_ADDRESS;
    public static final int DEFAULT_SIMULATOR_CONNECTION_PORT = Integer.parseInt(DefaultValues.DEFAULT_SIMULATOR_CONNECTION_PORT);
    public static final int DEFAULT_SIMULATOR_CONNECTION_TIMEOUT = Integer.parseInt(DefaultValues.DEFAULT_SIMULATOR_CONNECTION_TIMEOUT);
    public static final String DEFAULT_SIMULATOR_CIPHER_TYPE = TargetControl.DEFAULT_SIMULATOR_CIPHER;
    public static final String DEFAULT_SYSTEM_WORKSPACE = DefaultValues.DEFAULT_SYSTEM_WORKSPACE;
    public static final String[] KEY_ARRAY = new String[]{"remote-login-username", "remote-connection-port", "remote-connection-address", "remote-key-path", "remote-is-password-auth", "remote-timeout", "remote-cipher-type", "simulator-is-automatic-config", "simulator-login-username", "simulator-connection-port", "simulator-connection-address", "simulator-connection-timeout", "simulator-cipher-type", "simulator-key-path", "system-workspace-dir"};
    public static final String[] KEY_CIPHERED_ARRAY = new String[]{"remote-login-password", "remote-key-passphrase", "simulator-login-password", "simulator-key-passphrase"};
    private ControlAttributes attributes;

    public ConfigFactory(ControlAttributes attributes) {
        this.attributes = attributes;
    }

    public IStatus fillTargetConfig(TargetConfig config) {
        ArrayList<Status> errors = new ArrayList<Status>();
        AttributeVerification verification = new AttributeVerification("org.eclipse.ptp.remotetools.environment.remotesimulator");
        config.setRemoteConnectionAddress(this.attributes.getStringAttribute(ATTR_REMOTE_CONNECTION_ADDRESS, DEFAULT_REMOTE_CONNECTION_ADDRESS));
        try {
            config.setRemoteConnectionPort(this.attributes.verifyIntAttribute(NAME_REMOTE_CONNECTION_PORT, ATTR_REMOTE_CONNECTION_PORT, DEFAULT_REMOTE_CONNECTION_PORT));
            config.setRemoteConnectionTimeout(this.attributes.verifyIntAttribute(NAME_REMOTE_CONNECTION_TIMEOUT, ATTR_REMOTE_CONNECTION_TIMEOUT, DEFAULT_REMOTE_CONNECTION_TIMEOUT));
        }
        catch (IllegalAttributeException e) {
            errors.add(new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
        config.setRemoteIsPasswordAuth(this.attributes.getBooleanAttribute("remote-is-password-auth", DEFAULT_REMOTE_IS_PASSWORD_AUTH));
        config.setRemoteLoginUserName(this.attributes.getStringAttribute(ATTR_REMOTE_LOGIN_USERNAME, DEFAULT_REMOTE_LOGIN_USERNAME));
        config.setRemoteLoginPassword(this.attributes.getStringAttribute(ATTR_REMOTE_LOGIN_PASSWORD, DEFAULT_REMOTE_LOGIN_PASSWORD));
        config.setRemoteKeyPath(this.attributes.getStringAttribute(ATTR_REMOTE_KEY_PATH, DEFAULT_REMOTE_KEY_PATH));
        config.setRemoteKeyPassphrase(this.attributes.getStringAttribute(ATTR_REMOTE_KEY_PASSPHRASE, DEFAULT_REMOTE_KEY_PASSPHRASE));
        config.setRemoteCipherType(this.attributes.getString(ATTR_REMOTE_CIPHER_TYPE, DEFAULT_REMOTE_CIPHER_TYPE));
        boolean isAutomatic = this.attributes.getBooleanAttribute(ATTR_SIMULATOR_IS_AUTOMATIC_CONFIG, DEFAULT_SIMULATOR_IS_AUTOMATIC_CONFIG);
        if (isAutomatic) {
            config.setSimulatorLoginUserName(Parameters.AUTOMATIC_USERNAME);
            config.setSimulatorLoginPassword(Parameters.AUTOMATIC_PASSWORD);
            config.setSimulatorConnectionAddress(Parameters.AUTOMATIC_IP_SIMULATOR);
            config.setSimulatorIsPasswordAuth(true);
            config.setSimulatorConnectionPort(Parameters.getNUMERIC_PORT_SIMULATOR());
            config.setSimulatorConnectionTimeout(Parameters.getNUMERIC_TIMEOUT());
            config.setSimulatorCipherType(DEFAULT_SIMULATOR_CIPHER_TYPE);
        } else {
            config.setSimulatorIsPasswordAuth(this.attributes.getBooleanAttribute("remote-is-password-auth", DEFAULT_SIMULATOR_IS_PASSWORD_AUTH));
            config.setSimulatorLoginUserName(this.attributes.getStringAttribute(ATTR_SIMULATOR_LOGIN_USERNAME, DEFAULT_SIMULATOR_LOGIN_USERNAME));
            config.setSimulatorLoginPassword(this.attributes.getStringAttribute(ATTR_SIMULATOR_LOGIN_PASSWORD, DEFAULT_SIMULATOR_LOGIN_PASSWORD));
            config.setSimulatorKeyPath(this.attributes.getStringAttribute(ATTR_SIMULATOR_KEY_PATH, DEFAULT_SIMULATOR_KEY_PATH));
            config.setSimulatorPassphrase(this.attributes.getStringAttribute(ATTR_SIMULATOR_KEY_PASSPHRASE, DEFAULT_SIMULATOR_KEY_PASSPHRASE));
            config.setSimulatorConnectionAddress(this.attributes.getStringAttribute(ATTR_SIMULATOR_CONNECTION_ADDRESS, DEFAULT_SIMULATOR_CONNECTION_ADDRESS));
            config.setSimulatorCipherType(this.attributes.getString(ATTR_SIMULATOR_CIPHER_TYPE, DEFAULT_SIMULATOR_CIPHER_TYPE));
            try {
                config.setSimulatorConnectionPort(this.attributes.verifyIntAttribute(NAME_SIMULATOR_CONNECTION_PORT, ATTR_SIMULATOR_CONNECTION_PORT, DEFAULT_SIMULATOR_CONNECTION_PORT));
                config.setSimulatorConnectionTimeout(this.attributes.verifyIntAttribute(NAME_SIMULATOR_CONNECTION_TIMEOUT, ATTR_SIMULATOR_CONNECTION_TIMEOUT, DEFAULT_SIMULATOR_CONNECTION_TIMEOUT));
            }
            catch (IllegalAttributeException e) {
                errors.add(new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
        }
        config.setSystemWorkspace(this.attributes.getStringAttribute(ATTR_SYSTEM_WORKSPACE, DEFAULT_SYSTEM_WORKSPACE));
        return verification.createResultStatus(errors);
    }

    public void createTargetConfig(TargetConfig config) throws CoreException {
        IStatus status = this.fillTargetConfig(config);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public TargetConfig createTargetConfig() throws CoreException {
        TargetConfig config = new TargetConfig();
        IStatus status = this.fillTargetConfig(config);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        return config;
    }

    public IStatus checkTargetConfig() {
        TargetConfig config = new TargetConfig();
        return this.fillTargetConfig(config);
    }

    public static Map createDefaultConfig() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Activator.getDefault().getPreferenceStore();
        attributes.put("remote-is-password-auth", Boolean.toString(DEFAULT_REMOTE_IS_PASSWORD_AUTH));
        attributes.put(ATTR_REMOTE_LOGIN_USERNAME, DEFAULT_REMOTE_LOGIN_USERNAME);
        attributes.put(ATTR_REMOTE_LOGIN_PASSWORD, DEFAULT_REMOTE_LOGIN_PASSWORD);
        attributes.put(ATTR_REMOTE_KEY_PATH, DEFAULT_REMOTE_KEY_PATH);
        attributes.put(ATTR_REMOTE_KEY_PASSPHRASE, DEFAULT_REMOTE_KEY_PASSPHRASE);
        attributes.put(ATTR_REMOTE_CONNECTION_ADDRESS, DEFAULT_REMOTE_CONNECTION_ADDRESS);
        attributes.put(ATTR_REMOTE_CONNECTION_PORT, Integer.toString(DEFAULT_REMOTE_CONNECTION_PORT));
        attributes.put(ATTR_REMOTE_CIPHER_TYPE, DEFAULT_REMOTE_CIPHER_TYPE);
        attributes.put(ATTR_SIMULATOR_IS_AUTOMATIC_CONFIG, Boolean.toString(DEFAULT_SIMULATOR_IS_AUTOMATIC_CONFIG));
        attributes.put(ATTR_SIMULATOR_LOGIN_USERNAME, DEFAULT_SIMULATOR_LOGIN_USERNAME);
        attributes.put(ATTR_SIMULATOR_LOGIN_PASSWORD, DEFAULT_SIMULATOR_LOGIN_PASSWORD);
        attributes.put(ATTR_SIMULATOR_CONNECTION_ADDRESS, DEFAULT_SIMULATOR_CONNECTION_ADDRESS);
        attributes.put(ATTR_SIMULATOR_CONNECTION_PORT, Integer.toString(DEFAULT_SIMULATOR_CONNECTION_PORT));
        attributes.put(ATTR_SIMULATOR_CONNECTION_TIMEOUT, Integer.toString(DEFAULT_SIMULATOR_CONNECTION_TIMEOUT));
        attributes.put(ATTR_SIMULATOR_CIPHER_TYPE, DEFAULT_SIMULATOR_CIPHER_TYPE);
        attributes.put(ATTR_SYSTEM_WORKSPACE, DEFAULT_SYSTEM_WORKSPACE);
        return attributes;
    }
}

