/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.indexer.ILanguageMapper;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;

public class RemoteLanguageMapper
implements ILanguageMapper {
    private static final Map<String, ILanguage> RDT_SUPPORTED_LANGUAGES = new HashMap<String, ILanguage>();
    private final IRemoteIndexerInfoProvider provider;

    static {
        RDT_SUPPORTED_LANGUAGES.put("org.eclipse.cdt.core.g++", (ILanguage)GPPLanguage.getDefault());
        RDT_SUPPORTED_LANGUAGES.put("org.eclipse.cdt.core.gcc", (ILanguage)GCCLanguage.getDefault());
    }

    public RemoteLanguageMapper(IRemoteIndexerInfoProvider provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.provider = provider;
    }

    public ILanguage getLanguage(String file) {
        String id = this.provider.getLanguageID(file);
        return RDT_SUPPORTED_LANGUAGES.get(id);
    }
}

