/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.serviceproviders;

import org.eclipse.ptp.internal.rdt.core.callhierarchy.ICallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.RemoteCallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.navigation.INavigationService;
import org.eclipse.ptp.internal.rdt.core.navigation.RemoteNavigationService;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.ITypeHierarchyService;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.RemoteTypeHierarchyService;
import org.eclipse.ptp.rdt.core.messages.Messages;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceProviderDescriptor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;

public abstract class AbstractRemoteCIndexServiceProvider
extends ServiceProviderDescriptor
implements IIndexServiceProvider {
    protected boolean fIsConfigured;
    protected IHost fHost;
    protected String fHostName;
    protected IConnectorService fConnectorService;
    protected IIndexLifecycleService fIndexLifecycleService;
    protected INavigationService fNavigationService;
    protected ICallHierarchyService fCallHierarchyService;
    protected ITypeHierarchyService fTypeHierarchyService;
    public static final String ID = "org.eclipse.ptp.rdt.core.RemoteCIndexServiceProvider";
    public static final String NAME = Messages.RemoteCIndexServiceProvider_0;
    public static final String SERVICE_ID = "org.eclipse.ptp.rdt.core.CIndexingService";

    public AbstractRemoteCIndexServiceProvider(String id, String name, String serviceId) {
        super(id, name, serviceId);
    }

    public void setConnection(IHost host, IConnectorService connectorService) {
        this.fHost = host;
        this.fHostName = host.getAliasName();
        this.fConnectorService = connectorService;
        this.setConfigured(true);
    }

    public boolean isConfigured() {
        return this.fIsConfigured;
    }

    public void setConfigured(boolean isConfigured) {
        this.fIsConfigured = isConfigured;
    }

    public synchronized IIndexLifecycleService getIndexLifeCycleService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fIndexLifecycleService == null) {
            this.fIndexLifecycleService = new RemoteIndexLifecycleService(this.fHost, this.fConnectorService);
        }
        return this.fIndexLifecycleService;
    }

    public synchronized INavigationService getNavigationService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fNavigationService == null) {
            this.fNavigationService = new RemoteNavigationService(this.fHost, this.fConnectorService);
        }
        return this.fNavigationService;
    }

    public synchronized ICallHierarchyService getCallHierarchyService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fCallHierarchyService == null) {
            this.fCallHierarchyService = new RemoteCallHierarchyService(this.fHost, this.fConnectorService);
        }
        return this.fCallHierarchyService;
    }

    public synchronized ITypeHierarchyService getTypeHierarchyService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fTypeHierarchyService == null) {
            this.fTypeHierarchyService = new RemoteTypeHierarchyService(this.fHost, this.fConnectorService);
        }
        return this.fTypeHierarchyService;
    }

    public IHost getHost() {
        return this.fHost;
    }
}

