/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.ui.parse;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.ptp.cell.sputiming.ui.parse.InstructionLine;
import org.eclipse.ptp.cell.sputiming.ui.parse.NonInstructionLine;
import org.eclipse.ptp.cell.sputiming.ui.parse.ParsedTimingFile;
import org.eclipse.ptp.cell.sputiming.ui.parse.TimeInfo;
import org.eclipse.ptp.cell.sputiming.ui.parse.TimingFileLine;

public class TimingFileParser {
    private String timingFileName;

    public TimingFileParser(String filename) {
        this.timingFileName = filename;
    }

    public ParsedTimingFile parseTimingFile() throws IOException {
        String line;
        LineNumberReader linereader = new LineNumberReader(new FileReader(this.timingFileName));
        ParsedTimingFile parsedTiming = new ParsedTimingFile(this.timingFileName);
        int grpnum = 1;
        Vector<TimingFileLine> linevector = new Vector<TimingFileLine>(50, 50);
        while ((line = linereader.readLine()) != null) {
            if (line.charAt(0) == '0' || line.charAt(0) == '1') {
                InstructionLine il = new InstructionLine(linereader.getLineNumber(), grpnum);
                il.setPipelineNumber(Integer.parseInt(line.substring(0, 1)));
                switch (line.charAt(1)) {
                    case ' ': {
                        il.setParallelInfo(InstructionLine.NO);
                        break;
                    }
                    case 'D': {
                        il.setParallelInfo(InstructionLine.YES);
                        break;
                    }
                    case 'd': {
                        il.setParallelInfo(InstructionLine.COULDBE);
                    }
                }
                il.setPipeTimingInfo(new String(line.substring(3, 54)));
                il.setInstruction(line.substring(54));
                linevector.addElement(il);
                continue;
            }
            NonInstructionLine nil = new NonInstructionLine(linereader.getLineNumber(), grpnum, line);
            linevector.addElement(nil);
        }
        parsedTiming.setLineVector(linevector);
        HashMap<Integer, ProcessingInfo> lastStartByPipeline = new HashMap<Integer, ProcessingInfo>();
        Iterator it = parsedTiming.getLineVector().iterator();
        int maxTime = 0;
        while (it.hasNext()) {
            TimingFileLine line1 = (TimingFileLine)it.next();
            if (!(line1 instanceof InstructionLine)) continue;
            InstructionLine instructionLine = (InstructionLine)line1;
            Integer currentPipeline = new Integer(instructionLine.getPipelineNumber());
            ProcessingInfo info = (ProcessingInfo)lastStartByPipeline.get(currentPipeline);
            if (info == null) {
                info = new ProcessingInfo();
                lastStartByPipeline.put(currentPipeline, info);
            }
            this.processTimeInfo(instructionLine);
            String timeInfoString = instructionLine.getPipeTimingInfo();
            TimeInfo timeInfo = this.getInitialPosition(timeInfoString, info);
            instructionLine.setTimeInfo(timeInfo);
            int currentTime = timeInfo.getPosition() + timeInfo.getNopesCount() + timeInfo.getInstructionSize();
            if (currentTime <= maxTime) continue;
            maxTime = currentTime;
        }
        parsedTiming.setMaxTime(maxTime);
        return parsedTiming;
    }

    private void processTimeInfo(InstructionLine instructionLine) {
        String[] timeInfoSplited = instructionLine.getPipeTimingInfo().split(" ");
        String firstPart = timeInfoSplited[0];
        if (timeInfoSplited.length > 1) {
            String lastPart = timeInfoSplited[timeInfoSplited.length - 1];
            String mergedCycles = String.valueOf(lastPart) + firstPart;
            instructionLine.setPipeTimingInfo(mergedCycles.trim());
        }
    }

    private TimeInfo getInitialPosition(String timeInfoString, ProcessingInfo info) {
        int nopesCount = 0;
        int firstNumber = -1;
        int instructionSize = 0;
        boolean foundFirstNumber = false;
        int i = 0;
        while (i < timeInfoString.length()) {
            char currentChar = timeInfoString.charAt(i);
            switch (currentChar) {
                case '-': {
                    ++nopesCount;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    foundFirstNumber = true;
                    instructionSize = timeInfoString.length() - i;
                    firstNumber = Integer.parseInt(Character.toString(currentChar));
                    break;
                }
            }
            if (foundFirstNumber) break;
            ++i;
        }
        int nopeStart = firstNumber - nopesCount;
        if (nopeStart < 0) {
            nopeStart += 10;
        }
        if (nopeStart < info.lastStart) {
            info.incCurrentStep();
        }
        int realStart = nopeStart + info.getCurrentStep();
        TimeInfo timeInfo = new TimeInfo(realStart, nopesCount, instructionSize);
        info.lastStart = nopeStart;
        return timeInfo;
    }

    private class ProcessingInfo {
        int lastStart = 0;
        private int currentStep = 0;

        private ProcessingInfo() {
        }

        public int getCurrentStep() {
            return this.currentStep;
        }

        public void incCurrentStep() {
            this.currentStep += 10;
        }
    }
}

