/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsProcess;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.RemoteProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsProcessBuilder
extends AbstractRemoteProcessBuilder {
    private RemoteToolsConnection connection;
    private Map<String, String> remoteEnv = new HashMap<String, String>();

    public RemoteToolsProcessBuilder(RemoteToolsConnection conn, List<String> command) {
        super((IRemoteConnection)conn, command);
        this.connection = conn;
    }

    public RemoteToolsProcessBuilder(RemoteToolsConnection conn, String ... command) {
        this(conn, Arrays.asList(command));
    }

    public Map<String, String> environment() {
        return this.remoteEnv;
    }

    public IRemoteProcess start() throws IOException {
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.spaceEscapify((String)cmdArgs.get(i));
            ++i;
        }
        try {
            IRemoteExecutionManager exeMgr = this.connection.createExecutionManager();
            IRemoteExecutionTools exeTools = exeMgr.getExecutionTools();
            IRemoteScript script = exeTools.createScript();
            if (this.directory() != null) {
                String setWorkingDirStr = "cd " + this.directory().toURI().getPath();
                script.setScript(new String[]{setWorkingDirStr, remoteCmd});
            } else {
                script.setScript(remoteCmd);
            }
            for (Map.Entry<String, String> entry : this.environment().entrySet()) {
                script.addEnvironment(String.valueOf(entry.getKey()) + "=" + entry.getValue());
            }
            RemoteProcess process = exeTools.executeProcess(script);
            return new RemoteToolsProcess((Process)process, this.redirectErrorStream());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }
}

