/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.rdt.services.Activator;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceModelManager;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.rdt.services.core.ProjectNotConfiguredException;
import org.eclipse.ptp.rdt.services.core.ServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.ServiceProviderDescriptor;
import org.eclipse.ptp.rdt.services.internal.core.Service;
import org.eclipse.ptp.rdt.services.ui.IServiceProviderConfiguration;
import org.eclipse.ptp.rdt.services.ui.Messages;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceModelManager
implements IServiceModelManager {
    private static final String SERVICE_EXTENSION_ID = "services";
    private static final String PROVIDER_EXTENSION_ID = "providers";
    private static final String SERVICE_ELEMENT_NAME = "service";
    private static final String NATURE_ELEMENT_NAME = "nature";
    private static final String PROVIDER_ELEMENT_NAME = "provider";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SERVICE_ID = "serviceId";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_UI_CLASS = "configurationUIClass";
    private static final String SERVICE_MODEL_ELEMENT_NAME = "service-model";
    private static final String PROJECT_ELEMENT_NAME = "project";
    private static final String SERVICE_CONFIGURATION_ELEMENT_NAME = "service-configuration";
    private static final String PROVIDER_CONFIGURATION_ELEMENT_NAME = "provider-configuration";
    private static final String ATTR_PROVIDER_ID = "provider-id";
    private static final String DEFAULT_SAVE_FILE_NAME = "service-model.xml";
    private final IPath defaultSaveFile = Activator.getDefault().getStateLocation().append("service-model.xml");
    private Map<IProject, Map<String, IServiceConfiguration>> configurations;
    private Map<IProject, IServiceConfiguration> activeConfigurations;
    private Map<IProject, Set<IService>> projectServices;
    private Map<String, IService> services = null;
    private Map<String, IServiceProviderDescriptor> serviceProviders = null;
    private Set<IService> serviceSet = null;
    private Map<String, Set<IService>> natureServices = null;
    private static ServiceModelManager fInstance;

    public static synchronized ServiceModelManager getInstance() {
        if (fInstance == null) {
            fInstance = new ServiceModelManager();
        }
        return fInstance;
    }

    private ServiceModelManager() {
        this.initialize();
    }

    private void initialize() {
        this.activeConfigurations = new HashMap<IProject, IServiceConfiguration>();
        this.configurations = new HashMap<IProject, Map<String, IServiceConfiguration>>();
        this.projectServices = new HashMap<IProject, Set<IService>>();
    }

    @Override
    public void putConfiguration(IProject project, IServiceConfiguration conf) {
        if (project == null || conf == null) {
            throw new NullPointerException();
        }
        Map<String, IServiceConfiguration> confs = this.configurations.get(project);
        if (confs == null) {
            confs = new HashMap<String, IServiceConfiguration>();
            this.configurations.put(project, confs);
            this.activeConfigurations.put(project, conf);
        }
        confs.put(conf.getName(), conf);
        Set<IService> services = this.projectServices.get(project);
        if (services == null) {
            services = new HashSet<IService>();
            this.projectServices.put(project, services);
        }
        for (IServiceConfiguration config : confs.values()) {
            for (IService service : config.getServices()) {
                services.add(service);
            }
        }
    }

    private static <T> T getConf(Map<IProject, T> map, IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        T value = map.get(project);
        if (value == null) {
            throw new ProjectNotConfiguredException();
        }
        return value;
    }

    @Override
    public IServiceConfiguration getActiveConfiguration(IProject project) {
        return ServiceModelManager.getConf(this.activeConfigurations, project);
    }

    @Override
    public IServiceConfiguration getConfiguration(IProject project, String name) {
        return ServiceModelManager.getConf(this.configurations, project).get(name);
    }

    @Override
    public Set<IServiceConfiguration> getConfigurations(IProject project) {
        return new HashSet<IServiceConfiguration>(ServiceModelManager.getConf(this.configurations, project).values());
    }

    public IServiceProvider getServiceProvider(IServiceProviderDescriptor desc) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.services", PROVIDER_EXTENSION_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(PROVIDER_ELEMENT_NAME) && element.getAttribute(ATTR_ID).equals(desc.getId())) {
                        try {
                            return (IServiceProvider)element.createExecutableExtension(ATTR_CLASS);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public IServiceProviderConfiguration getServiceProviderConfigurationUI(IServiceProviderDescriptor desc) {
        IServiceProviderConfiguration config = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.services", PROVIDER_EXTENSION_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(PROVIDER_ELEMENT_NAME) && element.getAttribute(ATTR_ID).equals(desc.getId())) {
                        try {
                            config = (IServiceProviderConfiguration)element.createExecutableExtension(ATTR_UI_CLASS);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return config;
    }

    @Override
    public Set<IService> getServices() {
        this.loadServices();
        return this.serviceSet;
    }

    @Override
    public Set<IService> getServices(IProject project) {
        return ServiceModelManager.getConf(this.projectServices, project);
    }

    @Override
    public Set<IService> getServices(String natureId) {
        this.loadServices();
        return this.natureServices.get(natureId);
    }

    @Override
    public void removeConfiguration(IProject project, IServiceConfiguration conf) {
        Map<String, IServiceConfiguration> confs = ServiceModelManager.getConf(this.configurations, project);
        if (confs != null) {
            confs.remove(conf.getName());
        }
    }

    @Override
    public void remove(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.configurations.remove(project);
        this.activeConfigurations.remove(project);
        this.projectServices.remove(project);
    }

    @Override
    public void setActiveConfiguration(IProject project, IServiceConfiguration configuration) {
        Map<String, IServiceConfiguration> confs = ServiceModelManager.getConf(this.configurations, project);
        if (!confs.containsKey(configuration.getName())) {
            throw new IllegalArgumentException();
        }
        this.activeConfigurations.put(project, configuration);
    }

    private void loadServices() {
        IService service;
        String name;
        String id;
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        int n3;
        int n4;
        IExtension[] iExtensionArray;
        if (this.services != null) {
            return;
        }
        this.services = new HashMap<String, IService>();
        this.serviceProviders = new HashMap<String, IServiceProviderDescriptor>();
        this.serviceSet = new HashSet<IService>();
        this.natureServices = new HashMap<String, Set<IService>>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.services", SERVICE_EXTENSION_ID);
        if (extensionPoint != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(SERVICE_ELEMENT_NAME)) {
                        id = element.getAttribute(ATTR_ID);
                        name = element.getAttribute(ATTR_NAME);
                        IConfigurationElement[] natureConf = element.getChildren(NATURE_ELEMENT_NAME);
                        HashSet<String> natures = new HashSet<String>();
                        if (natureConf != null) {
                            IConfigurationElement[] iConfigurationElementArray2 = natureConf;
                            int n5 = natureConf.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement nature = iConfigurationElementArray2[n6];
                                String natureId = nature.getAttribute(ATTR_ID);
                                if (workspace.getNatureDescriptor(natureId) != null) {
                                    natures.add(natureId);
                                }
                                ++n6;
                            }
                        }
                        service = new Service(id, name, natures);
                        this.serviceSet.add(service);
                        this.services.put(id, service);
                        for (String nature : natures) {
                            Set<IService> svcs = this.natureServices.get(nature);
                            if (svcs == null) {
                                svcs = new HashSet<IService>();
                                this.natureServices.put(nature, svcs);
                            }
                            svcs.add(service);
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.services", PROVIDER_EXTENSION_ID)) != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(PROVIDER_ELEMENT_NAME)) {
                        id = element.getAttribute(ATTR_ID);
                        name = element.getAttribute(ATTR_NAME);
                        String serviceId = element.getAttribute(ATTR_SERVICE_ID);
                        ServiceProviderDescriptor desc = new ServiceProviderDescriptor(id, name, serviceId);
                        service = this.services.get(serviceId);
                        if (service != null) {
                            this.serviceProviders.put(id, desc);
                            service.addServiceProvider(desc);
                        } else {
                            Activator.getDefault().logErrorMessage(Messages.getFormattedString("Services_invalidServiceId", serviceId));
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        }
    }

    @Override
    public IService getService(String id) {
        this.loadServices();
        return this.services.get(id);
    }

    public void saveModelConfiguration(Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException();
        }
        ServiceModelManager.saveModelConfiguration(this.configurations, writer);
    }

    public void saveModelConfiguration() throws IOException {
        File file = this.defaultSaveFile.toFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            this.saveModelConfiguration(writer);
        }
        finally {
            writer.close();
        }
    }

    private static void saveModelConfiguration(Map<IProject, Map<String, IServiceConfiguration>> model, Writer writer) throws IOException {
        XMLMemento rootMemento = XMLMemento.createWriteRoot((String)SERVICE_MODEL_ELEMENT_NAME);
        for (Map.Entry<IProject, Map<String, IServiceConfiguration>> entry : model.entrySet()) {
            IProject project = entry.getKey();
            if (!project.exists()) continue;
            String projectName = project.getName();
            IMemento projectMemento = rootMemento.createChild(PROJECT_ELEMENT_NAME);
            projectMemento.putString(ATTR_NAME, projectName);
            Map<String, IServiceConfiguration> configurations = entry.getValue();
            for (IServiceConfiguration config : configurations.values()) {
                String configurationName = config.getName();
                IMemento configMemento = projectMemento.createChild(SERVICE_CONFIGURATION_ELEMENT_NAME);
                configMemento.putString(ATTR_NAME, configurationName);
                Set<IService> services = config.getServices();
                for (IService service : services) {
                    IServiceProvider provider = config.getServiceProvider(service);
                    if (provider != null) {
                        IMemento serviceMemento = configMemento.createChild(SERVICE_ELEMENT_NAME);
                        serviceMemento.putString(ATTR_ID, service.getId());
                        serviceMemento.putString(ATTR_PROVIDER_ID, provider.getId());
                        IMemento providerMemento = serviceMemento.createChild(PROVIDER_CONFIGURATION_ELEMENT_NAME);
                        provider.saveState(providerMemento);
                        continue;
                    }
                    Activator.getDefault().logErrorMessage(Messages.getFormattedString("Services_saveServiceError", service.getName(), projectName));
                }
            }
        }
        rootMemento.save(writer);
    }

    public void loadModelConfiguration() throws IOException, CoreException {
        File file = this.defaultSaveFile.toFile();
        if (file.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                this.loadModelConfiguration(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
    }

    public void loadModelConfiguration(Reader reader) throws IOException, CoreException {
        this.initialize();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)reader);
        IMemento[] iMementoArray = rootMemento.getChildren(PROJECT_ELEMENT_NAME);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento projectMemento = iMementoArray[n2];
            String projectName = projectMemento.getString(ATTR_NAME);
            IProject project = root.getProject(projectName);
            if (project.exists()) {
                IMemento[] iMementoArray2 = projectMemento.getChildren(SERVICE_CONFIGURATION_ELEMENT_NAME);
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento configMemento = iMementoArray2[n4];
                    String configName = configMemento.getString(ATTR_NAME);
                    ServiceConfiguration config = new ServiceConfiguration(configName);
                    IMemento[] iMementoArray3 = configMemento.getChildren(SERVICE_ELEMENT_NAME);
                    int n5 = iMementoArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IMemento serviceMemento = iMementoArray3[n6];
                        String serviceId = serviceMemento.getString(ATTR_ID);
                        String providerId = serviceMemento.getString(ATTR_PROVIDER_ID);
                        IService service = this.getService(serviceId);
                        IServiceProviderDescriptor descriptor = service.getProviderDescriptor(providerId);
                        IServiceProvider provider = this.getServiceProvider(descriptor);
                        IMemento providerMemento = serviceMemento.getChild(PROVIDER_CONFIGURATION_ELEMENT_NAME);
                        provider.restoreState(providerMemento);
                        config.setServiceProvider(service, provider);
                        ++n6;
                    }
                    this.putConfiguration(project, config);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void printServiceModel() {
        System.out.println("Service Model: ");
        if (this.configurations.isEmpty()) {
            System.out.println("  Service Model is empty");
        }
        for (Map.Entry<IProject, Map<String, IServiceConfiguration>> entry : this.configurations.entrySet()) {
            IProject project = entry.getKey();
            System.out.println("  Project: " + project.getName());
            for (IServiceConfiguration conf : entry.getValue().values()) {
                System.out.println("      " + conf);
            }
        }
    }
}

