/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.extensions;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.simulator.extensions.LaunchProfile;
import org.eclipse.ptp.cell.simulator.extensions.Messages;
import org.osgi.framework.Bundle;

public class LaunchProfileManager {
    static LaunchProfileManager instance;
    Map launchProfiles = new HashMap();

    public static LaunchProfileManager getInstance() {
        if (instance == null) {
            instance = new LaunchProfileManager();
        }
        return instance;
    }

    protected LaunchProfileManager() {
        this.loadProfileExtensions();
    }

    private void loadProfileExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.cell.simulator.profile");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IContributor contributor = extension.getContributor();
            String contributorName = contributor.getName();
            Bundle bundle = Platform.getBundle((String)contributorName);
            ILog log = Platform.getLog((Bundle)bundle);
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                block16: {
                    String id = null;
                    String name = null;
                    String tclScriptPath = null;
                    URL tclScriptURL = null;
                    String[] deployPaths = null;
                    URL[] deployURLs = null;
                    try {
                        IConfigurationElement element = elements[j];
                        name = element.getAttribute("name");
                        id = element.getAttribute("id");
                        IConfigurationElement[] scriptElements = element.getChildren("script");
                        IConfigurationElement[] fileElements = element.getChildren("file");
                        if (name == null) {
                            throw new IllegalArgumentException(Messages.LaunchProfileManager_MissingProfileName);
                        }
                        if (id == null) {
                            throw new IllegalArgumentException(Messages.LaunchProfileManager_MissingProfileID);
                        }
                        id = String.valueOf(contributorName) + "." + id;
                        if (scriptElements.length != 1) {
                            new IllegalArgumentException(Messages.LaunchProfileManager_ExactlyOneTCLScript);
                        }
                        if ((tclScriptURL = FileLocator.find((Bundle)bundle, (IPath)new Path(tclScriptPath = scriptElements[0].getAttribute("path")), null)) == null) {
                            throw new IllegalArgumentException(NLS.bind((String)Messages.LaunchProfileManager_TCLScriptFileNotFound, (Object)tclScriptPath));
                        }
                        try {
                            tclScriptURL = FileLocator.resolve((URL)tclScriptURL);
                        }
                        catch (IOException iOException) {
                            throw new IllegalArgumentException(NLS.bind((String)Messages.LaunchProfileManager_TCLScriptFileNotResolved, (Object)tclScriptPath));
                        }
                        Vector<String> tmpDeployPaths = new Vector<String>();
                        Vector<URL> tmpDeployURLs = new Vector<URL>();
                        int k = 0;
                        while (k < fileElements.length) {
                            String path = fileElements[k].getAttribute("path");
                            if (path == null) {
                                log.log((IStatus)new Status(4, contributorName, 0, Messages.LaunchProfileManager_EmptyFileNameEntry, null));
                            } else {
                                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
                                if (url == null) {
                                    throw new IllegalArgumentException(NLS.bind((String)Messages.LaunchProfileManager_DeployFileNotFound, (Object)tclScriptPath));
                                }
                                try {
                                    url = FileLocator.resolve((URL)url);
                                }
                                catch (IOException iOException) {
                                    throw new IllegalArgumentException(NLS.bind((String)Messages.LaunchProfileManager_DeployFileNotResolved, (Object)tclScriptPath));
                                }
                                tmpDeployPaths.add(path);
                                tmpDeployURLs.add(url);
                            }
                            ++k;
                        }
                        deployPaths = new String[tmpDeployPaths.size()];
                        deployURLs = new URL[tmpDeployURLs.size()];
                        deployPaths = tmpDeployPaths.toArray(deployPaths);
                        deployURLs = tmpDeployURLs.toArray(deployURLs);
                    }
                    catch (IllegalArgumentException e) {
                        log.log((IStatus)new Status(4, contributorName, 0, Messages.LaunchProfileManager_ExtensionPointError, (Throwable)e));
                        break block16;
                    }
                    LaunchProfile launchProfile = new LaunchProfile(id, name, tclScriptPath, tclScriptURL, deployPaths, deployURLs);
                    this.launchProfiles.put(launchProfile.getId(), launchProfile);
                }
                ++j;
            }
            ++i;
        }
    }

    public LaunchProfile[] getLaunchProfiles() {
        Collection set = this.launchProfiles.values();
        LaunchProfile[] result = new LaunchProfile[set.size()];
        result = set.toArray(result);
        return result;
    }

    public LaunchProfile getLaunchProfile(String profileId) {
        return (LaunchProfile)this.launchProfiles.get(profileId);
    }
}

