/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.be.cdi.command.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MISPUDMAListTuple {
    public static final String EMPTY = "";
    public static final String DMA_OPCODE = "opcode";
    public static final String DMA_TAG = "tag";
    public static final String DMA_TID = "tid";
    public static final String DMA_RID = "rid";
    public static final String DMA_EA = "ea";
    public static final String DMA_LSA = "lsa";
    public static final String DMA_SIZE = "size";
    public static final String DMA_LSTADDR = "lstaddr";
    public static final String DMA_LSTSIZE = "lstsize";
    public static final String DMA_ERROR_P = "error_p";
    private String opcode;
    private String tag;
    private String tid;
    private String rid;
    private String ea;
    private String lsa;
    private String size;
    private String lstaddr;
    private String lstsize;
    private String error_p;

    public MISPUDMAListTuple(String opcode, String tag, String tid, String rid, String ea, String lsa, String size, String lstaddr, String lstsize, String error_p) {
        this.opcode = opcode;
        this.tag = tag;
        this.tid = tid;
        this.rid = rid;
        this.ea = ea;
        this.lsa = lsa;
        this.size = size;
        this.lstaddr = lstaddr;
        this.lstsize = lstsize;
        this.error_p = error_p;
    }

    public MISPUDMAListTuple(MIResult[] results) {
        this.parseResults(results);
    }

    protected void parseResults(MIResult[] results) {
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (var.equals(DMA_OPCODE)) {
                if (value != null && value instanceof MIConst) {
                    this.setOpcode(((MIConst)value).getCString());
                } else {
                    this.setOpcode(EMPTY);
                }
            } else if (var.equals(DMA_TAG)) {
                if (value != null && value instanceof MIConst) {
                    this.setTag(((MIConst)value).getCString());
                } else {
                    this.setTag(EMPTY);
                }
            } else if (var.equals(DMA_TID)) {
                if (value != null && value instanceof MIConst) {
                    this.setTid(((MIConst)value).getCString());
                } else {
                    this.setTid(EMPTY);
                }
            } else if (var.equals(DMA_RID)) {
                if (value != null && value instanceof MIConst) {
                    this.setRid(((MIConst)value).getCString());
                } else {
                    this.setRid(EMPTY);
                }
            } else if (var.equals(DMA_EA)) {
                if (value != null && value instanceof MIConst) {
                    this.setEa(((MIConst)value).getCString());
                } else {
                    this.setEa(EMPTY);
                }
            } else if (var.equals(DMA_LSA)) {
                if (value != null && value instanceof MIConst) {
                    this.setLsa(((MIConst)value).getCString());
                } else {
                    this.setLsa(EMPTY);
                }
            } else if (var.equals(DMA_SIZE)) {
                if (value != null && value instanceof MIConst) {
                    this.setSize(((MIConst)value).getCString());
                } else {
                    this.setSize(EMPTY);
                }
            } else if (var.equals(DMA_LSTADDR)) {
                if (value != null && value instanceof MIConst) {
                    this.setLstaddr(((MIConst)value).getCString());
                } else {
                    this.setLstaddr(EMPTY);
                }
            } else if (var.equals(DMA_LSTSIZE)) {
                if (value != null && value instanceof MIConst) {
                    this.setLstsize(((MIConst)value).getCString());
                } else {
                    this.setLstsize(EMPTY);
                }
            } else if (var.equals(DMA_ERROR_P)) {
                if (value != null && value instanceof MIConst) {
                    this.setError_p(((MIConst)value).getCString());
                } else {
                    this.setError_p(EMPTY);
                }
            }
            ++i;
        }
    }

    public String getEa() {
        return this.ea;
    }

    public void setEa(String ea) {
        this.ea = ea;
    }

    public String getError_p() {
        return this.error_p;
    }

    public void setError_p(String error_p) {
        this.error_p = error_p;
    }

    public String getLsa() {
        return this.lsa;
    }

    public void setLsa(String lsa) {
        this.lsa = lsa;
    }

    public String getLstaddr() {
        return this.lstaddr;
    }

    public void setLstaddr(String lstaddr) {
        this.lstaddr = lstaddr;
    }

    public String getLstsize() {
        return this.lstsize;
    }

    public void setLstsize(String lstsize) {
        this.lstsize = lstsize;
    }

    public String getOpcode() {
        return this.opcode;
    }

    public void setOpcode(String opcode) {
        this.opcode = opcode;
    }

    public String getRid() {
        return this.rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTid() {
        return this.tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }
}

