/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.rm.core.ToolsRMPlugin;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.core.utils.IInputStreamListener;
import org.eclipse.ptp.rm.core.utils.InputStreamListenerToOutputStream;
import org.eclipse.ptp.rm.core.utils.InputStreamObserver;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPILaunchAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.OpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMap;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMapText12Parser;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMapXml13Parser;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIRuntimeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPIRuntimeSystemJob
extends AbstractToolRuntimeSystemJob {
    Object lock1 = new Object();
    private InputStreamObserver stderrObserver;
    private InputStreamObserver stdoutObserver;
    OpenMPIProcessMap map;
    String[] processIDs;
    IOException parserException = null;

    public OpenMPIRuntimeSystemJob(String jobID, String queueID, String name, AbstractToolRuntimeSystem rtSystem, AttributeManager attrMgr) {
        super(jobID, queueID, name, rtSystem, attrMgr);
    }

    protected void doExecutionStarted(IProgressMonitor monitor) throws CoreException {
        PipedInputStream parserInputStream;
        PipedOutputStream parserOutputStream;
        Thread stderrThread;
        InputStreamListenerToOutputStream stderrPipedStreamListener;
        Thread stdoutThread;
        InputStreamListenerToOutputStream stdoutPipedStreamListener;
        String zeroIndexProcessID;
        IPJob ipJob;
        OpenMPIRuntimeSystem rtSystem;
        block27: {
            PipedInputStream stderrInputStream;
            PipedOutputStream stderrOutputStream;
            block26: {
                PipedInputStream stdoutInputStream;
                PipedOutputStream stdoutOutputStream;
                block25: {
                    rtSystem = (OpenMPIRuntimeSystem)this.getRtSystem();
                    ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
                    zeroIndexProcessID = rtSystem.createProcess(this.getJobID(), Messages.OpenMPIRuntimeSystemJob_ProcessName, 0);
                    this.processIDs = new String[]{zeroIndexProcessID};
                    stdoutOutputStream = new PipedOutputStream();
                    stdoutInputStream = new PipedInputStream();
                    try {
                        stdoutInputStream.connect(stdoutOutputStream);
                    }
                    catch (IOException iOException) {
                        if ($assertionsDisabled) break block25;
                        throw new AssertionError();
                    }
                }
                stdoutPipedStreamListener = new InputStreamListenerToOutputStream((OutputStream)stdoutOutputStream);
                stdoutThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block9: {
                            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: started", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.jobID});
                            BufferedReader stdoutBufferedReader = new BufferedReader(new InputStreamReader(stdoutInputStream));
                            IPProcess ipProc = ipJob.getProcessById(zeroIndexProcessID);
                            try {
                                try {
                                    String line = stdoutBufferedReader.readLine();
                                    while (line != null) {
                                        Object object = OpenMPIRuntimeSystemJob.this.lock1;
                                        synchronized (object) {
                                            ipProc.addAttribute((IAttribute)ProcessAttributes.getStdoutAttributeDefinition().create(line));
                                            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}:> {1}", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.jobID, line});
                                        }
                                        line = stdoutBufferedReader.readLine();
                                    }
                                }
                                catch (IOException e) {
                                    DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: {0}", (Object[])new Object[]{e});
                                    OpenMPIPlugin.log(e);
                                    stdoutPipedStreamListener.disable();
                                    break block9;
                                }
                            }
                            catch (Throwable throwable) {
                                stdoutPipedStreamListener.disable();
                                throw throwable;
                            }
                            stdoutPipedStreamListener.disable();
                        }
                        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: finished", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.jobID});
                    }
                };
                stderrOutputStream = new PipedOutputStream();
                stderrInputStream = new PipedInputStream();
                try {
                    stderrInputStream.connect(stderrOutputStream);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block26;
                    throw new AssertionError();
                }
            }
            stderrPipedStreamListener = new InputStreamListenerToOutputStream((OutputStream)stderrOutputStream);
            stderrThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block9: {
                        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: started", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.jobID});
                        BufferedReader stderrBufferedReader = new BufferedReader(new InputStreamReader(stderrInputStream));
                        IPProcess ipProc = ipJob.getProcessById(zeroIndexProcessID);
                        try {
                            try {
                                String line = stderrBufferedReader.readLine();
                                while (line != null) {
                                    Object object = OpenMPIRuntimeSystemJob.this.lock1;
                                    synchronized (object) {
                                        ipProc.addAttribute((IAttribute)ProcessAttributes.getStderrAttributeDefinition().create(line));
                                        ipProc.addAttribute((IAttribute)ProcessAttributes.getStdoutAttributeDefinition().create(line));
                                        DebugUtil.error((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}:> {1}", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.jobID, line});
                                    }
                                    line = stderrBufferedReader.readLine();
                                }
                            }
                            catch (IOException e) {
                                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: {0}", (Object[])new Object[]{e});
                                OpenMPIPlugin.log(e);
                                stderrPipedStreamListener.disable();
                                break block9;
                            }
                        }
                        catch (Throwable throwable) {
                            stderrPipedStreamListener.disable();
                            throw throwable;
                        }
                        stderrPipedStreamListener.disable();
                    }
                    DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: finished", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.jobID});
                }
            };
            parserOutputStream = new PipedOutputStream();
            parserInputStream = new PipedInputStream();
            try {
                parserInputStream.connect(parserOutputStream);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block27;
                throw new AssertionError();
            }
        }
        final InputStreamListenerToOutputStream parserPipedStreamListener = new InputStreamListenerToOutputStream((OutputStream)parserOutputStream);
        Thread parserThread = new Thread(){

            public void run() {
                block13: {
                    DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: display-map parser thread: started", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.jobID});
                    OpenMPIResourceManagerConfiguration configuration = (OpenMPIResourceManagerConfiguration)OpenMPIRuntimeSystemJob.this.getRtSystem().getRmConfiguration();
                    try {
                        try {
                            if (configuration.getVersionId().equals("openmpi-1.2")) {
                                OpenMPIRuntimeSystemJob.this.map = OpenMPIProcessMapText12Parser.parse(parserInputStream);
                            } else if (configuration.getVersionId().equals("openmpi-1.3")) {
                                OpenMPIRuntimeSystemJob.this.map = OpenMPIProcessMapXml13Parser.parse(parserInputStream, new OpenMPIProcessMapXml13Parser.IOpenMpiProcessMapXml13ParserListener(){

                                    public void startDocument() {
                                    }

                                    public void endDocument() {
                                        if (OpenMPIRuntimeSystemJob.this.stderrObserver != null) {
                                            parserPipedStreamListener.disable();
                                            OpenMPIRuntimeSystemJob.this.stderrObserver.removeListener((IInputStreamListener)parserPipedStreamListener);
                                        }
                                    }
                                });
                            } else if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                        catch (IOException e) {
                            OpenMPIRuntimeSystemJob.this.parserException = e;
                            DebugUtil.error((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: display-map parser thread: {0}", (Object[])new Object[]{e});
                            parserPipedStreamListener.disable();
                            if (OpenMPIRuntimeSystemJob.this.stderrObserver != null) {
                                OpenMPIRuntimeSystemJob.this.stderrObserver.removeListener((IInputStreamListener)parserPipedStreamListener);
                            }
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        parserPipedStreamListener.disable();
                        if (OpenMPIRuntimeSystemJob.this.stderrObserver != null) {
                            OpenMPIRuntimeSystemJob.this.stderrObserver.removeListener((IInputStreamListener)parserPipedStreamListener);
                        }
                        throw throwable;
                    }
                    parserPipedStreamListener.disable();
                    if (OpenMPIRuntimeSystemJob.this.stderrObserver != null) {
                        OpenMPIRuntimeSystemJob.this.stderrObserver.removeListener((IInputStreamListener)parserPipedStreamListener);
                    }
                }
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: display-map parser thread: finished", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.jobID});
            }
        };
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: starting all threads", (Object[])new Object[]{this.jobID});
        stdoutThread.start();
        stderrThread.start();
        parserThread.start();
        this.stderrObserver = new InputStreamObserver(this.process.getErrorStream());
        this.stdoutObserver = new InputStreamObserver(this.process.getInputStream());
        this.stdoutObserver.addListener((IInputStreamListener)stdoutPipedStreamListener);
        this.stderrObserver.addListener((IInputStreamListener)stderrPipedStreamListener);
        OpenMPIResourceManagerConfiguration configuration = (OpenMPIResourceManagerConfiguration)this.getRtSystem().getRmConfiguration();
        if (configuration.getVersionId().equals("openmpi-1.2")) {
            if (!rtSystem.getRemoteServices().getId().equals("org.eclipse.ptp.remote.RSERemoteServices")) {
                this.stderrObserver.addListener((IInputStreamListener)parserPipedStreamListener);
            } else {
                this.stdoutObserver.addListener((IInputStreamListener)parserPipedStreamListener);
            }
        } else if (configuration.getVersionId().equals("openmpi-1.3")) {
            this.stdoutObserver.addListener((IInputStreamListener)parserPipedStreamListener);
        } else assert (false);
        this.stderrObserver.start();
        this.stdoutObserver.start();
        try {
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting for display-map parser thread to finish", (Object[])new Object[]{this.jobID});
            parserThread.join();
        }
        catch (InterruptedException interruptedException) {}
        if (this.parserException != null) {
            boolean parseError = true;
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: destroy process due to error while parsing display map", (Object[])new Object[]{this.jobID});
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stderr thread to finish", (Object[])new Object[]{this.jobID});
            try {
                this.stderrObserver.join();
            }
            catch (InterruptedException interruptedException) {}
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stdout thread to finish", (Object[])new Object[]{this.jobID});
            try {
                this.stdoutObserver.join();
            }
            catch (InterruptedException interruptedException) {}
            if (parseError) {
                throw OpenMPIPlugin.coreErrorException("Failed to parse output of Open MPI command. Check output for errors.", this.parserException);
            }
            throw OpenMPIPlugin.coreErrorException("Open MPI failed to launch parallel application. Check output for errors.");
        }
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: updating model with display-map information", (Object[])new Object[]{this.jobID});
        rtSystem.changeJob(this.getJobID(), this.map.getAttributeManager());
        List<OpenMPIProcessMap.Process> newProcesses = this.map.getProcesses();
        this.processIDs = new String[newProcesses.size()];
        IPMachine ipMachine = PTPCorePlugin.getDefault().getUniverse().getResourceManager(rtSystem.getRmID()).getMachineById(rtSystem.getMachineID());
        for (OpenMPIProcessMap.Process newProcess : newProcesses) {
            AttributeManager attrMgr;
            String processID;
            String nodeID;
            block28: {
                String nodename = newProcess.getNode().getResolvedName();
                nodeID = rtSystem.getNodeIDforName(nodename);
                if (nodeID == null) {
                    this.process.destroy();
                    throw new CoreException((IStatus)new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.OpenMPIRuntimeSystemJob_Exception_HostnamesDoNotMatch, (Throwable)this.parserException));
                }
                String processName = newProcess.getName();
                int processIndex = newProcess.getIndex();
                processID = null;
                processID = processIndex == 0 ? zeroIndexProcessID : rtSystem.createProcess(this.getJobID(), processName, processIndex);
                this.processIDs[processIndex] = processID;
                attrMgr = new AttributeManager();
                attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(processName));
                attrMgr.addAttribute((IAttribute)ProcessAttributes.getNodeIdAttributeDefinition().create(nodeID));
                attrMgr.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.RUNNING));
                try {
                    attrMgr.addAttribute((IAttribute)ProcessAttributes.getIndexAttributeDefinition().create(Integer.valueOf(newProcess.getIndex())));
                }
                catch (IllegalValueException illegalValueException) {
                    if ($assertionsDisabled) break block28;
                    throw new AssertionError();
                }
            }
            attrMgr.addAttributes(newProcess.getAttributeManager().getAttributes());
            rtSystem.changeProcess(processID, attrMgr);
            IPProcessControl processControl = (IPProcessControl)ipJob.getProcessById(processID);
            IPNode node = ipMachine.getNodeById(nodeID);
            IPNodeControl nodeControl = (IPNodeControl)node;
            nodeControl.addProcesses((Collection)Arrays.asList(processControl));
        }
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: finished updating model", (Object[])new Object[]{this.jobID});
    }

    protected void doWaitExecution(IProgressMonitor monitor) throws CoreException {
        if (!this.rtSystem.getRemoteServices().getId().equals("org.eclipse.ptp.remote.RSERemoteServices")) {
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stderr thread to finish", (Object[])new Object[]{this.jobID});
            try {
                this.stderrObserver.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stdout thread to finish", (Object[])new Object[]{this.jobID});
        try {
            this.stdoutObserver.join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting mpi process to finish completely", (Object[])new Object[]{this.jobID});
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: completely finished", (Object[])new Object[]{this.jobID});
    }

    protected void doTerminateJob() {
    }

    protected void doExecutionFinished(IProgressMonitor monitor) throws CoreException {
        if (this.process.exitValue() != 0) {
            this.changeJobState(JobAttributes.State.ERROR);
            if (!this.terminateJobFlag) {
                throw OpenMPIPlugin.coreErrorException(NLS.bind((String)Messages.OpenMPIRuntimeSystemJob_Exception_ExecutionFailedWithExitValue, (Object)this.process.exitValue()));
            }
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING, (String)"RTS job #{0}: ignoring exit value {1} because job was forced to terminate by user", (Object[])new Object[]{this.jobID, this.process.exitValue()});
        }
        this.changeAllProcessesStatus(ProcessAttributes.State.EXITED);
    }

    private void changeAllProcessesStatus(ProcessAttributes.State newState) {
        IPJob ipJob;
        IPQueue queue;
        OpenMPIRuntimeSystem rtSystem = (OpenMPIRuntimeSystem)this.getRtSystem();
        IResourceManager rm = PTPCorePlugin.getDefault().getUniverse().getResourceManager(rtSystem.getRmID());
        if (rm != null && (queue = rm.getQueueById(this.getQueueID())) != null && (ipJob = queue.getJobById(this.getJobID())) != null) {
            ArrayList<String> ids = new ArrayList<String>();
            IPProcess[] iPProcessArray = ipJob.getProcesses();
            int n = iPProcessArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPProcess ipProcess = iPProcessArray[n2];
                switch (ipProcess.getState()) {
                    case EXITED: 
                    case EXITED_SIGNALLED: 
                    case ERROR: {
                        break;
                    }
                    case STARTING: 
                    case RUNNING: 
                    case SUSPENDED: 
                    case UNKNOWN: {
                        ids.add(ipProcess.getID());
                    }
                }
                ++n2;
            }
            AttributeManager attrMrg = new AttributeManager();
            attrMrg.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)newState));
            for (String processId : ids) {
                rtSystem.changeProcess(processId, attrMrg);
            }
        }
    }

    protected void doExecutionCleanUp(IProgressMonitor monitor) {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.stderrObserver != null) {
            this.stderrObserver.kill();
            this.stderrObserver = null;
        }
        if (this.stdoutObserver != null) {
            this.stdoutObserver.kill();
            this.stdoutObserver = null;
        }
        this.changeAllProcessesStatus(ProcessAttributes.State.EXITED);
    }

    protected void doBeforeExecution(IProgressMonitor monitor) throws CoreException {
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolBaseSubstitutionAttributes() throws CoreException {
        return null;
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolCommandSubstitutionAttributes(AttributeManager baseSubstitutionAttributeManager, String directory, Map<String, String> environment) {
        ArrayList<Object> newAttributes = new ArrayList<Object>();
        int p = 0;
        String[] keys = new String[environment.size()];
        for (String key : environment.keySet()) {
            keys[p++] = key;
        }
        newAttributes.add((IAttribute)OpenMPILaunchAttributes.getEnvironmentKeysAttributeDefinition().create((Comparable[])keys));
        newAttributes.add(OpenMPILaunchAttributes.getEnvironmentArgsAttributeDefinition().create());
        return newAttributes.toArray(new IAttribute[newAttributes.size()]);
    }

    protected HashMap<String, String> doRetrieveToolEnvironment() throws CoreException {
        return null;
    }

    protected void doPrepareExecution(IProgressMonitor monitor) throws CoreException {
    }
}

