/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayModifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.Assert;

public class CPPASTNewExpression
extends CPPASTNode
implements ICPPASTNewExpression,
IASTAmbiguityParent {
    private boolean global;
    private IASTExpression placement;
    private IASTExpression initializer;
    private IASTTypeId typeId;
    private boolean isNewTypeId;
    private IASTExpression[] arrayExpressions = null;

    public CPPASTNewExpression() {
    }

    public CPPASTNewExpression(IASTExpression placement, IASTExpression initializer, IASTTypeId typeId) {
        this.setNewPlacement(placement);
        this.setNewInitializer(initializer);
        this.setTypeId(typeId);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setIsGlobal(boolean value) {
        this.global = value;
    }

    public IASTExpression getNewPlacement() {
        return this.placement;
    }

    public void setNewPlacement(IASTExpression expression) {
        this.placement = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEW_PLACEMENT);
        }
    }

    public IASTExpression getNewInitializer() {
        return this.initializer;
    }

    public void setNewInitializer(IASTExpression expression) {
        this.initializer = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEW_INITIALIZER);
        }
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public void setTypeId(IASTTypeId typeId) {
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    public boolean isNewTypeId() {
        return this.isNewTypeId;
    }

    public void setIsNewTypeId(boolean value) {
        this.isNewTypeId = value;
    }

    public IASTExpression[] getNewTypeIdArrayExpressions() {
        if (this.arrayExpressions == null) {
            IASTDeclarator dtor;
            if (this.typeId != null && (dtor = CPPVisitor.findInnermostDeclarator(this.typeId.getAbstractDeclarator())) instanceof IASTArrayDeclarator) {
                IASTArrayDeclarator ad = (IASTArrayDeclarator)dtor;
                IASTArrayModifier[] ams = ad.getArrayModifiers();
                this.arrayExpressions = new IASTExpression[ams.length];
                int i = 0;
                while (i < ams.length) {
                    IASTArrayModifier am = ams[i];
                    this.arrayExpressions[i] = am.getConstantExpression();
                    ++i;
                }
                return this.arrayExpressions;
            }
            this.arrayExpressions = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        return this.arrayExpressions;
    }

    public void addNewTypeIdArrayExpression(IASTExpression expression) {
        Assert.isNotNull((Object)this.typeId);
        IASTDeclarator dtor = CPPVisitor.findInnermostDeclarator(this.typeId.getAbstractDeclarator());
        if (!(dtor instanceof IASTArrayDeclarator)) {
            IASTPointerOperator[] ptrOps;
            Assert.isNotNull((Object)dtor);
            Assert.isTrue((dtor.getParent() == this.typeId ? 1 : 0) != 0);
            CPPASTArrayDeclarator adtor = new CPPASTArrayDeclarator(dtor.getName());
            IASTPointerOperator[] iASTPointerOperatorArray = ptrOps = dtor.getPointerOperators();
            int n = ptrOps.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator ptr = iASTPointerOperatorArray[n2];
                adtor.addPointerOperator(ptr);
                ++n2;
            }
            this.typeId.setAbstractDeclarator(adtor);
            dtor = adtor;
        }
        CPPASTArrayModifier mod = new CPPASTArrayModifier(expression);
        ((ASTNode)mod).setOffsetAndLength((ASTNode)((Object)expression));
        ((IASTArrayDeclarator)dtor).addArrayModifier(mod);
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.placement != null && !this.placement.accept(action)) {
            return false;
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (this.initializer != null && !this.initializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.placement) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.placement = (IASTExpression)other;
        }
        if (child == this.initializer) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.initializer = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        return CPPVisitor.getExpressionType(this);
    }
}

