/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplateInstantiator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPClassTemplate
extends PDOMCPPClassType
implements ICPPClassTemplate,
ICPPInternalTemplateInstantiator,
ICPPTemplateScope {
    private static final int PARAMETERS = 40;
    private static final int INSTANCES = 44;
    private static final int SPECIALIZATIONS = 48;
    private static final int FIRST_PARTIAL = 52;
    protected static final int RECORD_SIZE = 56;
    private ICPPTemplateParameter[] params;
    private PDOMCPPTemplateScope scope;

    public PDOMCPPClassTemplate(PDOM pdom, PDOMNode parent, ICPPClassTemplate template) throws CoreException {
        super(pdom, parent, template);
    }

    public PDOMCPPClassTemplate(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 56;
    }

    public int getNodeType() {
        return 24;
    }

    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.params == null) {
            try {
                PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 40, this.getLinkageImpl());
                TemplateParameterCollector visitor = new TemplateParameterCollector();
                list.accept(visitor);
                this.params = visitor.getTemplateParameters();
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                this.params = ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
            }
        }
        ICPPTemplateParameter[] result = new ICPPTemplateParameter[this.params.length];
        System.arraycopy(this.params, 0, result, 0, this.params.length);
        return result;
    }

    private PDOMCPPClassTemplatePartialSpecialization getFirstPartial() throws CoreException {
        int value = this.pdom.getDB().getInt(this.record + 52);
        return value != 0 ? new PDOMCPPClassTemplatePartialSpecialization(this.pdom, value) : null;
    }

    public void addPartial(PDOMCPPClassTemplatePartialSpecialization partial) throws CoreException {
        PDOMCPPClassTemplatePartialSpecialization first = this.getFirstPartial();
        partial.setNextPartial(first);
        this.pdom.getDB().putInt(this.record + 52, partial.getRecord());
    }

    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() throws DOMException {
        try {
            ArrayList<PDOMCPPClassTemplatePartialSpecialization> partials = new ArrayList<PDOMCPPClassTemplatePartialSpecialization>();
            PDOMCPPClassTemplatePartialSpecialization partial = this.getFirstPartial();
            while (partial != null) {
                partials.add(partial);
                partial = partial.getNextPartial();
            }
            return partials.toArray(new ICPPClassTemplatePartialSpecialization[partials.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new ICPPClassTemplatePartialSpecialization[0];
        }
    }

    public ICPPTemplateDefinition getTemplateDefinition() throws DOMException {
        return null;
    }

    public IIndexScope getScope() {
        if (this.scope == null) {
            this.scope = new PDOMCPPTemplateScope();
        }
        return this.scope;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 40, this.getLinkageImpl());
        list.accept(visitor);
        list = new PDOMNodeLinkedList(this.pdom, this.record + 44, this.getLinkageImpl());
        list.accept(visitor);
    }

    public void specializationsAccept(IPDOMVisitor visitor) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 48, this.getLinkageImpl());
        list.accept(visitor);
    }

    public void addMember(PDOMNode member) throws CoreException {
        if (member instanceof ICPPTemplateParameter) {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 40, this.getLinkageImpl());
            list.addMember(member);
        } else if (member instanceof ICPPTemplateInstance) {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 44, this.getLinkageImpl());
            list.addMember(member);
        } else if (member instanceof ICPPSpecialization) {
            if (this.equals(((ICPPSpecialization)((Object)member)).getSpecializedBinding())) {
                PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 48, this.getLinkageImpl());
                list.addMember(member);
            } else {
                super.addMember(member);
            }
        } else {
            super.addMember(member);
        }
    }

    public ICPPSpecialization deferredInstance(ObjectMap argMap, IType[] arguments) {
        ICPPSpecialization instance = this.getInstance(arguments);
        if (instance == null) {
            instance = new CPPDeferredClassInstance(this, argMap, arguments);
        }
        return instance;
    }

    public ICPPSpecialization getInstance(IType[] arguments) {
        try {
            InstanceFinder visitor = new InstanceFinder(arguments);
            PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 44, this.getLinkageImpl());
            list.accept(visitor);
            if (visitor.getInstance() == null) {
                list = new PDOMNodeLinkedList(this.pdom, this.record + 48, this.getLinkageImpl());
                list.accept(visitor);
            }
            return visitor.getInstance();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public IBinding instantiate(IType[] arguments) {
        ICPPTemplateDefinition template = null;
        try {
            template = CPPTemplates.matchTemplatePartialSpecialization(this, arguments);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        if (template instanceof IProblemBinding) {
            return template;
        }
        if (template != null && template instanceof ICPPClassTemplatePartialSpecialization) {
            return ((PDOMCPPClassTemplate)template).instantiate(arguments);
        }
        return CPPTemplates.instantiateTemplate(this, arguments, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            if (node.getRecord() != this.getRecord()) return false;
            return true;
        }
        try {
            ICPPTemplateParameter op;
            ICPPTemplateParameter p;
            block15: {
                if (!(type instanceof ICPPClassTemplate)) return false;
                if (type instanceof ProblemBinding) return false;
                boolean same = !(type instanceof ICPPClassTemplatePartialSpecialization);
                ICPPClassType ctype = (ICPPClassType)type;
                try {
                    if (same && ctype.getKey() == this.getKey()) {
                        char[][] qname = ctype.getQualifiedNameCharArray();
                        same = this.hasQualifiedName(qname, qname.length - 1);
                    }
                }
                catch (DOMException e) {
                    CCorePlugin.log((Throwable)e);
                }
                if (!same) {
                    return false;
                }
                ICPPTemplateParameter[] params = this.getTemplateParameters();
                ICPPTemplateParameter[] oparams = ((ICPPClassTemplate)type).getTemplateParameters();
                if (params == null && oparams == null) {
                    return true;
                }
                if (params == null) return false;
                if (oparams == null) {
                    return false;
                }
                if (params.length != oparams.length) {
                    return false;
                }
                int i = 0;
                while (same) {
                    if (i >= params.length) {
                        return same;
                    }
                    p = params[i];
                    op = oparams[i];
                    if (p instanceof IType && op instanceof IType) {
                        same &= ((IType)((Object)p)).isSameType((IType)((Object)op));
                        ++i;
                        continue;
                    }
                    break block15;
                }
                return same;
            }
            if (!(p instanceof ICPPTemplateNonTypeParameter)) return false;
            if (!(op instanceof ICPPTemplateNonTypeParameter)) return false;
            IType pt = ((ICPPTemplateNonTypeParameter)p).getType();
            IType opt = ((ICPPTemplateNonTypeParameter)op).getType();
            if (pt != null && opt != null) {
                boolean bl = pt.isSameType(opt);
                return bl;
            }
            if (pt != opt) return false;
            return true;
        }
        catch (DOMException e) {
            CCorePlugin.log((Throwable)e);
            return false;
        }
    }

    private static class InstanceFinder
    implements IPDOMVisitor {
        private ICPPSpecialization instance = null;
        private IType[] arguments;

        public InstanceFinder(IType[] arguments) {
            this.arguments = arguments;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            PDOMCPPSpecialization spec;
            if (this.instance == null && node instanceof PDOMCPPSpecialization && (spec = (PDOMCPPSpecialization)node).matchesArguments(this.arguments)) {
                this.instance = spec;
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPSpecialization getInstance() {
            return this.instance;
        }
    }

    private class PDOMCPPTemplateScope
    implements ICPPTemplateScope,
    IIndexScope {
        private PDOMCPPTemplateScope() {
        }

        public IBinding[] find(String name) throws DOMException {
            return CPPSemantics.findBindings((IScope)this, name, false);
        }

        public final IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
            return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
        }

        public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) throws DOMException {
            return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
        }

        public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
            try {
                BindingCollector visitor = new BindingCollector(PDOMCPPClassTemplate.this.getLinkageImpl(), name.toCharArray());
                PDOMNodeLinkedList list = new PDOMNodeLinkedList(PDOMCPPClassTemplate.this.pdom, PDOMCPPClassTemplate.this.record + 40, PDOMCPPClassTemplate.this.getLinkageImpl());
                list.accept(visitor);
                return CPPSemantics.resolveAmbiguities(name, visitor.getBindings());
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return null;
            }
        }

        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
            Object[] result = null;
            try {
                BindingCollector visitor = new BindingCollector(PDOMCPPClassTemplate.this.getLinkageImpl(), name.toCharArray(), null, prefixLookup, !prefixLookup);
                PDOMNodeLinkedList list = new PDOMNodeLinkedList(PDOMCPPClassTemplate.this.pdom, PDOMCPPClassTemplate.this.record + 40, PDOMCPPClassTemplate.this.getLinkageImpl());
                list.accept(visitor);
                result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, visitor.getBindings());
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
            return (IBinding[])ArrayUtil.trim(IBinding.class, result);
        }

        public IIndexScope getParent() {
            return PDOMCPPClassTemplate.this.getParent();
        }

        public ICPPTemplateDefinition getTemplateDefinition() throws DOMException {
            return null;
        }

        public IIndexName getScopeName() {
            return null;
        }

        public IIndexBinding getScopeBinding() {
            return PDOMCPPClassTemplate.this;
        }
    }

    private static class TemplateParameterCollector
    implements IPDOMVisitor {
        private List<IPDOMNode> params = new ArrayList<IPDOMNode>();

        private TemplateParameterCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPTemplateParameter) {
                this.params.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPTemplateParameter[] getTemplateParameters() {
            return this.params.toArray(new ICPPTemplateParameter[this.params.size()]);
        }
    }
}

