/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.ISourceCodeParser;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.internal.core.dom.parser.AbstractGNUSourceCodeParser;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.core.util.ICancelable;
import org.eclipse.cdt.internal.core.util.ICanceler;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractCLikeLanguage
extends AbstractLanguage
implements ICLanguageKeywords {
    private String[] keywords = null;
    private String[] builtinTypes = null;
    private String[] preprocessorKeywords = null;

    protected abstract IScannerExtensionConfiguration getScannerExtensionConfiguration();

    protected abstract ISourceCodeParser createParser(IScanner var1, ParserMode var2, IParserLogService var3, IIndex var4);

    protected abstract ParserLanguage getParserLanguage();

    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(reader, scanInfo, fileCreator, index, 0, log);
    }

    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory codeReaderFactory, IIndex index, int options, IParserLogService log) throws CoreException {
        final IScanner scanner = this.createScanner(reader, scanInfo, codeReaderFactory, log);
        scanner.setScanComments((options & 2) != 0);
        scanner.setComputeImageLocations((options & 4) == 0);
        final ISourceCodeParser parser = this.createParser(scanner, log, index, false, options);
        ICanceler canceler = null;
        if (log instanceof ICanceler) {
            canceler = (ICanceler)log;
            canceler.setCancelable(new ICancelable(){

                public void cancel() {
                    scanner.cancel();
                    parser.cancel();
                }
            });
        }
        try {
            IASTTranslationUnit ast = parser.parse();
            ast.setIsHeaderUnit((options & 8) == 0);
            IASTTranslationUnit iASTTranslationUnit = ast;
            return iASTTranslationUnit;
        }
        finally {
            if (canceler != null) {
                canceler.setCancelable(null);
            }
        }
    }

    public IASTCompletionNode getCompletionNode(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        IScanner scanner = this.createScanner(reader, scanInfo, fileCreator, log);
        scanner.setContentAssistMode(offset);
        ISourceCodeParser parser = this.createParser(scanner, log, index, true, 0);
        parser.parse();
        IASTCompletionNode node = parser.getCompletionNode();
        return node;
    }

    protected ISourceCodeParser createParser(IScanner scanner, IParserLogService log, IIndex index, boolean forCompletion, int options) {
        ParserMode mode = forCompletion ? ParserMode.COMPLETION_PARSE : ((options & 1) != 0 ? ParserMode.STRUCTURAL_PARSE : ParserMode.COMPLETE_PARSE);
        ISourceCodeParser parser = this.createParser(scanner, mode, log, index);
        if ((options & 0x10) != 0 && parser instanceof AbstractGNUSourceCodeParser) {
            ((AbstractGNUSourceCodeParser)parser).setSkipTrivialExpressionsInAggregateInitializers(true);
        }
        return parser;
    }

    protected IScanner createScanner(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IParserLogService log) {
        return new CPreprocessor(reader, scanInfo, this.getParserLanguage(), log, this.getScannerExtensionConfiguration(), fileCreator);
    }

    public IASTName[] getSelectedNames(IASTTranslationUnit ast, int start, int length) {
        IASTNode selectedNode = ast.getNodeSelector(null).findNode(start, length);
        if (selectedNode == null) {
            return new IASTName[0];
        }
        if (selectedNode instanceof IASTName) {
            return new IASTName[]{(IASTName)selectedNode};
        }
        if (selectedNode instanceof IASTPreprocessorMacroExpansion) {
            return new IASTName[]{((IASTPreprocessorMacroExpansion)selectedNode).getMacroReference()};
        }
        NameCollector collector = new NameCollector();
        selectedNode.accept(collector);
        return collector.getNames();
    }

    public IContributedModelBuilder createModelBuilder(ITranslationUnit tu) {
        return null;
    }

    public String[] getKeywords() {
        if (this.keywords == null) {
            HashSet<String> keywordSet = new HashSet<String>(KeywordSets.getKeywords(KeywordSetKey.KEYWORDS, this.getParserLanguage()));
            CharArrayIntMap additionalKeywords = this.getScannerExtensionConfiguration().getAdditionalKeywords();
            if (additionalKeywords != null) {
                for (char[] name : additionalKeywords.toList()) {
                    keywordSet.add(new String(name));
                }
            }
            this.keywords = keywordSet.toArray(new String[keywordSet.size()]);
        }
        return this.keywords;
    }

    public String[] getBuiltinTypes() {
        if (this.builtinTypes == null) {
            Set<String> types = KeywordSets.getKeywords(KeywordSetKey.TYPES, this.getParserLanguage());
            this.builtinTypes = types.toArray(new String[types.size()]);
        }
        return this.builtinTypes;
    }

    public String[] getPreprocessorKeywords() {
        if (this.preprocessorKeywords == null) {
            HashSet<String> keywords = new HashSet<String>(KeywordSets.getKeywords(KeywordSetKey.PP_DIRECTIVE, this.getParserLanguage()));
            CharArrayIntMap additionalKeywords = this.getScannerExtensionConfiguration().getAdditionalPreprocessorKeywords();
            if (additionalKeywords != null) {
                for (char[] name : additionalKeywords.toList()) {
                    keywords.add(new String(name));
                }
            }
            this.preprocessorKeywords = keywords.toArray(new String[keywords.size()]);
        }
        return this.preprocessorKeywords;
    }

    static class NameCollector
    extends ASTVisitor {
        private List<IASTName> nameList;

        NameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList<IASTName>();
        }

        public int visit(IASTName name) {
            this.nameList.add(name);
            return 3;
        }

        public IASTName[] getNames() {
            return this.nameList.toArray(new IASTName[this.nameList.size()]);
        }
    }
}

