/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.internal.core.indexer.ILanguageMapper;
import org.eclipse.cdt.internal.core.indexer.IStandaloneScannerInfoProvider;
import org.eclipse.cdt.internal.core.indexer.StandaloneFastIndexer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dstore.core.miners.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.Serializer;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CallsToResult;
import org.eclipse.ptp.internal.rdt.core.contentassist.CompletionProposalComputer;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteContentAssistInvocationContext;
import org.eclipse.ptp.internal.rdt.core.index.DummyName;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.miners.OpenDeclarationHandler;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexFileLocation;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexManager;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLanguageMapper;
import org.eclipse.ptp.internal.rdt.core.miners.ScopeManager;
import org.eclipse.ptp.internal.rdt.core.miners.SimpleLocationConverter;
import org.eclipse.ptp.internal.rdt.core.miners.StandaloneSavedCodeReaderFactory;
import org.eclipse.ptp.internal.rdt.core.miners.StdoutProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.model.CProject;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.RemoteCProjectFactory;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraph;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.TypeHierarchyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDTMiner
extends Miner {
    public static final String C_INDEX_START = "C_INDEX_START";
    public static final String C_INDEX_REINDEX = "C_INDEX_REINDEX";
    public static final String C_INDEX_DELTA = "C_INDEX_DELTA";
    public static final String T_INDEX_STATUS_DESCRIPTOR = "Type.Index.Status";
    public static final String T_INDEX_STRING_DESCRIPTOR = "Type.Index.String";
    public static final String T_INDEX_FILENAME_DESCRIPTOR = "Type.Scope.Filename";
    public static final String T_INDEX_INT_DESCRIPTOR = "Type.Index.Int";
    public static final String T_INDEX_DELTA_CHANGED = "Type.Index.Delta.Changed";
    public static final String T_INDEX_DELTA_ADDED = "Type.Index.Delta.Added";
    public static final String T_INDEX_DELTA_REMOVED = "Type.Index.Delta.Removed";
    public static final String T_INDEX_SCANNER_INFO_PROVIDER = "Type.Index.ScannerInfoProvider";
    public static final String T_INDEXER_PROGRESS_INFO = "Type.Indexer.ProgressInfo";
    public static final String C_SCOPE_REGISTER = "C_SCOPE_REGISTER";
    public static final String C_SCOPE_UNREGISTER = "C_SCOPE_UNREGISTER";
    public static final String C_SCOPE_DELTA = "C_SCOPE_DELTA";
    public static final String C_SCOPE_COUNT_ELEMENTS = "C_SCOPE_COUNT_ELEMENTS";
    public static final String T_SCOPE_SCOPENAME_DESCRIPTOR = "Type.Scope.Scopename";
    public static final String C_CALL_HIERARCHY_GET_CALLS = "C_CALL_HIERARCHY_GET_CALLS";
    public static final String T_CALL_HIERARCHY_RESULT = "Type.CallHierarchy.Result";
    public static final String C_CALL_HIERARCHY_GET_CALLERS = "C_CALL_HIERARCHY_GET_CALLERS";
    public static final String C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT = "C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT";
    public static final String C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY = "C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY";
    public static final String C_SEARCH_RUN_QUERY = "C_SEARCH_RUN_QUERY";
    public static final String T_SEARCH_RESULT = "Type.Search.Result";
    public static final String C_CONTENT_ASSIST_COMPUTE_PROPOSALS = "C_CONTENT_ASSIST_COMPUTE_PROPOSALS";
    public static final String C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH = "C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH";
    public static final String C_TYPE_HIERARCHY_FIND_INPUT1 = "C_TYPE_HIERARCHY_FIND_INPUT1";
    public static final String C_TYPE_HIERARCHY_FIND_INPUT2 = "C_TYPE_HIERARCHY_FIND_INPUT2";
    public static final String C_NAVIGATION_OPEN_DECLARATION = "C_NAVIGATION_OPEN_DECLARATION";
    public static final String T_NAVIGATION_RESULT = "Type.Navigation.Result";
    public static String LINE_SEPARATOR;
    public static final String DELIMITER = ";;;";

    public String getVersion() {
        return "0.0.1";
    }

    public DataElement handleCommand(DataElement theCommand) {
        String name = this.getCommandName(theCommand);
        DataElement status = this.getCommandStatus(theCommand);
        if (name.equals(C_SCOPE_REGISTER)) {
            DataElement scopeName = this.getCommandArgument(theCommand, 1);
            ArrayList<DataElement> fileNames = new ArrayList<DataElement>();
            int i = 2;
            while (i < theCommand.getNestedSize() - 1) {
                DataElement fileName = this.getCommandArgument(theCommand, i);
                String type = fileName.getType();
                if (type.equals(T_INDEX_FILENAME_DESCRIPTOR)) {
                    System.out.println("found a file\n");
                    System.out.flush();
                    fileNames.add(fileName);
                } else {
                    System.out.println("bad datatype in call to RegisterScope()");
                    System.out.flush();
                }
                ++i;
            }
            System.out.println("about to register scope\n");
            System.out.flush();
            this.handleRegisterScope(scopeName, fileNames, status);
        } else if (name.equals(C_SCOPE_UNREGISTER)) {
            DataElement scopeName = this.getCommandArgument(theCommand, 1);
            this.handleUnregisterScope(scopeName, status);
        } else if (name.equals(C_INDEX_START)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                IRemoteIndexerInfoProvider provider = (IRemoteIndexerInfoProvider)Serializer.deserialize(this.getString(theCommand, 2));
                System.out.println("Indexing scope " + scopeName);
                this.handleIndexStart(scopeName, provider, status);
                System.out.println("Indexing complete.");
                System.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_INDEX_DELTA)) {
            IRemoteIndexerInfoProvider provider;
            String scopeName = this.getString(theCommand, 1);
            try {
                provider = (IRemoteIndexerInfoProvider)Serializer.deserialize(this.getString(theCommand, 2));
            }
            catch (IOException e) {
                e.printStackTrace();
                return status;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return status;
            }
            System.out.println("Indexing delta for scope " + scopeName);
            System.out.flush();
            LinkedList<String> addedFiles = new LinkedList<String>();
            LinkedList<String> changedFiles = new LinkedList<String>();
            LinkedList<String> removedFiles = new LinkedList<String>();
            int i = 3;
            while (i < theCommand.getNestedSize() - 1) {
                DataElement changeElement = this.getCommandArgument(theCommand, i);
                String type = changeElement.getType();
                if (type.equals(T_INDEX_DELTA_ADDED)) {
                    System.out.println("added a file: " + changeElement.getName() + "\n");
                    System.out.flush();
                    addedFiles.add(changeElement.getName());
                } else if (type.equals(T_INDEX_DELTA_CHANGED)) {
                    System.out.println("changed a file: " + changeElement.getName() + "\n");
                    System.out.flush();
                    changedFiles.add(changeElement.getName());
                } else if (type.equals(T_INDEX_DELTA_REMOVED)) {
                    System.out.println("removed a file: " + changeElement.getName() + "\n");
                    System.out.flush();
                    removedFiles.add(changeElement.getName());
                } else {
                    System.out.println("bad datatype in call to RegisterScope()");
                    System.out.flush();
                }
                ++i;
            }
            this.handleIndexDelta(scopeName, addedFiles, changedFiles, removedFiles, provider, status);
            System.out.println("Indexing complete.");
            System.out.flush();
        } else if (name.equals(C_INDEX_REINDEX)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                IRemoteIndexerInfoProvider provider = (IRemoteIndexerInfoProvider)Serializer.deserialize(this.getString(theCommand, 2));
                System.out.println("Re-indexing scope " + scopeName);
                this.handleReindex(scopeName, provider, status);
                System.out.println("Reindexing complete.");
                System.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_CALL_HIERARCHY_GET_CALLERS)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                String hostName = this.getString(theCommand, 2);
                ICElement subject = (ICElement)Serializer.deserialize(this.getString(theCommand, 3));
                System.out.println("Getting callers...");
                System.out.flush();
                this.handleGetCallers(scopeName, subject, hostName, status);
                System.out.println("Finished getting callers.");
                System.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_CALL_HIERARCHY_GET_CALLS)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                String hostName = this.getString(theCommand, 2);
                ICElement subject = (ICElement)Serializer.deserialize(this.getString(theCommand, 3));
                System.out.println("Getting callees...");
                System.out.flush();
                this.handleGetCallees(scopeName, subject, hostName, status);
                System.out.println("Finished getting callees.");
                System.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                String hostName = this.getString(theCommand, 2);
                ICElement subject = (ICElement)Serializer.deserialize(this.getString(theCommand, 3));
                System.out.println("Getting definitions...");
                System.out.flush();
                this.handleGetDefinitions(scopeName, hostName, subject, status);
                System.out.println("Finished getting definitions.");
                System.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                String hostName = this.getString(theCommand, 2);
                ITranslationUnit unit = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 3));
                int selectionStart = this.getInteger(theCommand, 4);
                int selectionLength = this.getInteger(theCommand, 5);
                System.out.println("Getting definitions...");
                System.out.flush();
                this.handleGetDefinitions(scopeName, hostName, unit, selectionStart, selectionLength, status);
                System.out.println("Finished getting definitions.");
                System.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_SEARCH_RUN_QUERY)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                String hostName = this.getString(theCommand, 2);
                RemoteSearchQuery query = (RemoteSearchQuery)Serializer.deserialize(this.getString(theCommand, 3));
                System.out.println("Finding matches based on a pattern...");
                System.out.flush();
                this.handleRunQuery(scopeName, query, hostName, status);
                System.out.println("Finished finding matches");
                System.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_CONTENT_ASSIST_COMPUTE_PROPOSALS)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                RemoteContentAssistInvocationContext context = (RemoteContentAssistInvocationContext)Serializer.deserialize(this.getString(theCommand, 2));
                ITranslationUnit unit = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 3));
                System.out.println("Computing completions...");
                System.out.flush();
                this.handleComputeCompletionProposals(scopeName, context, unit, status);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                String hostName = this.getString(theCommand, 2);
                ICElement input = (ICElement)Serializer.deserialize(this.getString(theCommand, 3));
                System.out.println("Computing type graph...");
                System.out.flush();
                this.handleComputeTypeGraph(scopeName, hostName, input, status);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_TYPE_HIERARCHY_FIND_INPUT1)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                String hostName = this.getString(theCommand, 2);
                ICElement input = (ICElement)Serializer.deserialize(this.getString(theCommand, 3));
                System.out.println("Finding type hierarchy input from element selection...");
                System.out.flush();
                String projectName = input.getCProject().getElementName();
                this.handleFindTypeHierarchyInput(scopeName, hostName, projectName, input, status);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_TYPE_HIERARCHY_FIND_INPUT2)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                String hostName = this.getString(theCommand, 2);
                ITranslationUnit unit = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 3));
                int selectionStart = this.getInteger(theCommand, 4);
                int selectionLength = this.getInteger(theCommand, 5);
                System.out.println("Finding type hierarchy input from text selection...");
                System.out.flush();
                String projectName = unit.getCProject().getElementName();
                this.handleFindTypeHierarchyInput(scopeName, hostName, unit, projectName, selectionStart, selectionLength, status);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals(C_NAVIGATION_OPEN_DECLARATION)) {
            try {
                String scopeName = this.getString(theCommand, 1);
                ITranslationUnit unit = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 2));
                String selectedText = this.getString(theCommand, 3);
                int selectionStart = this.getInteger(theCommand, 4);
                int selectionLength = this.getInteger(theCommand, 5);
                System.out.println("Open declaration...");
                System.out.flush();
                OpenDeclarationResult result = OpenDeclarationHandler.handleOpenDeclaration(scopeName, unit, selectedText, selectionStart, selectionLength);
                String resultString = Serializer.serialize(result);
                status.getDataStore().createObject(status, T_NAVIGATION_RESULT, resultString);
                CDTMiner.statusDone(status);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return status;
    }

    protected void handleFindTypeHierarchyInput(String scopeName, String hostName, ITranslationUnit unit, String projectName, int selectionStart, int selectionLength, DataElement status) {
        try {
            System.out.println("File: " + unit.getLocationURI());
            System.out.println("Element: " + unit.getElementName());
            System.out.flush();
            IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName);
            System.out.println("Acquiring read lock");
            System.out.flush();
            index.acquireReadLock();
            try {
                IBinding binding;
                IIndexLocationConverter converter = this.getLocationConverter(hostName);
                ICElement[] result = null;
                CProject project = new CProject(projectName);
                IASTName name = IndexQueries.getSelectedName(index, unit, selectionStart, selectionLength);
                if (name != null && TypeHierarchyUtil.isValidInput(binding = name.resolveBinding())) {
                    ICElement input;
                    ICElement member = null;
                    if (!TypeHierarchyUtil.isValidTypeInput(binding)) {
                        member = TypeHierarchyUtil.findDeclaration(project, index, name, binding, converter, new RemoteCProjectFactory());
                        name = null;
                        binding = TypeHierarchyUtil.findTypeBinding(binding);
                    }
                    if (TypeHierarchyUtil.isValidTypeInput(binding) && (input = TypeHierarchyUtil.findDefinition(project, index, name, binding, converter, new RemoteCProjectFactory())) != null) {
                        result = new ICElement[]{input, member};
                    }
                }
                if (result != null) {
                    System.out.println("Found input.");
                    System.out.println("Details: " + result.toString());
                    System.out.flush();
                }
                String resultString = Serializer.serialize(result);
                status.getDataStore().createObject(status, T_SEARCH_RESULT, resultString);
            }
            finally {
                index.releaseReadLock();
                CDTMiner.statusDone(status);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void handleFindTypeHierarchyInput(String scopeName, String hostName, String projectName, ICElement input, DataElement status) {
        try {
            System.out.println("File: " + input.getLocationURI());
            System.out.println("Element: " + input.getElementName());
            System.out.flush();
            IIndexLocationConverter converter = this.getLocationConverter(hostName);
            IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName);
            System.out.println("Acquiring read lock");
            System.out.flush();
            index.acquireReadLock();
            try {
                ICElement[] result = null;
                CProject project = new CProject(projectName);
                ICElement member = input;
                IIndexName name = IndexQueries.remoteElementToName(index, member);
                if (name != null) {
                    member = IndexQueries.getCElementForName((ICProject)project, index, name, converter, (ICProjectFactory)new RemoteCProjectFactory());
                    IIndexBinding binding = index.findBinding((IName)name);
                    if (TypeHierarchyUtil.isValidTypeInput((IBinding)(binding = TypeHierarchyUtil.findTypeBinding((IBinding)binding)))) {
                        ICElement definition = TypeHierarchyUtil.findDefinition(project, index, null, (IBinding)binding, converter, new RemoteCProjectFactory());
                        if (input != null) {
                            result = new ICElement[]{definition, member};
                        }
                    }
                }
                if (result != null) {
                    System.out.println("Found input.");
                    System.out.flush();
                }
                String resultString = Serializer.serialize(result);
                status.getDataStore().createObject(status, T_SEARCH_RESULT, resultString);
            }
            finally {
                index.releaseReadLock();
                CDTMiner.statusDone(status);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void handleComputeTypeGraph(String scopeName, String hostName, ICElement input, DataElement status) {
        try {
            System.out.println("File: " + input.getLocationURI());
            System.out.println("Element: " + input.getElementName());
            System.out.flush();
            IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName);
            System.out.println("Acquiring read lock");
            System.out.flush();
            index.acquireReadLock();
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                THGraph graph = new THGraph();
                graph.setLocationConverter(this.getLocationConverter(hostName));
                RemoteCProjectFactory projectFactory = new RemoteCProjectFactory();
                graph.defineInputNode(index, input, projectFactory);
                graph.addSuperClasses(index, (IProgressMonitor)monitor, projectFactory);
                graph.addSubClasses(index, (IProgressMonitor)monitor, projectFactory);
                System.out.println("Found " + graph.getLeaveNodes().size() + " leaf node(s).");
                System.out.flush();
                String resultString = Serializer.serialize(graph);
                status.getDataStore().createObject(status, T_SEARCH_RESULT, resultString);
            }
            finally {
                index.releaseReadLock();
                CDTMiner.statusDone(status);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void handleComputeCompletionProposals(String scopeName, RemoteContentAssistInvocationContext context, ITranslationUnit unit, DataElement status) {
        try {
            System.out.println("File: " + unit.getLocationURI());
            System.out.println("Offset: " + context.getInvocationOffset());
            System.out.flush();
            IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName);
            System.out.println("Acquiring read lock");
            System.out.flush();
            index.acquireReadLock();
            try {
                List<Object> proposals;
                int style = 34;
                int offset = context.getInvocationOffset();
                IASTCompletionNode completionNode = unit.getCompletionNode(index, style, offset);
                context.setCompletionNode(completionNode);
                if (completionNode == null) {
                    proposals = Collections.emptyList();
                } else {
                    String prefix = completionNode.getPrefix();
                    if (prefix == null) {
                        prefix = context.computeIdentifierPrefix().toString();
                    }
                    CompletionProposalComputer computer = new CompletionProposalComputer();
                    proposals = computer.computeCompletionProposals(context, completionNode, prefix);
                }
                System.out.println("Found " + proposals.size() + " proposal(s).");
                System.out.flush();
                String resultString = Serializer.serialize(proposals);
                status.getDataStore().createObject(status, T_SEARCH_RESULT, resultString);
            }
            finally {
                index.releaseReadLock();
                CDTMiner.statusDone(status);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void handleRunQuery(String scopeName, RemoteSearchQuery query, String hostName, DataElement status) {
        try {
            System.out.println("Searching for: \"" + query + "\"");
            System.out.println("scope: " + scopeName);
            System.out.println("Getting index");
            System.out.flush();
            IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName);
            System.out.println("Acquiring read lock");
            System.out.flush();
            index.acquireReadLock();
            try {
                query.runWithIndex(index, this.getLocationConverter(hostName), this.getProgressMonitor());
                List<RemoteSearchMatch> matches = query.getMatches();
                System.out.println("Found " + matches.size() + " match(es)");
                System.out.flush();
                String resultString = Serializer.serialize(matches);
                status.getDataStore().createObject(status, T_SEARCH_RESULT, resultString);
            }
            finally {
                index.releaseReadLock();
                CDTMiner.statusDone(status);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private IIndexLocationConverter getLocationConverter(String hostName) {
        return new SimpleLocationConverter("rse", hostName);
    }

    private boolean getBoolean(DataElement theCommand, int i) {
        DataElement element = this.getCommandArgument(theCommand, i);
        return Boolean.parseBoolean(element.getName());
    }

    private String getString(DataElement command, int index) {
        DataElement element = this.getCommandArgument(command, index);
        return element.getName();
    }

    private int getInteger(DataElement command, int index) {
        DataElement element = this.getCommandArgument(command, index);
        return Integer.parseInt(element.getName());
    }

    protected void handleIndexDelta(String scopeName, List<String> addedFiles, List<String> changedFiles, List<String> removedFiles, IRemoteIndexerInfoProvider provider, DataElement status) {
        try {
            try {
                StandaloneFastIndexer indexer = RemoteIndexManager.getInstance().getIndexerForScope(scopeName);
                indexer.setScannerInfoProvider((IStandaloneScannerInfoProvider)provider);
                indexer.setLanguageMapper((ILanguageMapper)new RemoteLanguageMapper(provider));
                ScopeManager scopeManager = ScopeManager.getInstance();
                Iterator<String> iterator = addedFiles.iterator();
                while (iterator.hasNext()) {
                    scopeManager.addFileToScope(scopeName, iterator.next());
                }
                iterator = removedFiles.iterator();
                while (iterator.hasNext()) {
                    scopeManager.removeFileFromScope(scopeName, iterator.next());
                }
                try {
                    indexer.setTraceStatistics(true);
                    indexer.setShowProblems(true);
                    indexer.setShowActivity(true);
                    indexer.handleDelta(addedFiles, changedFiles, removedFiles, this.getProgressMonitor(indexer, status));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    private IProgressMonitor getProgressMonitor(StandaloneFastIndexer indexer, DataElement status) {
        return new RemoteIndexProgressMonitor(indexer, status);
    }

    private IProgressMonitor getProgressMonitor() {
        return new StdoutProgressMonitor();
    }

    public void extendSchema(DataElement schemaRoot) {
        System.out.println("Extended schema from CDTMiner");
        this.createCommandDescriptor(schemaRoot, "Register Scope", C_SCOPE_REGISTER, false);
        this.createCommandDescriptor(schemaRoot, "Unregister Scope", C_SCOPE_UNREGISTER, false);
        this.createCommandDescriptor(schemaRoot, "Start Index", C_INDEX_START, false);
        this.createCommandDescriptor(schemaRoot, "Reindex", C_INDEX_REINDEX, false);
        this.createCommandDescriptor(schemaRoot, "Index Delta", C_INDEX_DELTA, false);
        this.createCommandDescriptor(schemaRoot, "Get Callers", C_CALL_HIERARCHY_GET_CALLERS, false);
        this.createCommandDescriptor(schemaRoot, "Get Calls", C_CALL_HIERARCHY_GET_CALLS, false);
        this.createCommandDescriptor(schemaRoot, "Get definitions from element", C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT, false);
        this.createCommandDescriptor(schemaRoot, "Get definitions from working copy", C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY, false);
        this.createCommandDescriptor(schemaRoot, "Run query", C_SEARCH_RUN_QUERY, false);
        this.createCommandDescriptor(schemaRoot, "Compute completion proposals", C_CONTENT_ASSIST_COMPUTE_PROPOSALS, false);
        this.createCommandDescriptor(schemaRoot, "Compute type graph", C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH, false);
        this.createCommandDescriptor(schemaRoot, "Find input from element", C_TYPE_HIERARCHY_FIND_INPUT1, false);
        this.createCommandDescriptor(schemaRoot, "Find input from text selection", C_TYPE_HIERARCHY_FIND_INPUT2, false);
        this.createCommandDescriptor(schemaRoot, "Open declaration", C_NAVIGATION_OPEN_DECLARATION, false);
        this._dataStore.refresh(schemaRoot);
    }

    protected void handleGetDefinitions(String scopeName, String hostName, ICElement subject, DataElement status) {
        try {
            System.out.println("Getting definitions for subject " + subject.getElementName());
            System.out.println("scope: " + scopeName);
            System.out.println("path: " + subject.getLocationURI());
            System.out.println("Getting index");
            System.out.flush();
            IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName);
            System.out.println("Acquiring read lock");
            System.out.flush();
            index.acquireReadLock();
            try {
                ICElement[] definitions = null;
                if (subject instanceof ISourceReference) {
                    IIndexName name;
                    ICElement[] result;
                    IIndexBinding binding;
                    ISourceReference input = (ISourceReference)subject;
                    ITranslationUnit tu = input.getTranslationUnit();
                    if (CDTMiner.needToFindDefinition(subject) && (binding = IndexQueries.elementToBinding(index, subject)) != null && (result = IndexQueries.findAllDefinitions(index, (IBinding)binding, this.getLocationConverter(hostName), subject.getCProject(), new RemoteCProjectFactory())).length > 0) {
                        definitions = result;
                    }
                    if (definitions == null && (name = IndexQueries.remoteElementToName(index, subject)) != null) {
                        ICElement handle = IndexQueries.getCElementForName(tu, index, name, new RemoteCProjectFactory());
                        definitions = new ICElement[]{handle};
                    }
                }
                String resultString = Serializer.serialize(definitions);
                status.getDataStore().createObject(status, T_CALL_HIERARCHY_RESULT, resultString);
            }
            finally {
                index.releaseReadLock();
                CDTMiner.statusDone(status);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void handleGetDefinitions(String scopeName, String hostName, ITranslationUnit workingCopy, int selectionStart, int selectionLength, DataElement status) {
        try {
            System.out.println("Getting definitions for subject " + workingCopy.getElementName());
            System.out.println("scope: " + scopeName);
            System.out.println("path: " + workingCopy.getLocationURI());
            System.out.println("offset: " + selectionStart);
            System.out.println("length: " + selectionLength);
            System.out.println("Getting index");
            System.out.flush();
            IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName);
            System.out.println("Acquiring read lock");
            System.out.flush();
            index.acquireReadLock();
            try {
                IBinding binding;
                ICElement[] definitions = null;
                ICProject project = workingCopy.getCProject();
                IASTName name = IndexQueries.getSelectedName(index, workingCopy, selectionStart, selectionLength);
                if (name != null && CDTMiner.isRelevantForCallHierarchy(binding = name.resolveBinding())) {
                    if (name.isDefinition()) {
                        IIndexLocationConverter converter = this.getLocationConverter(hostName);
                        ICElement elem = IndexQueries.getCElementForName(project, index, name, converter, (ICProjectFactory)new RemoteCProjectFactory());
                        if (elem != null) {
                            definitions = new ICElement[]{elem};
                        }
                    } else {
                        ICElement[] elems = IndexQueries.findAllDefinitions(index, binding, this.getLocationConverter(hostName), project, new RemoteCProjectFactory());
                        if (elems.length == 0) {
                            ICElement elem = null;
                            elem = name.isDeclaration() ? IndexQueries.getCElementForName(project, index, name, this.getLocationConverter(hostName), (ICProjectFactory)new RemoteCProjectFactory()) : IndexQueries.findAnyDeclaration(index, project, binding, this.getLocationConverter(hostName), new RemoteCProjectFactory());
                            if (elem != null) {
                                elems = new ICElement[]{elem};
                            }
                        }
                        definitions = elems;
                    }
                }
                String resultString = Serializer.serialize(definitions);
                status.getDataStore().createObject(status, T_CALL_HIERARCHY_RESULT, resultString);
            }
            finally {
                index.releaseReadLock();
                CDTMiner.statusDone(status);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static boolean needToFindDefinition(ICElement elem) {
        switch (elem.getElementType()) {
            case 71: 
            case 73: 
            case 88: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    private IIndexFileLocation createLocation(String hostName, IIndexFileLocation location) throws URISyntaxException {
        URI uri = location.getURI();
        URI newURI = new URI("rse", hostName, uri.getPath(), null, null);
        return new RemoteIndexFileLocation(null, newURI);
    }

    protected void handleUnregisterScope(DataElement scopeName, DataElement status) {
        String scope = scopeName.getName();
        ScopeManager.getInstance().removeScope(scope);
        CDTMiner.statusDone(status);
    }

    /*
     * Exception decompiling
     */
    protected void handleGetCallers(String scopeName, ICElement subject, String hostName, DataElement status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isRelevantForCallHierarchy(IBinding binding) {
        return binding instanceof ICExternalBinding || binding instanceof IEnumerator || binding instanceof IFunction || binding instanceof IVariable;
    }

    protected void handleGetCallees(String scopeName, ICElement subject, String hostName, DataElement status) {
        String subjectName = subject.getElementName();
        System.out.println("Getting callees for subject " + subjectName);
        System.out.println("scope: " + scopeName);
        System.out.println("path: " + subject.getLocationURI());
        try {
            CallsToResult result = new CallsToResult();
            System.out.println("Getting index");
            System.out.flush();
            IIndexLocationConverter converter = this.getLocationConverter(hostName);
            IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName);
            try {
                try {
                    System.out.println("Acquiring read lock");
                    System.out.flush();
                    index.acquireReadLock();
                    IIndexName callerName = IndexQueries.remoteElementToName(index, subject);
                    if (callerName != null) {
                        IIndexName[] refs = callerName.getEnclosedNames();
                        int i = 0;
                        while (i < refs.length) {
                            ICElement[] defs;
                            IIndexName name = refs[i];
                            IIndexBinding binding = index.findBinding((IName)name);
                            if (CDTMiner.isRelevantForCallHierarchy((IBinding)binding) && (defs = IndexQueries.findRepresentative(index, (IBinding)binding, converter, subject.getCProject(), new RemoteCProjectFactory())) != null && defs.length > 0) {
                                IIndexFileLocation indexLocation = this.createLocation(hostName, name.getFile().getLocation());
                                DummyName reference = new DummyName(name, name.getFileLocation(), indexLocation);
                                result.add(defs, reference);
                            }
                            ++i;
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    index.releaseReadLock();
                    CDTMiner.statusDone(status);
                    return;
                }
            }
            finally {
                index.releaseReadLock();
                CDTMiner.statusDone(status);
            }
            String resultString = Serializer.serialize(result);
            status.getDataStore().createObject(status, T_CALL_HIERARCHY_RESULT, resultString);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void handleIndexStart(String scopeName, IRemoteIndexerInfoProvider provider, DataElement status) {
        try {
            try {
                StandaloneFastIndexer indexer = RemoteIndexManager.getInstance().getIndexerForScope(scopeName);
                indexer.setScannerInfoProvider((IStandaloneScannerInfoProvider)provider);
                indexer.setLanguageMapper((ILanguageMapper)new RemoteLanguageMapper(provider));
                Set<String> sources = ScopeManager.getInstance().getFilesForScope(scopeName);
                LinkedList<String> sourcesList = new LinkedList<String>(sources);
                try {
                    indexer.rebuild(sourcesList, this.getProgressMonitor());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    protected void handleReindex(String scopeName, IRemoteIndexerInfoProvider provider, DataElement status) {
        StandaloneFastIndexer indexer = RemoteIndexManager.getInstance().getIndexerForScope(scopeName);
        indexer.setScannerInfoProvider((IStandaloneScannerInfoProvider)provider);
        indexer.setLanguageMapper((ILanguageMapper)new RemoteLanguageMapper(provider));
        Set<String> sources = ScopeManager.getInstance().getFilesForScope(scopeName);
        LinkedList<String> sourcesList = new LinkedList<String>(sources);
        try {
            indexer.rebuild(sourcesList, this.getProgressMonitor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CDTMiner.statusDone(status);
    }

    protected void handleRegisterScope(DataElement scopeName, List<DataElement> fileNames, DataElement status) {
        String scope = scopeName.getName();
        Iterator<DataElement> iterator = fileNames.iterator();
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        System.out.println("Added scope " + scope + ". Files:\n");
        System.out.flush();
        while (iterator.hasNext()) {
            DataElement element = iterator.next();
            String fileName = element.getName();
            files.add(fileName);
            System.out.println(String.valueOf(fileName) + "\n");
            System.out.flush();
        }
        ScopeManager.getInstance().addScope(scope, files);
        CDTMiner.statusDone(status);
    }

    public static DataElement statusWorking(DataElement status) {
        status.setAttribute(2, "working");
        status.getDataStore().refresh(status);
        return status;
    }

    public static DataElement statusWorked(DataElement status, int numWorked) {
        status.setAttribute(2, new Integer(numWorked).toString());
        status.getDataStore().refresh(status);
        return status;
    }

    public static DataElement statusDone(DataElement status) {
        status.setAttribute(2, "done");
        status.getDataStore().refresh(status);
        return status;
    }

    public static DataElement statusCancelled(DataElement status) {
        status.setAttribute(2, "cancelled");
        status.getDataStore().refresh(status);
        return status;
    }

    public IASTTranslationUnit getASTTranslationUnit(String filePath, IRemoteIndexerInfoProvider indexerInfoProvider, IIndex index) {
        RemoteLanguageMapper languageMapper = new RemoteLanguageMapper(indexerInfoProvider);
        ILanguage language = languageMapper.getLanguage(filePath);
        if (language == null) {
            return null;
        }
        IASTTranslationUnit tu = null;
        try {
            int options = 0;
            if (indexerInfoProvider.isHeaderUnit(filePath)) {
                options = 8;
            }
            tu = language.getASTTranslationUnit(new CodeReader(filePath), indexerInfoProvider.getScannerInformation(filePath), (ICodeReaderFactory)StandaloneSavedCodeReaderFactory.getInstance(), index, options, (IParserLogService)new NullLogService());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tu;
    }
}

