/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.CProject;
import org.eclipse.ptp.internal.rdt.core.model.Enumeration;
import org.eclipse.ptp.internal.rdt.core.model.Enumerator;
import org.eclipse.ptp.internal.rdt.core.model.Field;
import org.eclipse.ptp.internal.rdt.core.model.Function;
import org.eclipse.ptp.internal.rdt.core.model.FunctionDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.FunctionTemplate;
import org.eclipse.ptp.internal.rdt.core.model.FunctionTemplateDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.Method;
import org.eclipse.ptp.internal.rdt.core.model.MethodDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.MethodTemplate;
import org.eclipse.ptp.internal.rdt.core.model.MethodTemplateDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.Namespace;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.SourceManipulation;
import org.eclipse.ptp.internal.rdt.core.model.Structure;
import org.eclipse.ptp.internal.rdt.core.model.StructureTemplate;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.TypeDef;
import org.eclipse.ptp.internal.rdt.core.model.Variable;

public class BindingAdapter {
    public static ICElement adaptBinding(ITranslationUnit unit, IBinding binding, int offset, int length, boolean definition) throws CModelException, DOMException {
        Parent parent = BindingAdapter.adapt(unit, binding.getScope());
        if (parent == null) {
            return null;
        }
        SourceManipulation element = null;
        if (binding instanceof ICPPMethod) {
            element = binding instanceof ICPPFunctionTemplate ? (definition ? new MethodTemplate(parent, (ICPPMethod)binding, (ICPPTemplateDefinition)binding) : new MethodTemplateDeclaration(parent, (ICPPMethod)binding, (ICPPTemplateDefinition)binding)) : (definition ? new Method(parent, (ICPPMethod)binding) : new MethodDeclaration(parent, (ICPPMethod)binding));
        } else if (binding instanceof IFunction) {
            element = binding instanceof ICPPFunctionTemplate ? (definition ? new FunctionTemplate(parent, (IFunction)binding, (ICPPTemplateDefinition)binding) : new FunctionTemplateDeclaration(parent, (IFunction)binding, (ICPPTemplateDefinition)binding)) : (definition ? new Function(parent, (IFunction)binding) : new FunctionDeclaration(parent, (IFunction)binding));
        } else if (binding instanceof IField) {
            element = new Field(parent, (IField)binding);
        } else if (binding instanceof IVariable) {
            if (binding instanceof IParameter) {
                return null;
            }
            element = new Variable(parent, (IVariable)binding);
        } else if (binding instanceof IEnumeration) {
            element = new Enumeration(parent, (IEnumeration)binding);
        } else if (binding instanceof IEnumerator) {
            element = new Enumerator(parent, (IEnumerator)binding);
        } else if (binding instanceof ICompositeType) {
            element = binding instanceof ICPPClassTemplate ? new StructureTemplate(parent, (ICompositeType)binding, (ICPPTemplateDefinition)binding) : new Structure(parent, (ICompositeType)binding);
        } else if (binding instanceof ICPPNamespace) {
            element = new Namespace(parent, (ICPPNamespace)binding);
        } else if (binding instanceof ITypedef) {
            element = new TypeDef(parent, (ITypedef)binding);
        }
        if (element != null) {
            parent.addChild(element);
            if (unit != null) {
                element.setLocationURI(unit.getLocationURI());
                element.setPath(unit.getPath());
            }
            element.setIdPos(offset, length);
            ICProject project = unit.getCProject();
            if (project instanceof CProject) {
                element.setCProject(project);
            }
        }
        return element;
    }

    private static Parent adapt(ITranslationUnit tu, IScope scope) throws DOMException {
        Parent element;
        Parent parent;
        if (tu instanceof TranslationUnit) {
            parent = (Parent)tu;
        } else {
            if (tu == null) {
                throw new IllegalArgumentException();
            }
            parent = new TranslationUnit(null, tu);
        }
        if (scope == null) {
            return parent;
        }
        IName scopeName = scope.getScopeName();
        if (scopeName == null) {
            if (scope.getParent() == null) {
                return parent;
            }
            if (scope instanceof ICPPTemplateScope) {
                return BindingAdapter.adapt(tu, scope.getParent());
            }
            return null;
        }
        Parent parentElement = BindingAdapter.adapt(tu, scope.getParent());
        if (parentElement == null) {
            return null;
        }
        if (scope instanceof ICPPClassScope) {
            ICPPClassType type = ((ICPPClassScope)scope).getClassType();
            element = new Structure(parentElement, (ICompositeType)type);
        } else if (scope instanceof ICCompositeTypeScope) {
            ICompositeType type = ((ICCompositeTypeScope)scope).getCompositeType();
            element = new Structure(parentElement, type);
        } else {
            if (scope instanceof ICPPBlockScope) {
                return null;
            }
            element = scope instanceof ICPPNamespaceScope ? new Namespace(parentElement, new String(scopeName.toCharArray())) : parentElement;
        }
        return element;
    }

    public static ICElement adaptBinding(ITranslationUnit parent, IBinding binding, boolean definition) throws CModelException, DOMException {
        return BindingAdapter.adaptBinding(parent, binding, -1, -1, definition);
    }
}

