/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;

public class CPPASTArrayDeclarator
extends CPPASTDeclarator
implements IASTArrayDeclarator {
    private IASTArrayModifier[] arrayMods = null;
    private int arrayModsPos = -1;

    public CPPASTArrayDeclarator(IASTName name, IASTInitializer initializer) {
        super(name, initializer);
    }

    public CPPASTArrayDeclarator(IASTName name) {
        super(name);
    }

    public CPPASTArrayDeclarator() {
    }

    public IASTArrayModifier[] getArrayModifiers() {
        if (this.arrayMods == null) {
            return IASTArrayModifier.EMPTY_ARRAY;
        }
        this.arrayMods = (IASTArrayModifier[])ArrayUtil.removeNullsAfter(IASTArrayModifier.class, this.arrayMods, this.arrayModsPos);
        return this.arrayMods;
    }

    public void addArrayModifier(IASTArrayModifier arrayModifier) {
        if (arrayModifier != null) {
            this.arrayMods = (IASTArrayModifier[])ArrayUtil.append(IASTArrayModifier.class, this.arrayMods, ++this.arrayModsPos, arrayModifier);
            arrayModifier.setParent(this);
            arrayModifier.setPropertyInParent(ARRAY_MODIFIER);
        }
    }

    protected boolean postAccept(ASTVisitor action) {
        IASTArrayModifier[] mods = this.getArrayModifiers();
        int i = 0;
        while (i < mods.length) {
            if (!mods[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTInitializer initializer = this.getInitializer();
        return initializer == null || initializer.accept(action);
    }
}

