/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;

public class CPPASTEnumerationSpecifier
extends CPPASTBaseDeclSpecifier
implements IASTEnumerationSpecifier {
    private IASTName name;
    private IASTEnumerationSpecifier.IASTEnumerator[] enumerators = null;
    private int enumeratorsPos = -1;

    public CPPASTEnumerationSpecifier() {
    }

    public CPPASTEnumerationSpecifier(IASTName name) {
        this.setName(name);
    }

    public void addEnumerator(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        if (enumerator != null) {
            enumerator.setParent(this);
            enumerator.setPropertyInParent(ENUMERATOR);
            this.enumerators = (IASTEnumerationSpecifier.IASTEnumerator[])ArrayUtil.append(IASTEnumerationSpecifier.IASTEnumerator.class, this.enumerators, ++this.enumeratorsPos, enumerator);
        }
    }

    public IASTEnumerationSpecifier.IASTEnumerator[] getEnumerators() {
        if (this.enumerators == null) {
            return IASTEnumerationSpecifier.IASTEnumerator.EMPTY_ENUMERATOR_ARRAY;
        }
        this.enumerators = (IASTEnumerationSpecifier.IASTEnumerator[])ArrayUtil.removeNullsAfter(IASTEnumerationSpecifier.IASTEnumerator.class, this.enumerators, this.enumeratorsPos);
        return this.enumerators;
    }

    public void setName(IASTName name) {
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ENUMERATION_NAME);
        }
    }

    public IASTName getName() {
        return this.name;
    }

    public String getRawSignature() {
        return this.getName().toString() == null ? "" : this.getName().toString();
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        IASTEnumerationSpecifier.IASTEnumerator[] enums = this.getEnumerators();
        int i = 0;
        while (i < enums.length) {
            if (!enums[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (this.name == n) {
            return 2;
        }
        return 3;
    }
}

