/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunction
extends PDOMCPPBinding
implements ICPPFunction,
IPDOMOverloader {
    private static final int NUM_PARAMS = 28;
    private static final int FIRST_PARAM = 32;
    protected static final int FUNCTION_TYPE = 36;
    private static final int SIGNATURE_HASH = 40;
    protected static final int ANNOTATION = 44;
    protected static final int RECORD_SIZE = 45;

    public PDOMCPPFunction(PDOM pdom, PDOMNode parent, ICPPFunction function, boolean setTypes) throws CoreException {
        super(pdom, parent, function.getNameCharArray());
        Database db = pdom.getDB();
        try {
            Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(function);
            pdom.getDB().putInt(this.record + 40, sigHash != null ? sigHash : 0);
            if (setTypes) {
                this.initData((ICPPFunctionType)function.getType(), function.getParameters());
            }
            db.putByte(this.record + 44, PDOMCPPAnnotation.encodeAnnotation(function));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    public void initData(ICPPFunctionType ftype, IParameter[] params) throws CoreException {
        PDOMCPPFunctionType pft = this.setType(ftype);
        this.setParameters(pft, params);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPFunction) {
            byte newAnnotation;
            IParameter[] newParams;
            ICPPFunctionType newType;
            ICPPFunction func = (ICPPFunction)newBinding;
            try {
                newType = (ICPPFunctionType)func.getType();
                newParams = func.getParameters();
                newAnnotation = PDOMCPPAnnotation.encodeAnnotation(func);
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus((Throwable)e));
            }
            IFunctionType oldType = this.getType();
            PDOMCPPParameter oldParams = this.getFirstParameter();
            this.initData(newType, newParams);
            if (oldType != null) {
                linkage.deleteType(oldType, this.record);
            }
            if (oldParams != null) {
                oldParams.delete(linkage);
            }
            this.pdom.getDB().putByte(this.record + 44, newAnnotation);
        }
    }

    private void setParameters(PDOMCPPFunctionType pft, IParameter[] params) throws CoreException {
        Database db = this.pdom.getDB();
        db.putInt(this.record + 28, params.length);
        db.putInt(this.record + 32, 0);
        IType[] paramTypes = pft.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            int ptRecord = i < paramTypes.length && paramTypes[i] != null ? ((PDOMNode)((Object)paramTypes[i])).getRecord() : 0;
            this.setFirstParameter(new PDOMCPPParameter(this.pdom, (PDOMNode)this, params[i], ptRecord));
            ++i;
        }
    }

    private PDOMCPPFunctionType setType(ICPPFunctionType ft) throws CoreException {
        PDOMCPPFunctionType pft = (PDOMCPPFunctionType)this.getLinkageImpl().addType(this, ft);
        this.pdom.getDB().putInt(this.record + 36, pft.getRecord());
        return pft;
    }

    public int getSignatureHash() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 40);
    }

    public static int getSignatureHash(PDOM pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 40);
    }

    public PDOMCPPFunction(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 45;
    }

    public int getNodeType() {
        return 7;
    }

    private PDOMCPPParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 32);
        return rec != 0 ? new PDOMCPPParameter(this.pdom, rec) : null;
    }

    private void setFirstParameter(PDOMCPPParameter param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 32, rec);
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getByte(this.record + 44), 2);
    }

    public boolean isExternC() throws DOMException {
        return this.getBit(this.getByte(this.record + 44), 6);
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 28);
            IParameter[] params = new IParameter[n];
            PDOMCPPParameter param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new IParameter[0];
        }
    }

    public IFunctionType getType() {
        try {
            int offset = this.pdom.getDB().getInt(this.record + 36);
            return offset == 0 ? null : new PDOMCPPFunctionType(this.pdom, offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log((Throwable)ce);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 44), 1);
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 44), 4);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getByte(this.record + 44), 5);
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        IFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        try {
            result.append(" " + PDOMCPPFunction.getConstantNameForValue(this.getLinkageImpl(), this.getNodeType()));
        }
        catch (CoreException coreException) {
            result.append(" " + this.getNodeType());
        }
        return result.toString();
    }

    protected static int compareSignatures(IPDOMOverloader a, Object b) {
        if (b instanceof IPDOMOverloader) {
            IPDOMOverloader bb = (IPDOMOverloader)b;
            try {
                int mySM = a.getSignatureHash();
                int otherSM = bb.getSignatureHash();
                return mySM == otherSM ? 0 : (mySM < otherSM ? -1 : 1);
            }
            catch (CoreException ce) {
                CCorePlugin.log((Throwable)ce);
            }
        } else {
            throw new PDOMNotImplementedError(b.getClass().toString());
        }
        return 0;
    }
}

