/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.index.PointerTypeClone;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMPointerType;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPPointerToMemberType
extends PDOMPointerType
implements ICPPPointerToMemberType {
    private static final int TYPE = 13;
    private static final int RECORD_SIZE = 17;

    public PDOMCPPPointerToMemberType(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCPPPointerToMemberType(PDOM pdom, PDOMNode parent, ICPPPointerToMemberType type) throws CoreException {
        super(pdom, parent, type);
        PDOMNode targetTypeNode;
        Database db = pdom.getDB();
        IType ct = type.getMemberOfClass();
        int typeRec = 0;
        if (ct != null && (targetTypeNode = this.getLinkageImpl().addType(this, ct)) != null) {
            typeRec = targetTypeNode.getRecord();
        }
        db.putInt(this.record + 13, typeRec);
    }

    protected int getRecordSize() {
        return 17;
    }

    public int getNodeType() {
        return 18;
    }

    public IType getMemberOfClass() {
        try {
            int rec = this.pdom.getDB().getInt(this.record + 13);
            return (IType)((Object)this.getLinkageImpl().getNode(rec));
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public Object clone() {
        return new PDOMCPPPointerToMemberTypeClone(this);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getMemberOfClass(), this.record);
        super.delete(linkage);
    }

    private static class PDOMCPPPointerToMemberTypeClone
    extends PointerTypeClone
    implements ICPPPointerToMemberType {
        public PDOMCPPPointerToMemberTypeClone(ICPPPointerToMemberType pointer) {
            super(pointer);
        }

        public IType getMemberOfClass() {
            return ((ICPPPointerToMemberType)this.delegate).getMemberOfClass();
        }

        public Object clone() {
            return new PDOMCPPPointerToMemberTypeClone((ICPPPointerToMemberType)this.delegate);
        }
    }
}

