/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.pdom.AbstractIndexerTask;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.indexer.AbstractPDOMIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.TodoTaskUpdater;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;

public abstract class PDOMIndexerTask
extends AbstractIndexerTask
implements IPDOMIndexerTask {
    private static final String TRUE = "true";
    private AbstractPDOMIndexer fIndexer;
    private boolean fWriteInfoToLog;

    protected PDOMIndexerTask(ITranslationUnit[] forceFiles, ITranslationUnit[] updateFiles, ITranslationUnit[] removeFiles, AbstractPDOMIndexer indexer, boolean isFastIndexer) {
        super(PDOMIndexerTask.concat(forceFiles, updateFiles), removeFiles, new ProjectIndexerInputAdapter(indexer.getProject()), isFastIndexer);
        this.fIndexer = indexer;
        this.setShowActivity(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/activity", TRUE));
        this.setShowInclusionProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems/inclusion", TRUE));
        this.setShowScannerProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems/scanner", TRUE));
        this.setShowSyntaxProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems/syntax", TRUE));
        this.setShowProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems", TRUE));
        if (this.checkProperty("skipReferences")) {
            this.setSkipReferences(SKIP_ALL_REFERENCES);
        } else {
            int skipRefs = 0;
            if (this.checkProperty("skipTypeReferences")) {
                skipRefs |= SKIP_TYPE_REFERENCES;
            }
            if (this.checkProperty("skipMacroReferences")) {
                skipRefs |= SKIP_MACRO_REFERENCES;
            }
            if (skipRefs != 0) {
                this.setSkipReferences(skipRefs);
            }
        }
        if (this.getIndexAllFiles()) {
            this.setIndexFilesWithoutBuildConfiguration(true);
            this.setIndexHeadersWithoutContext(true);
        } else {
            this.setIndexFilesWithoutBuildConfiguration(false);
            this.setIndexHeadersWithoutContext(false);
        }
        this.setUpdateFlags(2);
        this.setForceFirstFiles(forceFiles.length);
    }

    private static ITranslationUnit[] concat(ITranslationUnit[] added, ITranslationUnit[] changed) {
        ITranslationUnit[] result = new ITranslationUnit[added.length + changed.length];
        System.arraycopy(added, 0, result, 0, added.length);
        System.arraycopy(changed, 0, result, added.length, changed.length);
        return result;
    }

    public final void setParseUpFront() {
        this.setParseUpFront(this.fIndexer.getFilesToParseUpFront());
    }

    public final IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    public final void run(IProgressMonitor monitor) throws InterruptedException {
        long start = System.currentTimeMillis();
        this.runTask(monitor);
        this.traceEnd(start, this.fIndex, monitor.isCanceled());
    }

    public static boolean checkDebugOption(String option, String value) {
        String trace = Platform.getDebugOption((String)option);
        boolean internallyActivated = Boolean.getBoolean(option);
        return internallyActivated || trace != null && trace.equalsIgnoreCase(value);
    }

    private boolean getIndexAllFiles() {
        return this.checkProperty("indexAllFiles");
    }

    private boolean checkProperty(String key) {
        return TRUE.equals(this.getIndexer().getProperty(key));
    }

    protected String getASTPathForParsingUpFront() {
        IProject project = this.getProject().getProject();
        IPath prjLocation = project.getLocation();
        if (prjLocation == null) {
            return null;
        }
        return prjLocation.append(super.getASTPathForParsingUpFront()).toString();
    }

    protected AbstractLanguage[] getLanguages(String filename) {
        ILanguage l;
        IContentType ct = CCorePlugin.getContentType((IProject)this.getProject().getProject(), (String)filename);
        if (ct != null && (l = LanguageManager.getInstance().getLanguage(ct)) instanceof AbstractLanguage) {
            ILanguage l2;
            if (ct.getId().equals("org.eclipse.cdt.core.cxxHeader") && l.getLinkageID() == 1 && (l2 = LanguageManager.getInstance().getLanguageForContentTypeID("org.eclipse.cdt.core.cHeader")) instanceof AbstractLanguage) {
                return new AbstractLanguage[]{(AbstractLanguage)l, (AbstractLanguage)l2};
            }
            return new AbstractLanguage[]{(AbstractLanguage)l};
        }
        return new AbstractLanguage[0];
    }

    protected IScannerInfo createDefaultScannerConfig(int linkageID) {
        IScannerInfo scanInfo;
        IProject project = this.getProject().getProject();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null) {
            String filename = linkageID == 2 ? "__cdt__.c" : "__cdt__.cpp";
            IFile file = project.getFile(filename);
            scanInfo = provider.getScannerInformation((IResource)file);
            if (scanInfo == null || scanInfo.getDefinedSymbols().isEmpty()) {
                scanInfo = provider.getScannerInformation((IResource)project);
            }
            if (linkageID == 2) {
                Map<String, String> definedSymbols = scanInfo.getDefinedSymbols();
                definedSymbols.remove("__cplusplus__");
                definedSymbols.remove("__cplusplus");
            }
        } else {
            scanInfo = new ScannerInfo();
        }
        return scanInfo;
    }

    private ICProject getProject() {
        return this.getIndexer().getProject();
    }

    protected final IWritableIndex createIndex() {
        try {
            return ((IWritableIndexManager)CCorePlugin.getIndexManager()).getWritableIndex(this.getProject());
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    protected final ITodoTaskUpdater createTodoTaskUpdater() {
        return new TodoTaskUpdater();
    }

    protected void traceEnd(long start, IWritableIndex index, boolean wasCancelled) {
        if (this.fWriteInfoToLog && !wasCancelled && index != null) {
            long totalTime = System.currentTimeMillis() - start;
            IndexerProgress info = this.getProgressInformation();
            int sum = this.fStatistics.fDeclarationCount + this.fStatistics.fReferenceCount + this.fStatistics.fProblemBindingCount;
            double problemPct = sum == 0 ? 0.0 : (double)this.fStatistics.fProblemBindingCount / (double)sum;
            NumberFormat nfGroup = NumberFormat.getNumberInstance();
            nfGroup.setGroupingUsed(true);
            NumberFormat nfPercent = NumberFormat.getPercentInstance();
            nfPercent.setMaximumFractionDigits(2);
            nfPercent.setMinimumFractionDigits(2);
            NumberFormat nfTime = NumberFormat.getNumberInstance();
            nfTime.setMaximumFractionDigits(2);
            nfTime.setMinimumFractionDigits(2);
            nfTime.setGroupingUsed(true);
            String msg = NLS.bind((String)Messages.PDOMIndexerTask_indexerInfo, (Object[])new Object[]{this.getCProject().getElementName(), nfGroup.format(info.fCompletedSources), nfGroup.format(info.fCompletedHeaders), nfTime.format((double)totalTime / 1000.0), nfGroup.format(this.fStatistics.fDeclarationCount), nfGroup.format(this.fStatistics.fReferenceCount), nfGroup.format(this.fStatistics.fUnresolvedIncludesCount), nfGroup.format(this.fStatistics.fPreprocessorProblemCount + this.fStatistics.fSyntaxProblemsCount), nfGroup.format(this.fStatistics.fProblemBindingCount), nfPercent.format(problemPct)});
            CCorePlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.cdt.core", msg));
        }
        if (PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/statistics", TRUE)) {
            String ident = "   ";
            long totalTime = System.currentTimeMillis() - start;
            IndexerProgress info = this.getProgressInformation();
            int sum = this.fStatistics.fDeclarationCount + this.fStatistics.fReferenceCount + this.fStatistics.fProblemBindingCount;
            double problemPct = sum == 0 ? 0.0 : (double)this.fStatistics.fProblemBindingCount / (double)sum;
            String kind = this.getIndexer().getClass().getName();
            kind = kind.substring(kind.lastIndexOf(46) + 1);
            long dbSize = index.getDatabaseSizeBytes();
            System.out.println("C/C++ Indexer: Project '" + this.getProject().getElementName() + "' (" + info.fCompletedSources + " sources, " + info.fCompletedHeaders + " headers)");
            boolean allFiles = this.getIndexAllFiles();
            boolean skipRefs = this.checkProperty("skipReferences");
            boolean skipTypeRefs = skipRefs || this.checkProperty("skipTypeReferences");
            boolean skipMacroRefs = skipRefs || this.checkProperty("skipMacroReferences");
            System.out.println(String.valueOf(ident) + " Options: " + "indexer='" + kind + "', parseAllFiles=" + allFiles + ", skipReferences=" + skipRefs + ", skipTypeReferences=" + skipTypeRefs + ", skipMacroReferences=" + skipMacroRefs + ".");
            System.out.println(String.valueOf(ident) + " Database: " + dbSize + " bytes");
            System.out.println(String.valueOf(ident) + " Timings: " + totalTime + " total, " + this.fStatistics.fParsingTime + " parser, " + this.fStatistics.fResolutionTime + " resolution, " + this.fStatistics.fAddToIndexTime + " index update.");
            System.out.println(String.valueOf(ident) + " Errors: " + this.fStatistics.fErrorCount + " internal, " + this.fStatistics.fUnresolvedIncludesCount + " include, " + this.fStatistics.fPreprocessorProblemCount + " scanner, " + this.fStatistics.fSyntaxProblemsCount + " syntax errors.");
            NumberFormat nfPercent = NumberFormat.getPercentInstance();
            nfPercent.setMaximumFractionDigits(2);
            nfPercent.setMinimumFractionDigits(2);
            System.out.println(String.valueOf(ident) + " Names: " + this.fStatistics.fDeclarationCount + " declarations, " + this.fStatistics.fReferenceCount + " references, " + this.fStatistics.fProblemBindingCount + "(" + nfPercent.format(problemPct) + ") unresolved.");
            long misses = index.getCacheMisses();
            long hits = index.getCacheHits();
            long tries = misses + hits;
            double missPct = tries == 0L ? 0.0 : (double)misses / (double)tries;
            System.out.println(String.valueOf(ident) + " Cache[" + ChunkCache.getSharedInstance().getMaxSize() / 1024L / 1024L + "mb]: " + hits + " hits, " + misses + "(" + nfPercent.format(missPct) + ") misses.");
            if (TRUE.equals(System.getProperty("SHOW_COMPRESSED_INDEXER_INFO"))) {
                Calendar cal = Calendar.getInstance();
                NumberFormat twoDigits = NumberFormat.getNumberInstance();
                twoDigits.setMinimumIntegerDigits(2);
                NumberFormat nfGroup = NumberFormat.getNumberInstance();
                nfGroup.setGroupingUsed(true);
                System.out.print("|");
                System.out.print(String.valueOf(cal.get(1)) + twoDigits.format(cal.get(2) + 1) + twoDigits.format(cal.get(5)));
                System.out.print("|  ");
                System.out.print(nfGroup.format(info.fCompletedSources));
                System.out.print("|  ");
                System.out.print(nfGroup.format(info.fCompletedHeaders));
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((totalTime + 500L) / 1000L)) + "s");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((this.fStatistics.fParsingTime + 500) / 1000)) + "s");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((this.fStatistics.fResolutionTime + 500) / 1000)) + "s");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((this.fStatistics.fAddToIndexTime + 500) / 1000)) + "s");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((dbSize + 524288L) / 1024L / 1024L)) + "mb");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((tries + 500000L) / 1000000L)) + "M");
                System.out.print("|  ");
                System.out.print(nfGroup.format(this.fStatistics.fDeclarationCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format(this.fStatistics.fReferenceCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format(this.fStatistics.fProblemBindingCount));
                System.out.print("|  ");
                System.out.print(nfPercent.format(problemPct));
                System.out.print("|  ");
                System.out.print(nfGroup.format(this.fStatistics.fErrorCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format(this.fStatistics.fUnresolvedIncludesCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format(this.fStatistics.fPreprocessorProblemCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format(this.fStatistics.fSyntaxProblemsCount));
                System.out.println("|");
            }
        }
    }

    protected ICProject getCProject() {
        return this.fIndexer.project;
    }

    public void setWriteInfoToLog() {
        this.fWriteInfoToLog = true;
    }
}

