/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.index.IIndexBindingConstants;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.MacroContainerFinder;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMArrayType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMPointerType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMQualifierType;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMLinkage
extends PDOMNamedNode
implements IIndexLinkage,
IIndexBindingConstants {
    private static final int ID_OFFSET = 12;
    private static final int NEXT_OFFSET = 16;
    private static final int INDEX_OFFSET = 20;
    private static final int NESTED_BINDINGS_INDEX = 24;
    private static final int MACRO_BTREE = 28;
    protected static final int RECORD_SIZE = 32;
    protected static final int LINKAGE = 0;
    private BTree fMacroIndex = null;

    public PDOMLinkage(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected PDOMLinkage(PDOM pdom, String languageId, char[] name) throws CoreException {
        super(pdom, null, name);
        Database db = pdom.getDB();
        db.putInt(this.record + 12, db.newString(languageId).getRecord());
        pdom.insertLinkage(this);
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 0;
    }

    public static IString getId(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int namerec = db.getInt(record + 12);
        return db.getString(namerec);
    }

    public static int getNextLinkageRecord(PDOM pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 16);
    }

    public void setNext(int nextrec) throws CoreException {
        this.pdom.getDB().putInt(this.record + 16, nextrec);
    }

    public BTree getIndex() throws CoreException {
        return new BTree(this.pdom.getDB(), this.record + 20, this.getIndexComparator());
    }

    public BTree getNestedBindingsIndex() throws CoreException {
        return new BTree(this.getPDOM().getDB(), this.record + 24, this.getNestedBindingsComparator());
    }

    public void accept(final IPDOMVisitor visitor) throws CoreException {
        if (visitor instanceof IBTreeVisitor) {
            this.getIndex().accept((IBTreeVisitor)((Object)visitor));
        } else {
            this.getIndex().accept(new IBTreeVisitor(){

                public int compare(int record) throws CoreException {
                    return 0;
                }

                public boolean visit(int record) throws CoreException {
                    PDOMNode node = PDOMLinkage.this.getNode(record);
                    if (node != null) {
                        if (visitor.visit(node)) {
                            node.accept(visitor);
                        }
                        visitor.leave(node);
                    }
                    return true;
                }
            });
        }
    }

    public ILinkage getLinkage() throws CoreException {
        return this;
    }

    public final void addChild(PDOMNode child) throws CoreException {
        this.getIndex().insert(child.getRecord());
    }

    public PDOMNode getNode(int record) throws CoreException {
        switch (PDOMNode.getNodeType(this.pdom, record)) {
            case 1: {
                return new PDOMPointerType(this.pdom, record);
            }
            case 2: {
                return new PDOMArrayType(this.pdom, record);
            }
            case 3: {
                return new PDOMQualifierType(this.pdom, record);
            }
        }
        return null;
    }

    public PDOMNode addType(PDOMNode parent, IType type) throws CoreException {
        if (type instanceof IPointerType) {
            return new PDOMPointerType(this.pdom, parent, (IPointerType)type);
        }
        if (type instanceof IArrayType) {
            return new PDOMArrayType(this.pdom, parent, (IArrayType)type);
        }
        if (type instanceof IQualifierType) {
            return new PDOMQualifierType(this.pdom, parent, (IQualifierType)type);
        }
        return null;
    }

    public abstract IBTreeComparator getIndexComparator();

    public IBTreeComparator getNestedBindingsComparator() {
        return new FindBinding.NestedBindingsBTreeComparator(this);
    }

    protected boolean cannotAdapt(IBinding inputBinding) throws CoreException {
        PDOMBinding pdomBinding;
        if (inputBinding == null || inputBinding instanceof IProblemBinding || inputBinding instanceof IParameter) {
            return true;
        }
        return inputBinding instanceof PDOMBinding && (pdomBinding = (PDOMBinding)inputBinding).getPDOM() != this.getPDOM() && pdomBinding.isFileLocal();
    }

    protected final PDOMBinding attemptFastAdaptBinding(IBinding binding) throws CoreException {
        PDOMBinding pdomBinding;
        if (binding instanceof PDOMBinding && (pdomBinding = (PDOMBinding)binding).getPDOM() == this.getPDOM()) {
            return pdomBinding;
        }
        return (PDOMBinding)this.pdom.getCachedResult(binding);
    }

    public abstract PDOMBinding adaptBinding(IBinding var1) throws CoreException;

    public abstract PDOMBinding addBinding(IASTName var1) throws CoreException;

    protected final int getLocalToFileRec(PDOMNode parent, IBinding binding) throws CoreException {
        PDOMFile file;
        int rec = 0;
        if (parent instanceof PDOMBinding) {
            rec = ((PDOMBinding)parent).getLocalToFileRec();
        }
        if (rec == 0 && (file = this.getLocalToFile(binding)) != null) {
            rec = file.getRecord();
        }
        return rec;
    }

    protected PDOMFile getLocalToFile(IBinding binding) throws CoreException {
        if (this.pdom instanceof WritablePDOM) {
            String path;
            WritablePDOM wpdom;
            block11: {
                wpdom = (WritablePDOM)this.pdom;
                try {
                    if (!(binding instanceof IField)) break block11;
                    return null;
                }
                catch (DOMException dOMException) {}
            }
            boolean checkInSourceOnly = false;
            boolean requireDefinition = false;
            if (binding instanceof IVariable) {
                if (!(binding instanceof IField)) {
                    checkInSourceOnly = ASTInternal.isStatic((IVariable)binding);
                }
            } else if (binding instanceof IFunction) {
                IFunction f = (IFunction)binding;
                checkInSourceOnly = ASTInternal.isStatic(f, false);
            } else if (binding instanceof ITypedef || binding instanceof ICompositeType || binding instanceof IEnumeration) {
                checkInSourceOnly = true;
                requireDefinition = true;
            }
            if (checkInSourceOnly && (path = ASTInternal.getDeclaredInSourceFileOnly(binding, requireDefinition)) != null) {
                return wpdom.getFileForASTPath(this.getLinkageID(), path);
            }
        }
        return null;
    }

    public abstract int getBindingType(IBinding var1);

    public void onCreateName(PDOMFile file, IASTName name, PDOMName pdomName) throws CoreException {
        IASTDeclSpecifier ds;
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof IASTDeclSpecifier && (ds = (IASTDeclSpecifier)parentNode).getStorageClass() == 1 && pdomName.getEnclosingDefinitionRecord() != 0) {
            pdomName.setIsBaseSpecifier(true);
        }
    }

    public void onDeleteName(PDOMName name) throws CoreException {
    }

    public void afterAddBinding(PDOMBinding pdomBinding) throws CoreException {
        if (pdomBinding.getParentNodeRec() != this.record) {
            this.getNestedBindingsIndex().insert(pdomBinding.getRecord());
        }
    }

    public void beforeRemoveBinding(PDOMBinding pdomBinding) throws CoreException {
        if (pdomBinding.getParentNodeRec() != this.record) {
            this.getNestedBindingsIndex().delete(pdomBinding.getRecord());
        }
    }

    public void deleteType(IType type, int ownerRec) throws CoreException {
        PDOMNode node;
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getParentNodeRec() == ownerRec) {
            assert (!(node instanceof IBinding));
            node.delete(this);
        }
    }

    public void deleteBinding(IBinding binding) throws CoreException {
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        assert (false);
    }

    public ICPPUsingDirective[] getUsingDirectives(PDOMFile file) throws CoreException {
        return ICPPUsingDirective.EMPTY_ARRAY;
    }

    public BTree getMacroIndex() {
        if (this.fMacroIndex == null) {
            this.fMacroIndex = new BTree(this.pdom.getDB(), this.record + 28, new FindBinding.MacroBTreeComparator(this.pdom));
        }
        return this.fMacroIndex;
    }

    public PDOMMacroContainer findMacroContainer(char[] name) throws CoreException {
        return this.findMacroContainer(name, this.pdom.createKeyForCache(this.record, name));
    }

    private PDOMMacroContainer findMacroContainer(char[] name, String key) throws CoreException {
        Object result = this.pdom.getCachedResult(key);
        if (result instanceof PDOMMacroContainer) {
            return (PDOMMacroContainer)result;
        }
        assert (result == null);
        MacroContainerFinder visitor = new MacroContainerFinder(this.pdom, name);
        this.getMacroIndex().accept(visitor);
        PDOMMacroContainer container = visitor.getMacroContainer();
        if (container != null) {
            this.pdom.putCachedResult(key, container);
        }
        return container;
    }

    public PDOMMacroContainer getMacroContainer(char[] name) throws CoreException {
        String key = this.pdom.createKeyForCache(this.record, name);
        PDOMMacroContainer result = this.findMacroContainer(name, key);
        if (result == null) {
            result = new PDOMMacroContainer(this.pdom, this, name);
            this.getMacroIndex().insert(result.getRecord());
            this.pdom.putCachedResult(key, result);
        }
        return result;
    }

    public void removeMacroContainer(PDOMMacroContainer container) throws CoreException {
        String key = this.pdom.createKeyForCache(this.record, container.getNameCharArray());
        this.pdom.putCachedResult(key, null);
        this.getMacroIndex().delete(container.getRecord());
    }

    public String toString() {
        return this.getLinkageName();
    }
}

