/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteFileManager;

public class LocalFileManager
implements IRemoteFileManager {
    public IFileStore getResource(IPath path, IProgressMonitor monitor) throws IOException {
        try {
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(path);
            return iFileStore;
        }
        finally {
            monitor.done();
        }
    }

    public IPath getWorkingDirectory() {
        return new Path(System.getProperty("user.dir"));
    }

    public IPath toPath(URI uri) {
        return URIUtil.toPath((URI)uri);
    }

    public URI toURI(IPath path) {
        return URIUtil.toURI((IPath)path);
    }
}

