/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.IProcessChangeEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.elements.listeners.IProcessListener;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.core.utils.IInputStreamListener;
import org.eclipse.ptp.rm.core.utils.InputStreamListenerToOutputStream;
import org.eclipse.ptp.rm.core.utils.InputStreamObserver;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2JobAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2LaunchAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPICH2RuntimeSystemJob
extends AbstractToolRuntimeSystemJob {
    private Object lock1 = new Object();
    private InputStreamObserver stderrObserver;
    private InputStreamObserver stdoutObserver;
    protected final ReentrantLock procsLock = new ReentrantLock();
    protected final Condition procsCondition = this.procsLock.newCondition();
    protected int numRunningProcs = 0;
    protected IProcessListener processListener = new IProcessListener(){

        public void handleEvent(IProcessChangeEvent e) {
            if (e.getAttributes().getAttribute((IAttributeDefinition)ProcessAttributes.getStateAttributeDefinition()) != null && e.getSource().getState() == ProcessAttributes.State.RUNNING) {
                MPICH2RuntimeSystemJob.this.procsLock.lock();
                try {
                    ++MPICH2RuntimeSystemJob.this.numRunningProcs;
                    MPICH2RuntimeSystemJob.this.procsCondition.signalAll();
                }
                finally {
                    MPICH2RuntimeSystemJob.this.procsLock.unlock();
                }
            }
        }
    };
    protected IJobChildListener jobChildListener = new IJobChildListener(){

        public void handleEvent(IChangedProcessEvent e) {
        }

        public void handleEvent(INewProcessEvent e) {
            for (IPProcess process : e.getProcesses()) {
                process.addElementListener(MPICH2RuntimeSystemJob.this.processListener);
            }
        }

        public void handleEvent(IRemoveProcessEvent e) {
            for (IPProcess process : e.getProcesses()) {
                process.removeElementListener(MPICH2RuntimeSystemJob.this.processListener);
            }
        }
    };

    public MPICH2RuntimeSystemJob(String jobID, String queueID, String name, AbstractToolRuntimeSystem rtSystem, AttributeManager attrMgr) {
        super(jobID, queueID, name, rtSystem, attrMgr);
    }

    private void changeAllProcessesStatus(ProcessAttributes.State newState) {
        MPICH2RuntimeSystem rtSystem = (MPICH2RuntimeSystem)this.getRtSystem();
        IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
        ArrayList<String> ids = new ArrayList<String>();
        IPProcess[] iPProcessArray = ipJob.getProcesses();
        int n = iPProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPProcess ipProcess = iPProcessArray[n2];
            switch (ipProcess.getState()) {
                case EXITED: 
                case EXITED_SIGNALLED: 
                case ERROR: {
                    break;
                }
                case STARTING: 
                case RUNNING: 
                case SUSPENDED: 
                case UNKNOWN: {
                    ids.add(ipProcess.getID());
                }
            }
            ++n2;
        }
        AttributeManager attrMrg = new AttributeManager();
        attrMrg.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)newState));
        for (String processId : ids) {
            rtSystem.changeProcess(processId, attrMrg);
        }
    }

    protected void doBeforeExecution(IProgressMonitor monitor) throws CoreException {
        MPICH2RuntimeSystem rtSystem = (MPICH2RuntimeSystem)this.getRtSystem();
        IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
        ipJob.addChildListener(this.jobChildListener);
    }

    protected void doExecutionCleanUp(IProgressMonitor monitor) {
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.stderrObserver != null) {
            this.stderrObserver.kill();
            this.stderrObserver = null;
        }
        if (this.stdoutObserver != null) {
            this.stdoutObserver.kill();
            this.stdoutObserver = null;
        }
        this.changeAllProcessesStatus(ProcessAttributes.State.EXITED);
    }

    protected void doExecutionFinished(IProgressMonitor monitor) throws CoreException {
        this.changeAllProcessesStatus(ProcessAttributes.State.EXITED);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecutionStarted(IProgressMonitor monitor) throws CoreException {
        PipedInputStream stderrInputStream;
        PipedOutputStream stderrOutputStream;
        Thread stdoutThread;
        InputStreamListenerToOutputStream stdoutPipedStreamListener;
        IPJob ipJob;
        block13: {
            PipedInputStream stdoutInputStream;
            PipedOutputStream stdoutOutputStream;
            block12: {
                MPICH2RuntimeSystem rtSystem = (MPICH2RuntimeSystem)this.getRtSystem();
                ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
                stdoutOutputStream = new PipedOutputStream();
                stdoutInputStream = new PipedInputStream();
                try {
                    stdoutInputStream.connect(stdoutOutputStream);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError();
                }
            }
            stdoutPipedStreamListener = new InputStreamListenerToOutputStream((OutputStream)stdoutOutputStream);
            stdoutThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block13: {
                        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: started", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID()});
                        BufferedReader stdoutBufferedReader = new BufferedReader(new InputStreamReader(stdoutInputStream));
                        try {
                            try {
                                String line = stdoutBufferedReader.readLine();
                                while (line != null) {
                                    int index = 0;
                                    int pos = line.indexOf(": ");
                                    if (pos > 0) {
                                        try {
                                            index = Integer.parseInt(line.substring(0, pos));
                                            line = line.substring(pos + 1);
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    }
                                    Object object = MPICH2RuntimeSystemJob.this.lock1;
                                    synchronized (object) {
                                        IPProcess ipProc = ipJob.getProcessByIndex(index);
                                        if (ipProc != null) {
                                            ipProc.addAttribute((IAttribute)ProcessAttributes.getStdoutAttributeDefinition().create(line));
                                        }
                                        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}:> {1}", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.jobID, line});
                                    }
                                    line = stdoutBufferedReader.readLine();
                                }
                            }
                            catch (IOException e) {
                                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: {0}", (Object[])new Object[]{e});
                                MPICH2Plugin.log(e);
                                stdoutPipedStreamListener.disable();
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            stdoutPipedStreamListener.disable();
                            throw throwable;
                        }
                        stdoutPipedStreamListener.disable();
                    }
                    DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: finished", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.jobID});
                }
            };
            stderrOutputStream = new PipedOutputStream();
            stderrInputStream = new PipedInputStream();
            try {
                stderrInputStream.connect(stderrOutputStream);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        final InputStreamListenerToOutputStream stderrPipedStreamListener = new InputStreamListenerToOutputStream((OutputStream)stderrOutputStream);
        Thread stderrThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block13: {
                    DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: started", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID()});
                    BufferedReader stderrBufferedReader = new BufferedReader(new InputStreamReader(stderrInputStream));
                    try {
                        try {
                            String line = stderrBufferedReader.readLine();
                            while (line != null) {
                                int index = 0;
                                int pos = line.indexOf(": ");
                                if (pos > 0) {
                                    try {
                                        index = Integer.parseInt(line.substring(0, pos));
                                        line = line.substring(pos + 1);
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                                Object object = MPICH2RuntimeSystemJob.this.lock1;
                                synchronized (object) {
                                    IPProcess ipProc = ipJob.getProcessByIndex(index);
                                    if (ipProc != null) {
                                        ipProc.addAttribute((IAttribute)ProcessAttributes.getStderrAttributeDefinition().create(line));
                                    }
                                    DebugUtil.error((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}:> {1}", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID(), line});
                                }
                                line = stderrBufferedReader.readLine();
                            }
                        }
                        catch (IOException e) {
                            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: {1}", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID(), e});
                            MPICH2Plugin.log(e);
                            stderrPipedStreamListener.disable();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        stderrPipedStreamListener.disable();
                        throw throwable;
                    }
                    stderrPipedStreamListener.disable();
                }
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: finished", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID()});
            }
        };
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: starting all threads", (Object[])new Object[]{this.getJobID()});
        stdoutThread.start();
        stderrThread.start();
        this.stderrObserver = new InputStreamObserver(this.process.getErrorStream());
        this.stdoutObserver = new InputStreamObserver(this.process.getInputStream());
        this.stdoutObserver.addListener((IInputStreamListener)stdoutPipedStreamListener);
        this.stderrObserver.addListener((IInputStreamListener)stderrPipedStreamListener);
        this.stderrObserver.start();
        this.stdoutObserver.start();
        int numProcs = 1;
        IntegerAttribute numProcsAttr = (IntegerAttribute)this.attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getNumberOfProcessesAttributeDefinition());
        if (numProcsAttr != null) {
            numProcs = numProcsAttr.getValue();
        }
        this.procsLock.lock();
        try {
            block15: {
                block14: {
                    if (!true) break block14;
                    if (monitor.isCanceled()) return;
                    if (this.numRunningProcs >= numProcs) break block15;
                }
                do {
                    try {
                        this.procsCondition.await(500L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (monitor.isCanceled()) return;
                } while (this.numRunningProcs < numProcs);
            }
            return;
        }
        finally {
            this.procsLock.unlock();
        }
    }

    protected void doPrepareExecution(IProgressMonitor monitor) throws CoreException {
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolBaseSubstitutionAttributes() throws CoreException {
        return null;
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolCommandSubstitutionAttributes(AttributeManager baseSubstitutionAttributeManager, String directory, Map<String, String> environment) {
        ArrayList<Object> newAttributes = new ArrayList<Object>();
        int p = 0;
        String[] keys = new String[environment.size()];
        for (String key : environment.keySet()) {
            keys[p++] = key;
        }
        newAttributes.add((IAttribute)MPICH2LaunchAttributes.getEnvironmentKeysAttributeDefinition().create((Comparable[])keys));
        newAttributes.add(MPICH2LaunchAttributes.getEnvironmentArgsAttributeDefinition().create());
        newAttributes.add(MPICH2JobAttributes.getJobIdAttributeDefinition().create(this.jobID));
        return newAttributes.toArray(new IAttribute[newAttributes.size()]);
    }

    protected HashMap<String, String> doRetrieveToolEnvironment() throws CoreException {
        return null;
    }

    protected void doTerminateJob() {
    }

    protected void doWaitExecution(IProgressMonitor monitor) throws CoreException {
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stderr thread to finish", (Object[])new Object[]{this.jobID});
        try {
            this.stderrObserver.join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stdout thread to finish", (Object[])new Object[]{this.jobID});
        try {
            this.stdoutObserver.join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting mpi process to finish completely", (Object[])new Object[]{this.jobID});
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: completely finished", (Object[])new Object[]{this.jobID});
    }
}

