/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.stream.IStreamListener;
import org.eclipse.ptp.cell.utils.stream.Messages;

public class StreamObserver
extends Thread {
    private InputStream input;
    private boolean killed;
    private String name;
    private IStreamListener listener;
    boolean hasclosed = false;
    static final int BUFFER_SIZE = 100;

    public StreamObserver(InputStream input, IStreamListener listener, String name) {
        Debug.read();
        this.name = name;
        this.input = input;
        this.listener = listener;
        this.setName(name);
    }

    public StreamObserver(InputStream input, IStreamListener listener) {
        Debug.read();
        this.name = this.getClass().getName();
        this.input = input;
        this.listener = listener;
        this.setName(this.name);
    }

    public synchronized void kill() {
        Debug.POLICY.trace(Debug.DEBUG_STREAM, "Marked as killed.");
        this.killed = true;
    }

    void streamClosed() {
        if (this.hasclosed) {
            return;
        }
        this.hasclosed = true;
        Debug.POLICY.trace(Debug.DEBUG_STREAM, "Notify stream closed.");
        try {
            this.listener.streamClosed();
        }
        catch (Exception e) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, e);
            Debug.POLICY.logError(e, Messages.StreamObserver_FailedDelegateMethod, new Object[0]);
        }
    }

    void streamError(Exception e) {
        Debug.POLICY.error(Debug.DEBUG_STREAM, "Notify exception: {0}.", e.getMessage());
        try {
            this.listener.streamError(e);
        }
        catch (Exception ee) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, ee);
            Debug.POLICY.logError(ee, Messages.StreamObserver_FailedDelegateMethod, new Object[0]);
        }
    }

    void newBytes(byte[] buffer, int length) {
        if (Debug.DEBUG_STREAM) {
            Debug.POLICY.trace("Notify received line: " + Integer.toString(length) + " bytes");
            if (Debug.DEBUG_STREAM_MORE) {
                Debug.POLICY.trace(new String(buffer, 0, length));
            }
        }
        try {
            this.listener.newBytes(buffer, length);
        }
        catch (Exception e) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, e);
            Debug.POLICY.logError(e, Messages.StreamObserver_FailedDelegateMethod, new Object[0]);
        }
    }

    public void run() {
        Debug.read();
        byte[] buffer = new byte[250];
        Debug.POLICY.trace(Debug.DEBUG_STREAM, "Started.");
        while (!this.killed) {
            try {
                int bytes = this.input.read(buffer);
                if (bytes > 0) {
                    this.newBytes(buffer, bytes);
                    continue;
                }
                if (bytes != -1) continue;
                this.streamClosed();
            }
            catch (IOException e) {
                if (this.killed) {
                    this.streamClosed();
                    break;
                }
                if (e instanceof EOFException) {
                    Debug.POLICY.trace(Debug.DEBUG_STREAM, "Expected EOFException.");
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
            }
            catch (NullPointerException e) {
                if (this.killed) {
                    Debug.POLICY.trace(Debug.DEBUG_STREAM, "Expected NullPointerException.");
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
            }
            break;
        }
        if (this.killed) {
            this.streamClosed();
        }
        Debug.POLICY.trace(Debug.DEBUG_STREAM, "Finished.");
    }
}

